/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.event.block.SpongeAbsorbEvent;

public class SpongeBlock
extends Block {
    public static final MapCodec<SpongeBlock> CODEC = SpongeBlock.simpleCodec(SpongeBlock::new);
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public MapCodec<SpongeBlock> codec() {
        return CODEC;
    }

    protected SpongeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.tryAbsorbWater(level, pos);
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        this.tryAbsorbWater(level, pos);
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
    }

    protected void tryAbsorbWater(Level level, BlockPos pos) {
        if (this.removeWaterBreadthFirstSearch(level, pos)) {
            level.setBlock(pos, Blocks.WET_SPONGE.defaultBlockState(), 2);
            level.playSound(null, pos, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level level, BlockPos pos) {
        BlockStateListPopulator blockList = new BlockStateListPopulator(level);
        BlockPos.breadthFirstTraversal(pos, 6, 65, (validPos, queueAdder) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                queueAdder.accept(validPos.relative(direction));
            }
        }, blockPos -> {
            BucketPickup bucketPickup;
            if (blockPos.equals(pos)) {
                return BlockPos.TraversalNodeStatus.ACCEPT;
            }
            BlockState blockState = blockList.getBlockState((BlockPos)blockPos);
            FluidState fluidState = blockList.getFluidState((BlockPos)blockPos);
            if (!fluidState.is(FluidTags.WATER)) {
                return BlockPos.TraversalNodeStatus.SKIP;
            }
            Block patt0$temp = blockState.getBlock();
            if (patt0$temp instanceof BucketPickup && !(bucketPickup = (BucketPickup)((Object)patt0$temp)).pickupBlock(null, blockList, (BlockPos)blockPos, blockState).isEmpty()) {
                return BlockPos.TraversalNodeStatus.ACCEPT;
            }
            if (blockState.getBlock() instanceof LiquidBlock) {
                blockList.setBlock((BlockPos)blockPos, Blocks.AIR.defaultBlockState(), 3);
            } else {
                if (!(blockState.is(Blocks.KELP) || blockState.is(Blocks.KELP_PLANT) || blockState.is(Blocks.SEAGRASS) || blockState.is(Blocks.TALL_SEAGRASS))) {
                    return BlockPos.TraversalNodeStatus.SKIP;
                }
                blockList.setBlock((BlockPos)blockPos, Blocks.AIR.defaultBlockState(), 3);
            }
            return BlockPos.TraversalNodeStatus.ACCEPT;
        });
        List<CraftBlockState> blocks = blockList.getList();
        if (!blocks.isEmpty()) {
            CraftBlock sponge = CraftBlock.at(level, pos);
            SpongeAbsorbEvent event = new SpongeAbsorbEvent((org.bukkit.block.Block)sponge, blocks);
            if (!event.callEvent()) {
                return false;
            }
            for (CraftBlockState block : blocks) {
                BucketPickup bucketPickup;
                Block block2;
                BlockPos blockPos2 = block.getPosition();
                BlockState state = level.getBlockState(blockPos2);
                FluidState fluid = level.getFluidState(blockPos2);
                if (fluid.is(FluidTags.WATER) && (!((block2 = state.getBlock()) instanceof BucketPickup) || (bucketPickup = (BucketPickup)((Object)block2)).pickupBlock(null, blockList, blockPos2, state).isEmpty()) && !(state.getBlock() instanceof LiquidBlock) && (state.is(Blocks.KELP) || state.is(Blocks.KELP_PLANT) || state.is(Blocks.SEAGRASS) || state.is(Blocks.TALL_SEAGRASS))) {
                    BlockEntity blockEntity;
                    BlockEntity blockEntity2 = blockEntity = state.hasBlockEntity() ? level.getBlockEntity(blockPos2) : null;
                    if (block.getHandle().isAir()) {
                        SpongeBlock.dropResources(state, level, blockPos2, blockEntity);
                    }
                }
                level.setBlock(blockPos2, block.getHandle(), block.getFlag());
            }
            return true;
        }
        return false;
    }
}

