/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public abstract class SpreadingSnowyDirtBlock
extends SnowyDirtBlock {
    protected SpreadingSnowyDirtBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        return SpreadingSnowyDirtBlock.canBeGrass(levelReader.getChunk(pos), state, levelReader, pos);
    }

    private static boolean canBeGrass(ChunkAccess chunk, BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = chunk.getBlockState(blockPos);
        if (blockState.is(Blocks.SNOW) && blockState.getValue(SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockState.getFluidState().getAmount() == 8) {
            return false;
        }
        int lightBlockInto = LightEngine.getLightBlockInto(state, blockState, Direction.UP, blockState.getLightBlock());
        return lightBlockInto < 15;
    }

    protected abstract MapCodec<? extends SpreadingSnowyDirtBlock> codec();

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        return SpreadingSnowyDirtBlock.canPropagate(level.getChunk(pos), state, level, pos);
    }

    private static boolean canPropagate(ChunkAccess chunk, BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.above();
        return SpreadingSnowyDirtBlock.canBeGrass(chunk, state, level, pos) && !chunk.getFluidState(blockPos).is(FluidTags.WATER);
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this instanceof GrassBlock && level.paperConfig().tickRates.grassSpread != 1 && (level.paperConfig().tickRates.grassSpread < 1 || (MinecraftServer.currentTick + pos.hashCode()) % level.paperConfig().tickRates.grassSpread != 0)) {
            return;
        }
        LevelChunk cachedBlockChunk = level.getChunkIfLoaded(pos);
        if (cachedBlockChunk == null) {
            return;
        }
        if (!SpreadingSnowyDirtBlock.canBeGrass(cachedBlockChunk, state, level, pos)) {
            if (CraftEventFactory.callBlockFadeEvent(level, pos, Blocks.DIRT.defaultBlockState()).isCancelled()) {
                return;
            }
            level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        } else if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
            BlockState blockState = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                LevelChunk access;
                BlockPos blockPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (pos.getX() == blockPos.getX() && pos.getY() == blockPos.getY() && pos.getZ() == blockPos.getZ() || !(access = cachedBlockChunk.locX == blockPos.getX() >> 4 && cachedBlockChunk.locZ == blockPos.getZ() >> 4 ? cachedBlockChunk : level.getChunkAt(blockPos)).getBlockState(blockPos).is(Blocks.DIRT) || !SpreadingSnowyDirtBlock.canPropagate(access, blockState, level, blockPos)) continue;
                CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos, (BlockState)blockState.setValue(SnowyDirtBlock.SNOWY, SpreadingSnowyDirtBlock.isSnowySetting(access.getBlockState(blockPos.above()))));
            }
        }
    }
}

