/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public interface SuspiciousEffectHolder {
    public SuspiciousStewEffects getSuspiciousEffects();

    public static List<SuspiciousEffectHolder> getAllEffectHolders() {
        return BuiltInRegistries.ITEM.stream().map(SuspiciousEffectHolder::tryGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static SuspiciousEffectHolder tryGet(ItemLike item) {
        BlockItem blockItem;
        Block var6;
        Item item2 = item.asItem();
        if (item2 instanceof BlockItem && (var6 = (blockItem = (BlockItem)item2).getBlock()) instanceof SuspiciousEffectHolder) {
            return (SuspiciousEffectHolder)((Object)var6);
        }
        Item suspiciousEffectHolder = item.asItem();
        return suspiciousEffectHolder instanceof SuspiciousEffectHolder ? (SuspiciousEffectHolder)((Object)suspiciousEffectHolder) : null;
    }
}

