/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WitherSkullBlock
extends SkullBlock {
    public static final MapCodec<WitherSkullBlock> CODEC = WitherSkullBlock.simpleCodec(WitherSkullBlock::new);
    @Nullable
    private static BlockPattern witherPatternFull;
    @Nullable
    private static BlockPattern witherPatternBase;

    public MapCodec<WitherSkullBlock> codec() {
        return CODEC;
    }

    protected WitherSkullBlock(BlockBehaviour.Properties properties) {
        super(SkullBlock.Types.WITHER_SKELETON, properties);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WitherSkullBlock.checkSpawn(level, pos);
    }

    public static void checkSpawn(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skullBlockEntity = (SkullBlockEntity)blockEntity;
            WitherSkullBlock.checkSpawn(level, pos, skullBlockEntity);
        }
    }

    public static void checkSpawn(Level level, BlockPos pos, SkullBlockEntity blockEntity) {
        if (level.captureBlockStates) {
            return;
        }
        if (!level.isClientSide) {
            WitherBoss witherBoss;
            BlockPattern.BlockPatternMatch blockPatternMatch;
            boolean flag;
            BlockState blockState = blockEntity.getBlockState();
            boolean bl = flag = blockState.is(Blocks.WITHER_SKELETON_SKULL) || blockState.is(Blocks.WITHER_SKELETON_WALL_SKULL);
            if (flag && pos.getY() >= level.getMinY() && level.getDifficulty() != Difficulty.PEACEFUL && (blockPatternMatch = WitherSkullBlock.getOrCreateWitherFull().find(level, pos)) != null && (witherBoss = EntityType.WITHER.create(level, EntitySpawnReason.TRIGGERED)) != null) {
                BlockPos pos1 = blockPatternMatch.getBlock(1, 2, 0).getPos();
                witherBoss.moveTo((double)pos1.getX() + 0.5, (double)pos1.getY() + 0.55, (double)pos1.getZ() + 0.5, blockPatternMatch.getForwards().getAxis() == Direction.Axis.X ? 0.0f : 90.0f, 0.0f);
                witherBoss.yBodyRot = blockPatternMatch.getForwards().getAxis() == Direction.Axis.X ? 0.0f : 90.0f;
                witherBoss.makeInvulnerable();
                if (!level.addFreshEntity(witherBoss, CreatureSpawnEvent.SpawnReason.BUILD_WITHER)) {
                    return;
                }
                CarvedPumpkinBlock.clearPatternBlocks(level, blockPatternMatch);
                for (ServerPlayer serverPlayer : level.getEntitiesOfClass(ServerPlayer.class, witherBoss.getBoundingBox().inflate(50.0))) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, witherBoss);
                }
                CarvedPumpkinBlock.updatePatternBlocks(level, blockPatternMatch);
            }
        }
    }

    public static boolean canSpawnMob(Level level, BlockPos pos, ItemStack stack) {
        return stack.is(Items.WITHER_SKELETON_SKULL) && pos.getY() >= level.getMinY() + 2 && level.getDifficulty() != Difficulty.PEACEFUL && !level.isClientSide && WitherSkullBlock.getOrCreateWitherBase().find(level, pos) != null;
    }

    private static BlockPattern getOrCreateWitherFull() {
        if (witherPatternFull == null) {
            witherPatternFull = BlockPatternBuilder.start().aisle("^^^", "###", "~#~").where('#', block -> block.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('^', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_SKULL).or(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_WALL_SKULL)))).where('~', block -> block.getState().isAir()).build();
        }
        return witherPatternFull;
    }

    private static BlockPattern getOrCreateWitherBase() {
        if (witherPatternBase == null) {
            witherPatternBase = BlockPatternBuilder.start().aisle("   ", "###", "~#~").where('#', block -> block.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('~', block -> block.getState().isAir()).build();
        }
        return witherPatternBase;
    }
}

