/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class BlockEntity {
    static boolean ignoreBlockEntityUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger LOGGER;
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private net.minecraft.world.level.block.state.BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> type, BlockPos pos, net.minecraft.world.level.block.state.BlockState blockState) {
        this.type = type;
        this.worldPosition = pos.immutable();
        this.validateBlockState(blockState);
        this.blockState = blockState;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void validateBlockState(net.minecraft.world.level.block.state.BlockState state) {
        if (!this.isValidBlockState(state)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(state));
        }
    }

    public boolean isValidBlockState(net.minecraft.world.level.block.state.BlockState state) {
        return this.type.isValid(state);
    }

    public static BlockPos getPosFromTag(CompoundTag tag) {
        return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.persistentDataContainer.clear();
        Tag persistentDataTag = tag.get("PublicBukkitValues");
        if (persistentDataTag instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)persistentDataTag);
        }
    }

    public final void loadWithComponents(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
        ComponentHelper.COMPONENTS_CODEC.parse(registries.createSerializationContext(NbtOps.INSTANCE), (Object)tag).resultOrPartial(string -> LOGGER.warn("Failed to load components: {}", string)).ifPresent(components -> {
            this.components = components;
        });
    }

    public final void loadCustomOnly(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider registries) {
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        this.saveMetadata(compoundTag);
        return compoundTag;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider registries) {
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        this.saveId(compoundTag);
        return compoundTag;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, registries);
        ComponentHelper.COMPONENTS_CODEC.encodeStart(registries.createSerializationContext(NbtOps.INSTANCE), (Object)this.components).resultOrPartial(string -> LOGGER.warn("Failed to save components: {}", string)).ifPresent(tag -> compoundTag.merge((CompoundTag)tag));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            compoundTag.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, registries);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            compoundTag.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider registries) {
        CompoundTag compoundTag = this.saveCustomOnly(registries);
        this.saveMetadata(compoundTag);
        return compoundTag;
    }

    public void saveId(CompoundTag tag) {
        ResourceLocation key = BlockEntityType.getKey(this.getType());
        if (key == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        tag.putString("id", key.toString());
    }

    public static void addEntityType(CompoundTag tag, BlockEntityType<?> entityType) {
        tag.putString("id", BlockEntityType.getKey(entityType).toString());
    }

    private void saveMetadata(CompoundTag tag) {
        this.saveId(tag);
        tag.putInt("x", this.worldPosition.getX());
        tag.putInt("y", this.worldPosition.getY());
        tag.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos pos, net.minecraft.world.level.block.state.BlockState state, CompoundTag tag, HolderLookup.Provider registries) {
        String string = tag.getString("id");
        ResourceLocation resourceLocation = ResourceLocation.tryParse(string);
        if (resourceLocation == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)string);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(resourceLocation).map(blockEntityType -> {
            try {
                return blockEntityType.create(pos, state);
            }
            catch (Throwable var5x) {
                LOGGER.error("Failed to create block entity {}", (Object)string, (Object)var5x);
                return null;
            }
        }).map(blockEntity -> {
            try {
                blockEntity.loadWithComponents(tag, registries);
                return blockEntity;
            }
            catch (Throwable var5x) {
                LOGGER.error("Failed to load data for block entity {}", (Object)string, (Object)var5x);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)string);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            if (ignoreBlockEntityUpdates) {
                return;
            }
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level level, BlockPos pos, net.minecraft.world.level.block.state.BlockState state) {
        level.blockEntityChanged(pos);
        if (!state.isAir()) {
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public net.minecraft.world.level.block.state.BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int id, int type) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory reportCategory) {
        reportCategory.setDetail("Name", this::getNameForReporting);
        if (this.level != null) {
            net.minecraft.world.level.block.state.BlockState block = this.getBlockState();
            if (block != null) {
                CrashReportCategory.populateBlockDetails(reportCategory, this.level, this.worldPosition, block);
            }
            CrashReportCategory.populateBlockDetails(reportCategory, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
        }
    }

    private String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName();
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(net.minecraft.world.level.block.state.BlockState blockState) {
        this.validateBlockState(blockState);
        this.blockState = blockState;
    }

    protected void applyImplicitComponents(DataComponentInput componentInput) {
    }

    public final void applyComponentsFromItemStack(ItemStack stack) {
        this.applyComponents(stack.getPrototype(), stack.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap components, DataComponentPatch patch) {
        this.applyComponentsSet(components, patch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap components, DataComponentPatch patch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        set.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.fromPatch(components, patch);
        this.applyImplicitComponents(new DataComponentInput(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> component) {
                set.add(component);
                return dataComponentMap.get(component);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> component, T defaultValue) {
                set.add(component);
                return dataComponentMap.getOrDefault(component, defaultValue);
            }
        });
        DataComponentPatch dataComponentPatch = patch.forget(set::contains);
        this.components = dataComponentPatch.split().added();
        set.remove(DataComponents.BLOCK_ENTITY_DATA);
        return set;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag tag) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(this.components);
        this.collectImplicitComponents(builder);
        return builder.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap components) {
        this.components = components;
    }

    @Nullable
    public static Component parseCustomNameSafe(String customName, HolderLookup.Provider registries) {
        try {
            return Component.Serializer.fromJson(customName, registries);
        }
        catch (Exception var3) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)customName, (Object)var3);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        InventoryHolder inventoryHolder;
        if (this.level == null) {
            return null;
        }
        Block block = this.level.getWorld().getBlockAt(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        BlockState state = block.getState(useSnapshot);
        return state instanceof InventoryHolder ? (inventoryHolder = (InventoryHolder)state) : null;
    }

    public CompoundTag sanitizeSentNbt(CompoundTag tag) {
        tag.remove("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        LOGGER = LogUtils.getLogger();
    }

    static class ComponentHelper {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private ComponentHelper() {
        }
    }

    protected static interface DataComponentInput {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);
    }
}

