/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.LazyPlayerSet;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class SignBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TEXT_LINE_WIDTH = 90;
    private static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    public UUID playerWhoMayEdit;
    private SignText frontText = this.createDefaultSignText();
    private SignText backText = this.createDefaultSignText();
    private boolean isWaxed;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public void sendSystemMessage(net.minecraft.network.chat.Component message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack commandSourceStack) {
            return commandSourceStack.getEntity() != null ? commandSourceStack.getEntity().getBukkitEntity() : new CraftBlockCommandSender(commandSourceStack, SignBlockEntity.this);
        }

        @Override
        public boolean acceptsSuccess() {
            return false;
        }

        @Override
        public boolean acceptsFailure() {
            return false;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }
    };

    public SignBlockEntity(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)BlockEntityType.SIGN, pos, blockState);
    }

    public SignBlockEntity(BlockEntityType type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected SignText createDefaultSignText() {
        return new SignText();
    }

    public boolean isFacingFrontText(Player player) {
        return this.isFacingFrontText(player.getX(), player.getZ());
    }

    public boolean isFacingFrontText(double x, double z) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof SignBlock) {
            float f;
            SignBlock signBlock = (SignBlock)block;
            Vec3 signHitboxCenterPosition = signBlock.getSignHitboxCenterPosition(this.getBlockState());
            double d = x - ((double)this.getBlockPos().getX() + signHitboxCenterPosition.x);
            double d1 = z - ((double)this.getBlockPos().getZ() + signHitboxCenterPosition.z);
            float yRotationDegrees = signBlock.getYRotationDegrees(this.getBlockState());
            return Mth.degreesDifferenceAbs(yRotationDegrees, f = (float)(Mth.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean isFrontText) {
        return isFrontText ? this.frontText : this.backText;
    }

    public SignText getFrontText() {
        return this.frontText;
    }

    public SignText getBackText() {
        return this.backText;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        RegistryOps<Tag> dynamicOps = registries.createSerializationContext(NbtOps.INSTANCE);
        SignText.DIRECT_CODEC.encodeStart(dynamicOps, (Object)this.frontText).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(frontTextTag -> tag.put("front_text", (Tag)frontTextTag));
        SignText.DIRECT_CODEC.encodeStart(dynamicOps, (Object)this.backText).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(backTextTag -> tag.put("back_text", (Tag)backTextTag));
        tag.putBoolean("is_waxed", this.isWaxed);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        RegistryOps<Tag> dynamicOps = registries.createSerializationContext(NbtOps.INSTANCE);
        if (tag.contains("front_text")) {
            SignText.DIRECT_CODEC.parse(dynamicOps, (Object)tag.getCompound("front_text")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(signText -> {
                this.frontText = this.loadLines((SignText)signText);
            });
        }
        if (tag.contains("back_text")) {
            SignText.DIRECT_CODEC.parse(dynamicOps, (Object)tag.getCompound("back_text")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(signText -> {
                this.backText = this.loadLines((SignText)signText);
            });
        }
        this.isWaxed = tag.getBoolean("is_waxed");
    }

    private SignText loadLines(SignText text) {
        for (int i = 0; i < 4; ++i) {
            net.minecraft.network.chat.Component component = this.loadLine(text.getMessage(i, false));
            net.minecraft.network.chat.Component component1 = this.loadLine(text.getMessage(i, true));
            text = text.setMessage(i, component, component1);
        }
        return text;
    }

    private net.minecraft.network.chat.Component loadLine(net.minecraft.network.chat.Component lineText) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                return ComponentUtils.updateForEntity(this.createCommandSourceStack(null, serverLevel, this.worldPosition), lineText, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return lineText;
    }

    public void updateSignText(Player player, boolean isFrontText, List<FilteredText> filteredText) {
        if (!this.isWaxed() && player.getUUID().equals(this.getPlayerWhoMayEdit()) && this.level != null) {
            this.updateText(signText -> this.setMessages(player, filteredText, (SignText)signText, isFrontText), isFrontText);
            this.setAllowedPlayerEditor(null);
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        } else {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.getName().getString());
            if (player.distanceToSqr(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ()) < (double)Mth.square(32)) {
                ((ServerPlayer)player).connection.send(this.getUpdatePacket());
            }
        }
    }

    public boolean updateText(UnaryOperator<SignText> updater, boolean isFrontText) {
        SignText text = this.getText(isFrontText);
        return this.setText((SignText)updater.apply(text), isFrontText);
    }

    private SignText setMessages(Player player, List<FilteredText> filteredText, SignText text, boolean front) {
        SignText originalText = text;
        for (int i = 0; i < filteredText.size(); ++i) {
            FilteredText filteredText1 = filteredText.get(i);
            Style style = text.getMessage(i, player.isTextFilteringEnabled()).getStyle();
            text = player.isTextFilteringEnabled() ? text.setMessage(i, net.minecraft.network.chat.Component.literal(StringUtil.filterText(filteredText1.filteredOrEmpty())).setStyle(style)) : text.setMessage(i, net.minecraft.network.chat.Component.literal(filteredText1.raw()).setStyle(style), net.minecraft.network.chat.Component.literal(StringUtil.filterText(filteredText1.filteredOrEmpty())).setStyle(style));
        }
        CraftPlayer apiPlayer = ((ServerPlayer)player).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i = 0; i < filteredText.size(); ++i) {
            lines.add(PaperAdventure.asAdventure(text.getMessage(i, player.isTextFilteringEnabled())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.level, this.worldPosition), (org.bukkit.entity.Player)apiPlayer, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        if (!event.callEvent()) {
            return originalText;
        }
        net.minecraft.network.chat.Component[] components = CraftSign.sanitizeLines(event.lines());
        for (int i = 0; i < components.length; ++i) {
            if (Objects.equals(lines.get(i), event.line(i))) continue;
            text = text.setMessage(i, components[i]);
        }
        return text;
    }

    public boolean setText(SignText text, boolean isFrontText) {
        return isFrontText ? this.setFrontText(text) : this.setBackText(text);
    }

    private boolean setBackText(SignText text) {
        if (text != this.backText) {
            this.backText = text;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean setFrontText(SignText text) {
        if (text != this.frontText) {
            this.frontText = text;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean canExecuteClickCommands(boolean isFrontText, Player player) {
        return this.isWaxed() && this.getText(isFrontText).hasAnyClickCommands(player);
    }

    public boolean executeClickCommandsIfPresent(Player player, Level level, BlockPos pos, boolean frontText) {
        boolean flag = false;
        for (net.minecraft.network.chat.Component component : this.getText(frontText).getMessages(player.isTextFilteringEnabled())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            Style style = component.getStyle();
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent == null || clickEvent.getAction() != ClickEvent.Action.RUN_COMMAND) continue;
            Object object = command = clickEvent.getValue().startsWith("/") ? clickEvent.getValue() : "/" + clickEvent.getValue();
            if (SpigotConfig.logCommands) {
                LOGGER.info("{} issued server command: {}", (Object)player.getScoreboardName(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.getServer()), (Sign)CraftBlock.at(this.level, this.worldPosition).getState(), frontText ? Side.FRONT : Side.BACK)).callEvent()) {
                return false;
            }
            player.getServer().getCommands().performPrefixedCommand(this.createCommandSourceStack(((CraftPlayer)event.getPlayer()).getHandle(), level, pos), event.getMessage());
            flag = true;
        }
        return flag;
    }

    private CommandSourceStack createCommandSourceStack(final @Nullable Player player, Level level, BlockPos pos) {
        String string = player == null ? "Sign" : player.getName().getString();
        net.minecraft.network.chat.Component component = player == null ? net.minecraft.network.chat.Component.literal("Sign") : player.getDisplayName();
        CommandSource commandSource = level.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this, this.commandSource){

            @Override
            public void sendSystemMessage(net.minecraft.network.chat.Component message) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage(message);
                }
            }

            @Override
            public boolean acceptsFailure() {
                return true;
            }
        } : this.commandSource;
        return new CommandSourceStack(commandSource, Vec3.atCenterOf(pos), Vec2.ZERO, (ServerLevel)level, 2, string, component, level.getServer(), player);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public void setAllowedPlayerEditor(@Nullable UUID playWhoMayEdit) {
        this.playerWhoMayEdit = playWhoMayEdit;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        if (this.level != null && this.playerWhoMayEdit != null) {
            this.clearInvalidPlayerWhoMayEdit(this, this.level, this.playerWhoMayEdit);
        }
        return this.playerWhoMayEdit;
    }

    private void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public boolean setWaxed(boolean isWaxed) {
        if (this.isWaxed != isWaxed) {
            this.isWaxed = isWaxed;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean playerIsTooFarAwayToEdit(UUID uuid) {
        Player playerByUuid = this.level.getPlayerByUUID(uuid);
        return playerByUuid == null || !playerByUuid.canInteractWithBlock(this.getBlockPos(), 4.0);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SignBlockEntity sign) {
        UUID playerWhoMayEdit = sign.getPlayerWhoMayEdit();
        if (playerWhoMayEdit != null) {
            sign.clearInvalidPlayerWhoMayEdit(sign, level, playerWhoMayEdit);
        }
    }

    private void clearInvalidPlayerWhoMayEdit(SignBlockEntity sign, Level level, UUID uuid) {
        if (sign.playerIsTooFarAwayToEdit(uuid)) {
            sign.setAllowedPlayerEditor(null);
        }
    }

    public SoundEvent getSignInteractionFailedSoundEvent() {
        return SoundEvents.WAXED_SIGN_INTERACT_FAIL;
    }
}

