/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class TrialSpawnerConfigs {
    private static final Keys TRIAL_CHAMBER_BREEZE = Keys.of("trial_chamber/breeze");
    private static final Keys TRIAL_CHAMBER_MELEE_HUSK = Keys.of("trial_chamber/melee/husk");
    private static final Keys TRIAL_CHAMBER_MELEE_SPIDER = Keys.of("trial_chamber/melee/spider");
    private static final Keys TRIAL_CHAMBER_MELEE_ZOMBIE = Keys.of("trial_chamber/melee/zombie");
    private static final Keys TRIAL_CHAMBER_RANGED_POISON_SKELETON = Keys.of("trial_chamber/ranged/poison_skeleton");
    private static final Keys TRIAL_CHAMBER_RANGED_SKELETON = Keys.of("trial_chamber/ranged/skeleton");
    private static final Keys TRIAL_CHAMBER_RANGED_STRAY = Keys.of("trial_chamber/ranged/stray");
    private static final Keys TRIAL_CHAMBER_SLOW_RANGED_POISON_SKELETON = Keys.of("trial_chamber/slow_ranged/poison_skeleton");
    private static final Keys TRIAL_CHAMBER_SLOW_RANGED_SKELETON = Keys.of("trial_chamber/slow_ranged/skeleton");
    private static final Keys TRIAL_CHAMBER_SLOW_RANGED_STRAY = Keys.of("trial_chamber/slow_ranged/stray");
    private static final Keys TRIAL_CHAMBER_SMALL_MELEE_BABY_ZOMBIE = Keys.of("trial_chamber/small_melee/baby_zombie");
    private static final Keys TRIAL_CHAMBER_SMALL_MELEE_CAVE_SPIDER = Keys.of("trial_chamber/small_melee/cave_spider");
    private static final Keys TRIAL_CHAMBER_SMALL_MELEE_SILVERFISH = Keys.of("trial_chamber/small_melee/silverfish");
    private static final Keys TRIAL_CHAMBER_SMALL_MELEE_SLIME = Keys.of("trial_chamber/small_melee/slime");

    public static void bootstrap(BootstrapContext<TrialSpawnerConfig> context) {
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_BREEZE, TrialSpawnerConfig.builder().simultaneousMobs(1.0f).simultaneousMobsAddedPerPlayer(0.5f).ticksBetweenSpawn(20).totalMobs(2.0f).totalMobsAddedPerPlayer(1.0f).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.BREEZE))).build(), TrialSpawnerConfig.builder().simultaneousMobsAddedPerPlayer(0.5f).ticksBetweenSpawn(20).totalMobs(4.0f).totalMobsAddedPerPlayer(1.0f).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.BREEZE))).lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_MELEE_HUSK, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.HUSK))).build(), TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.HUSK, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_MELEE))).lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_MELEE_SPIDER, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.SPIDER))).build(), TrialSpawnerConfigs.trialChamberMeleeOminous().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.SPIDER))).lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_MELEE_ZOMBIE, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.ZOMBIE))).build(), TrialSpawnerConfigs.trialChamberBase().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.ZOMBIE, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_MELEE))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_RANGED_POISON_SKELETON, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.BOGGED))).build(), TrialSpawnerConfigs.trialChamberBase().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.BOGGED, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_RANGED_SKELETON, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.SKELETON))).build(), TrialSpawnerConfigs.trialChamberBase().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.SKELETON, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_RANGED_STRAY, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.STRAY))).build(), TrialSpawnerConfigs.trialChamberBase().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.STRAY, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SLOW_RANGED_POISON_SKELETON, TrialSpawnerConfigs.trialChamberSlowRanged().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.BOGGED))).build(), TrialSpawnerConfigs.trialChamberSlowRanged().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.BOGGED, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SLOW_RANGED_SKELETON, TrialSpawnerConfigs.trialChamberSlowRanged().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.SKELETON))).build(), TrialSpawnerConfigs.trialChamberSlowRanged().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.SKELETON, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SLOW_RANGED_STRAY, TrialSpawnerConfigs.trialChamberSlowRanged().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.STRAY))).build(), TrialSpawnerConfigs.trialChamberSlowRanged().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnDataWithEquipment(EntityType.STRAY, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SMALL_MELEE_BABY_ZOMBIE, TrialSpawnerConfig.builder().simultaneousMobsAddedPerPlayer(0.5f).ticksBetweenSpawn(20).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.customSpawnDataWithEquipment(EntityType.ZOMBIE, compoundTag -> compoundTag.putBoolean("IsBaby", true), null))).build(), TrialSpawnerConfig.builder().simultaneousMobsAddedPerPlayer(0.5f).ticksBetweenSpawn(20).lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.customSpawnDataWithEquipment(EntityType.ZOMBIE, compoundTag -> compoundTag.putBoolean("IsBaby", true), BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_MELEE))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SMALL_MELEE_CAVE_SPIDER, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.CAVE_SPIDER))).build(), TrialSpawnerConfigs.trialChamberMeleeOminous().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.CAVE_SPIDER))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SMALL_MELEE_SILVERFISH, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.SILVERFISH))).build(), TrialSpawnerConfigs.trialChamberMeleeOminous().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.single(TrialSpawnerConfigs.spawnData(EntityType.SILVERFISH))).build());
        TrialSpawnerConfigs.register(context, TRIAL_CHAMBER_SMALL_MELEE_SLIME, TrialSpawnerConfigs.trialChamberBase().spawnPotentialsDefinition(SimpleWeightedRandomList.builder().add(TrialSpawnerConfigs.customSpawnData(EntityType.SLIME, compoundTag -> compoundTag.putByte("Size", (byte)1)), 3).add(TrialSpawnerConfigs.customSpawnData(EntityType.SLIME, compoundTag -> compoundTag.putByte("Size", (byte)2)), 1).build()).build(), TrialSpawnerConfigs.trialChamberMeleeOminous().lootTablesToEject(SimpleWeightedRandomList.builder().add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY, 3).add(BuiltInLootTables.SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES, 7).build()).spawnPotentialsDefinition(SimpleWeightedRandomList.builder().add(TrialSpawnerConfigs.customSpawnData(EntityType.SLIME, compoundTag -> compoundTag.putByte("Size", (byte)1)), 3).add(TrialSpawnerConfigs.customSpawnData(EntityType.SLIME, compoundTag -> compoundTag.putByte("Size", (byte)2)), 1).build()).build());
    }

    private static <T extends Entity> SpawnData spawnData(EntityType<T> entityType) {
        return TrialSpawnerConfigs.customSpawnDataWithEquipment(entityType, compoundTag -> {}, null);
    }

    private static <T extends Entity> SpawnData customSpawnData(EntityType<T> entityType, Consumer<CompoundTag> tagConsumer) {
        return TrialSpawnerConfigs.customSpawnDataWithEquipment(entityType, tagConsumer, null);
    }

    private static <T extends Entity> SpawnData spawnDataWithEquipment(EntityType<T> entityType, ResourceKey<LootTable> lootTableKey) {
        return TrialSpawnerConfigs.customSpawnDataWithEquipment(entityType, compoundTag -> {}, lootTableKey);
    }

    private static <T extends Entity> SpawnData customSpawnDataWithEquipment(EntityType<T> entityType, Consumer<CompoundTag> tagConsumer, @Nullable ResourceKey<LootTable> lootTableKey) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
        tagConsumer.accept(compoundTag);
        Optional<EquipmentTable> optional = Optional.ofNullable(lootTableKey).map(resourceKey -> new EquipmentTable((ResourceKey<LootTable>)resourceKey, 0.0f));
        return new SpawnData(compoundTag, Optional.empty(), optional);
    }

    private static void register(BootstrapContext<TrialSpawnerConfig> context, Keys keys, TrialSpawnerConfig normal, TrialSpawnerConfig ominous) {
        context.register(keys.normal, normal);
        context.register(keys.ominous, ominous);
    }

    static ResourceKey<TrialSpawnerConfig> registryKey(String name) {
        return ResourceKey.create(Registries.TRIAL_SPAWNER_CONFIG, ResourceLocation.withDefaultNamespace(name));
    }

    private static TrialSpawnerConfig.Builder trialChamberMeleeOminous() {
        return TrialSpawnerConfig.builder().simultaneousMobs(4.0f).simultaneousMobsAddedPerPlayer(0.5f).ticksBetweenSpawn(20).totalMobs(12.0f);
    }

    private static TrialSpawnerConfig.Builder trialChamberSlowRanged() {
        return TrialSpawnerConfig.builder().simultaneousMobs(4.0f).simultaneousMobsAddedPerPlayer(2.0f).ticksBetweenSpawn(160);
    }

    private static TrialSpawnerConfig.Builder trialChamberBase() {
        return TrialSpawnerConfig.builder().simultaneousMobs(3.0f).simultaneousMobsAddedPerPlayer(0.5f).ticksBetweenSpawn(20);
    }

    record Keys(ResourceKey<TrialSpawnerConfig> normal, ResourceKey<TrialSpawnerConfig> ominous) {
        public static Keys of(String key) {
            return new Keys(TrialSpawnerConfigs.registryKey(key + "/normal"), TrialSpawnerConfigs.registryKey(key + "/ominous"));
        }
    }
}

