/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMath;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonMovingBlockEntity
extends BlockEntity {
    private static final int TICKS_TO_EXTEND = 2;
    private static final double PUSH_OFFSET = 0.01;
    public static final double TICK_MOVEMENT = 0.51;
    private BlockState movedState = Blocks.AIR.defaultBlockState();
    private Direction direction = Direction.DOWN;
    private boolean extending;
    private boolean isSourcePiston;
    private static final ThreadLocal<Direction> NOCLIP = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float progressO;
    private long lastTicked;
    private int deathTicks;

    public PistonMovingBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.PISTON, pos, blockState);
    }

    public PistonMovingBlockEntity(BlockPos pos, BlockState blockState, BlockState movedState, Direction direction, boolean extending, boolean isSourcePiston) {
        this(pos, blockState);
        this.movedState = movedState;
        this.direction = direction;
        this.extending = extending;
        this.isSourcePiston = isSourcePiston;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float partialTicks) {
        if (partialTicks > 1.0f) {
            partialTicks = 1.0f;
        }
        return Mth.lerp(partialTicks, this.progressO, this.progress);
    }

    public float getXOff(float partialTicks) {
        return (float)this.direction.getStepX() * this.getExtendedProgress(this.getProgress(partialTicks));
    }

    public float getYOff(float partialTicks) {
        return (float)this.direction.getStepY() * this.getExtendedProgress(this.getProgress(partialTicks));
    }

    public float getZOff(float partialTicks) {
        return (float)this.direction.getStepZ() * this.getExtendedProgress(this.getProgress(partialTicks));
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    private BlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.isSourcePiston() && this.movedState.getBlock() instanceof PistonBaseBlock ? (BlockState)((BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.SHORT, this.progress > 0.25f)).setValue(PistonHeadBlock.TYPE, this.movedState.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT)).setValue(DirectionalBlock.FACING, this.movedState.getValue(DirectionalBlock.FACING)) : this.movedState;
    }

    private static void moveCollidedEntities(Level level, BlockPos pos, float partialTick, PistonMovingBlockEntity piston) {
        AABB aabb;
        List<Entity> entities;
        Direction movementDirection = piston.getMovementDirection();
        double d = partialTick - piston.progress;
        VoxelShape collisionShape = piston.getCollisionRelatedBlockState().getCollisionShape(level, pos);
        if (!collisionShape.isEmpty() && !(entities = level.getEntities(null, PistonMath.getMovementArea(aabb = PistonMovingBlockEntity.moveByPositionAndProgress(pos, collisionShape.bounds(), piston), movementDirection, d).minmax(aabb))).isEmpty()) {
            List<AABB> list = collisionShape.toAabbs();
            boolean isSlimeBlock = piston.movedState.is(Blocks.SLIME_BLOCK);
            Iterator<Entity> var12 = entities.iterator();
            while (true) {
                AABB boundingBox;
                AABB aabb1;
                AABB movementArea;
                if (!var12.hasNext()) {
                    return;
                }
                Entity entity = var12.next();
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                if (isSlimeBlock) {
                    if (entity instanceof ServerPlayer) continue;
                    Vec3 deltaMovement = entity.getDeltaMovement();
                    double d1 = deltaMovement.x;
                    double d2 = deltaMovement.y;
                    double d3 = deltaMovement.z;
                    switch (movementDirection.getAxis()) {
                        case X: {
                            d1 = movementDirection.getStepX();
                            break;
                        }
                        case Y: {
                            d2 = movementDirection.getStepY();
                            break;
                        }
                        case Z: {
                            d3 = movementDirection.getStepZ();
                        }
                    }
                    entity.setDeltaMovement(d1, d2, d3);
                    entity.activatedTick = Math.max(entity.activatedTick, (long)(MinecraftServer.currentTick + 10));
                    entity.activatedImmunityTick = Math.max(entity.activatedImmunityTick, (long)(MinecraftServer.currentTick + 10));
                }
                double d4 = 0.0;
                Iterator<AABB> iterator = list.iterator();
                while (!(!iterator.hasNext() || (movementArea = PistonMath.getMovementArea(PistonMovingBlockEntity.moveByPositionAndProgress(pos, aabb1 = iterator.next(), piston), movementDirection, d)).intersects(boundingBox = entity.getBoundingBox()) && (d4 = Math.max(d4, PistonMovingBlockEntity.getMovement(movementArea, movementDirection, boundingBox))) >= d)) {
                }
                if (d4 <= 0.0) continue;
                d4 = Math.min(d4, d) + 0.01;
                PistonMovingBlockEntity.moveEntityByPiston(movementDirection, entity, d4, movementDirection);
                if (piston.extending || !piston.isSourcePiston) continue;
                PistonMovingBlockEntity.fixEntityWithinPistonBase(pos, entity, movementDirection, d);
            }
        }
    }

    private static void moveEntityByPiston(Direction noClipDirection, Entity entity, double progress, Direction direction) {
        NOCLIP.set(noClipDirection);
        entity.move(MoverType.PISTON, new Vec3(progress * (double)direction.getStepX(), progress * (double)direction.getStepY(), progress * (double)direction.getStepZ()));
        entity.applyEffectsFromBlocks();
        NOCLIP.set(null);
    }

    private static void moveStuckEntities(Level level, BlockPos pos, float partialTick, PistonMovingBlockEntity piston) {
        Direction movementDirection;
        if (piston.isStickyForEntities() && (movementDirection = piston.getMovementDirection()).getAxis().isHorizontal()) {
            double d = piston.movedState.getCollisionShape(level, pos).max(Direction.Axis.Y);
            AABB aabb = PistonMovingBlockEntity.moveByPositionAndProgress(pos, new AABB(0.0, d, 0.0, 1.0, 1.5000010000000001, 1.0), piston);
            double d1 = partialTick - piston.progress;
            for (Entity entity : level.getEntities((Entity)null, aabb, collidedEntity -> PistonMovingBlockEntity.matchesStickyCritera(aabb, collidedEntity, pos))) {
                PistonMovingBlockEntity.moveEntityByPiston(movementDirection, entity, d1, movementDirection);
            }
        }
    }

    private static boolean matchesStickyCritera(AABB box, Entity entity, BlockPos pos) {
        return entity.getPistonPushReaction() == PushReaction.NORMAL && entity.onGround() && (entity.isSupportedBy(pos) || entity.getX() >= box.minX && entity.getX() <= box.maxX && entity.getZ() >= box.minZ && entity.getZ() <= box.maxZ);
    }

    private boolean isStickyForEntities() {
        return this.movedState.is(Blocks.HONEY_BLOCK);
    }

    public Direction getMovementDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    private static double getMovement(AABB headShape, Direction direction, AABB facing) {
        switch (direction) {
            case EAST: {
                return headShape.maxX - facing.minX;
            }
            case WEST: {
                return facing.maxX - headShape.minX;
            }
            default: {
                return headShape.maxY - facing.minY;
            }
            case DOWN: {
                return facing.maxY - headShape.minY;
            }
            case SOUTH: {
                return headShape.maxZ - facing.minZ;
            }
            case NORTH: 
        }
        return facing.maxZ - headShape.minZ;
    }

    private static AABB moveByPositionAndProgress(BlockPos pos, AABB aabb, PistonMovingBlockEntity pistonMovingBlockEntity) {
        double d = pistonMovingBlockEntity.getExtendedProgress(pistonMovingBlockEntity.progress);
        return aabb.move((double)pos.getX() + d * (double)pistonMovingBlockEntity.direction.getStepX(), (double)pos.getY() + d * (double)pistonMovingBlockEntity.direction.getStepY(), (double)pos.getZ() + d * (double)pistonMovingBlockEntity.direction.getStepZ());
    }

    private static void fixEntityWithinPistonBase(BlockPos pos, Entity entity, Direction dir, double progress) {
        double d1;
        Direction opposite;
        double d;
        AABB aabb;
        AABB boundingBox = entity.getBoundingBox();
        if (boundingBox.intersects(aabb = Shapes.block().bounds().move(pos)) && Math.abs((d = PistonMovingBlockEntity.getMovement(aabb, opposite = dir.getOpposite(), boundingBox) + 0.01) - (d1 = PistonMovingBlockEntity.getMovement(aabb, opposite, boundingBox.intersect(aabb)) + 0.01)) < 0.01) {
            d = Math.min(d, progress) + 0.01;
            PistonMovingBlockEntity.moveEntityByPiston(dir, entity, d, opposite);
        }
    }

    public BlockState getMovedState() {
        return this.movedState;
    }

    public void finalTick() {
        if (this.level != null && (this.progressO < 1.0f || this.level.isClientSide)) {
            this.progressO = this.progress = 1.0f;
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.level.getBlockState(this.worldPosition).is(Blocks.MOVING_PISTON)) {
                BlockState blockState = this.isSourcePiston ? Blocks.AIR.defaultBlockState() : Block.updateFromNeighbourShapes(this.movedState, this.level, this.worldPosition);
                this.level.setBlock(this.worldPosition, blockState, 3);
                this.level.neighborChanged(this.worldPosition, blockState.getBlock(), ExperimentalRedstoneUtils.initialOrientation(this.level, this.getPushDirection(), null));
            }
        }
    }

    public Direction getPushDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity) {
        blockEntity.lastTicked = level.getGameTime();
        blockEntity.progressO = blockEntity.progress;
        if (blockEntity.progressO >= 1.0f) {
            if (level.isClientSide && blockEntity.deathTicks < 5) {
                ++blockEntity.deathTicks;
            } else {
                level.removeBlockEntity(pos);
                blockEntity.setRemoved();
                if (level.getBlockState(pos).is(Blocks.MOVING_PISTON)) {
                    BlockState blockState = Block.updateFromNeighbourShapes(blockEntity.movedState, level, pos);
                    if (blockState.isAir()) {
                        level.setBlock(pos, blockEntity.movedState, GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication ? 84 : 86);
                        Block.updateOrDestroy(blockEntity.movedState, blockState, level, pos, 3);
                    } else {
                        if (blockState.hasProperty(BlockStateProperties.WATERLOGGED) && blockState.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
                            blockState = (BlockState)blockState.setValue(BlockStateProperties.WATERLOGGED, false);
                        }
                        level.setBlock(pos, blockState, 67);
                        level.neighborChanged(pos, blockState.getBlock(), ExperimentalRedstoneUtils.initialOrientation(level, blockEntity.getPushDirection(), null));
                    }
                }
            }
        } else {
            float f = blockEntity.progress + 0.5f;
            PistonMovingBlockEntity.moveCollidedEntities(level, pos, f, blockEntity);
            PistonMovingBlockEntity.moveStuckEntities(level, pos, f, blockEntity);
            blockEntity.progress = f;
            if (blockEntity.progress >= 1.0f) {
                blockEntity.progress = 1.0f;
            }
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        DefaultedRegistry<Block> holderGetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK;
        this.movedState = NbtUtils.readBlockState(holderGetter, tag.getCompound("blockState"));
        this.direction = Direction.from3DDataValue(tag.getInt("facing"));
        this.progressO = this.progress = tag.getFloat("progress");
        this.extending = tag.getBoolean("extending");
        this.isSourcePiston = tag.getBoolean("source");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("blockState", NbtUtils.writeBlockState(this.movedState));
        tag.putInt("facing", this.direction.get3DDataValue());
        tag.putFloat("progress", this.progressO);
        tag.putBoolean("extending", this.extending);
        tag.putBoolean("source", this.isSourcePiston);
    }

    public VoxelShape getCollisionShape(BlockGetter level, BlockPos pos) {
        VoxelShape collisionShape = !this.extending && this.isSourcePiston && this.movedState.getBlock() instanceof PistonBaseBlock ? ((BlockState)this.movedState.setValue(PistonBaseBlock.EXTENDED, true)).getCollisionShape(level, pos) : Shapes.empty();
        Direction direction = NOCLIP.get();
        if ((double)this.progress < 1.0 && direction == this.getMovementDirection()) {
            return collisionShape;
        }
        BlockState blockState = this.isSourcePiston() ? (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(DirectionalBlock.FACING, this.direction)).setValue(PistonHeadBlock.SHORT, this.extending != 1.0f - this.progress < 0.25f) : this.movedState;
        float extendedProgress = this.getExtendedProgress(this.progress);
        double d = (float)this.direction.getStepX() * extendedProgress;
        double d1 = (float)this.direction.getStepY() * extendedProgress;
        double d2 = (float)this.direction.getStepZ() * extendedProgress;
        return Shapes.or(collisionShape, blockState.getCollisionShape(level, pos).move(d, d1, d2));
    }

    public long getLastTicked() {
        return this.lastTicked;
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.holderLookup(Registries.BLOCK).get(this.movedState.getBlock().builtInRegistryHolder().key()).isEmpty()) {
            this.movedState = Blocks.AIR.defaultBlockState();
        }
    }
}

