/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class StateDefinition<O, S extends StateHolder<O, S>> {
    static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private final O owner;
    private final ImmutableSortedMap<String, Property<?>> propertiesByName;
    private final ImmutableList<S> states;

    protected StateDefinition(Function<O, S> stateValueFunction, O owner, Factory<O, S> valueFunction, Map<String, Property<?>> propertiesByName) {
        this.owner = owner;
        this.propertiesByName = ImmutableSortedMap.copyOf(propertiesByName);
        Supplier<StateHolder> supplier = () -> (StateHolder)stateValueFunction.apply(owner);
        MapCodec<StateHolder> mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Map.Entry entry : this.propertiesByName.entrySet()) {
            mapCodec = StateDefinition.appendPropertyCodec(mapCodec, supplier, (String)entry.getKey(), (Property)entry.getValue());
        }
        MapCodec<StateHolder> mapCodec1 = mapCodec;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList list = Lists.newArrayList();
        Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
        for (Property property : this.propertiesByName.values()) {
            stream = stream.flatMap(list1 -> property.getPossibleValues().stream().map(value -> {
                ArrayList list2 = Lists.newArrayList((Iterable)list1);
                list2.add(Pair.of((Object)property, (Object)value));
                return list2;
            }));
        }
        stream.forEach(list1 -> {
            Reference2ObjectArrayMap map1 = new Reference2ObjectArrayMap(list1.size());
            for (Pair pair : list1) {
                map1.put((Object)((Property)pair.getFirst()), (Object)((Comparable)pair.getSecond()));
            }
            StateHolder stateHolder1 = (StateHolder)valueFunction.create(owner, map1, mapCodec1);
            map.put(map1, stateHolder1);
            list.add(stateHolder1);
        });
        for (StateHolder stateHolder : list) {
            stateHolder.populateNeighbours(map);
        }
        this.states = ImmutableList.copyOf((Collection)list);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> appendPropertyCodec(MapCodec<S> propertyCodec, Supplier<S> holderSupplier, String value, Property<T> property) {
        return Codec.mapPair(propertyCodec, (MapCodec)property.valueCodec().fieldOf(value).orElseGet(elseValue -> {}, () -> property.value((StateHolder)holderSupplier.get()))).xmap(holder -> (StateHolder)((StateHolder)holder.getFirst()).setValue(property, ((Property.Value)holder.getSecond()).value()), holder -> Pair.of((Object)holder, property.value((StateHolder<?, ?>)holder)));
    }

    public ImmutableList<S> getPossibleStates() {
        return this.states;
    }

    public S any() {
        return (S)((StateHolder)this.states.get(0));
    }

    public O getOwner() {
        return this.owner;
    }

    public Collection<Property<?>> getProperties() {
        return this.propertiesByName.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.owner).add("properties", this.propertiesByName.values().stream().map(Property::getName).collect(Collectors.toList())).toString();
    }

    @Nullable
    public Property<?> getProperty(String propertyName) {
        return (Property)this.propertiesByName.get((Object)propertyName);
    }

    public static interface Factory<O, S> {
        public S create(O var1, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O owner;
        private final Map<String, Property<?>> properties = Maps.newHashMap();

        public Builder(O owner) {
            this.owner = owner;
        }

        public Builder<O, S> add(Property<?> ... properties) {
            for (Property<?> property : properties) {
                this.validateProperty(property);
                this.properties.put(property.getName(), property);
            }
            return this;
        }

        private <T extends Comparable<T>> void validateProperty(Property<T> property) {
            String name = property.getName();
            if (!NAME_PATTERN.matcher(name).matches()) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has invalidly named property: " + name);
            }
            List<T> possibleValues = property.getPossibleValues();
            if (possibleValues.size() <= 1) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " attempted use property " + name + " with <= 1 possible values");
            }
            for (Comparable comparable : possibleValues) {
                String name1 = property.getName(comparable);
                if (NAME_PATTERN.matcher(name1).matches()) continue;
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has property: " + name + " with invalidly named value: " + name1);
            }
            if (this.properties.containsKey(name)) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has duplicate property: " + name);
            }
        }

        public StateDefinition<O, S> create(Function<O, S> stateValueFunction, Factory<O, S> stateFunction) {
            return new StateDefinition<O, S>(stateValueFunction, this.owner, stateFunction, this.properties);
        }
    }
}

