/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPalette;
import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class HashMapPalette<T>
implements Palette<T>,
FastPalette<T> {
    private final IdMap<T> registry;
    private final CrudeIncrementalIntIdentityHashBiMap<T> values;
    private final PaletteResize<T> resizeHandler;
    private final int bits;

    @Override
    public final T[] moonrise$getRawPalette(FastPaletteData<T> container) {
        return this.values.moonrise$getRawPalette(container);
    }

    public HashMapPalette(IdMap<T> registry, int bits, PaletteResize<T> resizeHandler, List<T> values) {
        this(registry, bits, resizeHandler);
        values.forEach(this.values::add);
    }

    public HashMapPalette(IdMap<T> registry, int bits, PaletteResize<T> resizeHandler) {
        this(registry, bits, resizeHandler, CrudeIncrementalIntIdentityHashBiMap.create((1 << bits) + 1));
    }

    private HashMapPalette(IdMap<T> registry, int bits, PaletteResize<T> resizeHandler, CrudeIncrementalIntIdentityHashBiMap<T> values) {
        this.registry = registry;
        this.bits = bits;
        this.resizeHandler = resizeHandler;
        this.values = values;
    }

    public static <A> Palette<A> create(int bits, IdMap<A> registry, PaletteResize<A> resizeHandler, List<A> values) {
        return new HashMapPalette<A>(registry, bits, resizeHandler, values);
    }

    @Override
    public int idFor(T state) {
        int id = this.values.getId(state);
        if (id == -1) {
            id = this.values.size() >= 1 << this.bits ? this.resizeHandler.onResize(this.bits + 1, state) : this.values.add(state);
        }
        return id;
    }

    @Override
    public boolean maybeHas(Predicate<T> filter) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!filter.test(this.values.byId(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int id) {
        T object = this.values.byId(id);
        if (object == null) {
            throw new MissingPaletteEntryException(id);
        }
        return object;
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.values.clear();
        int varInt = buffer.readVarInt();
        for (int i = 0; i < varInt; ++i) {
            this.values.add(this.registry.byIdOrThrow(buffer.readVarInt()));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        int size = this.getSize();
        buffer.writeVarInt(size);
        for (int i = 0; i < size; ++i) {
            buffer.writeVarInt(this.registry.getId(this.values.byId(i)));
        }
    }

    @Override
    public int getSerializedSize() {
        int byteSize = VarInt.getByteSize(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            byteSize += VarInt.getByteSize(this.registry.getId(this.values.byId(i)));
        }
        return byteSize;
    }

    public List<T> getEntries() {
        ArrayList list = new ArrayList();
        this.values.iterator().forEachRemaining(list::add);
        return list;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public Palette<T> copy(PaletteResize<T> resizeHandler) {
        return new HashMapPalette<T>(this.registry, this.bits, resizeHandler, this.values.copy());
    }
}

