/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class LevelChunk
extends ChunkAccess
implements ChunkSystemLevelChunk,
StarlightChunk,
GetBlockChunk {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final TickingBlockEntity NULL_TICKER = new TickingBlockEntity(){

        @Override
        public void tick() {
        }

        @Override
        public boolean isRemoved() {
            return true;
        }

        @Override
        public BlockPos getPos() {
            return BlockPos.ZERO;
        }

        @Override
        public String getType() {
            return "<null>";
        }
    };
    private final Map<BlockPos, RebindableTickingBlockEntityWrapper> tickersInLevel = Maps.newHashMap();
    public boolean loaded;
    public final ServerLevel level;
    @Nullable
    private Supplier<FullChunkStatus> fullStatus;
    @Nullable
    private PostLoadProcessor postLoad;
    private final Int2ObjectMap<GameEventListenerRegistry> gameEventListenerRegistrySections;
    private final LevelChunkTicks<Block> blockTicks;
    private final LevelChunkTicks<Fluid> fluidTicks;
    private UnsavedListener unsavedListener = chunkPos -> {};
    public boolean mustNotSave;
    public boolean needsDecoration;
    boolean loadedTicketLevel;
    private boolean postProcessingDone;
    private ServerChunkCache.ChunkAndHolder chunkAndHolder;
    private static final BlockState AIR_BLOCKSTATE = Blocks.AIR.defaultBlockState();
    private static final FluidState AIR_FLUIDSTATE = Fluids.EMPTY.defaultFluidState();
    private static final BlockState VOID_AIR_BLOCKSTATE = Blocks.VOID_AIR.defaultBlockState();
    private final int minSection;
    private final int maxSection;
    private final boolean debug;
    private final BlockState defaultBlockState;

    @Override
    public final boolean moonrise$isPostProcessingDone() {
        return this.postProcessingDone;
    }

    @Override
    public final ServerChunkCache.ChunkAndHolder moonrise$getChunkAndHolder() {
        return this.chunkAndHolder;
    }

    @Override
    public final void moonrise$setChunkAndHolder(ServerChunkCache.ChunkAndHolder holder) {
        this.chunkAndHolder = holder;
    }

    @Override
    public final BlockState moonrise$getBlock(int x, int y, int z) {
        return this.getBlockStateFinal(x, y, z);
    }

    public LevelChunk(Level level, ChunkPos pos) {
        this(level, pos, UpgradeData.EMPTY, new LevelChunkTicks<Block>(), new LevelChunkTicks<Fluid>(), 0L, null, null, null);
    }

    public LevelChunk(Level level, ChunkPos pos, UpgradeData data, LevelChunkTicks<Block> blockTicks, LevelChunkTicks<Fluid> fluidTicks, long inhabitedTime, @Nullable LevelChunkSection[] sections, @Nullable PostLoadProcessor postLoad, @Nullable BlendingData blendingData) {
        super(pos, data, level, (Registry<Biome>)MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME), inhabitedTime, sections, blendingData);
        this.level = (ServerLevel)level;
        this.gameEventListenerRegistrySections = new Int2ObjectOpenHashMap();
        for (Heightmap.Types types : Heightmap.Types.values()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(types)) continue;
            this.heightmaps.put(types, new Heightmap(this, types));
        }
        this.postLoad = postLoad;
        this.blockTicks = blockTicks;
        this.fluidTicks = fluidTicks;
        this.minSection = WorldUtil.getMinSection(level);
        this.maxSection = WorldUtil.getMaxSection(level);
        boolean empty = this instanceof EmptyLevelChunk;
        this.debug = !empty && this.level.isDebug();
        this.defaultBlockState = empty ? VOID_AIR_BLOCKSTATE : AIR_BLOCKSTATE;
    }

    public LevelChunk(ServerLevel level, ProtoChunk chunk, @Nullable PostLoadProcessor postLoad) {
        this(level, chunk.getPos(), chunk.getUpgradeData(), chunk.unpackBlockTicks(), chunk.unpackFluidTicks(), chunk.getInhabitedTime(), chunk.getSections(), postLoad, chunk.getBlendingData());
        if (!Collections.disjoint(chunk.pendingBlockEntities.keySet(), chunk.blockEntities.keySet())) {
            LOGGER.error("Chunk at {} contains duplicated block entities", (Object)chunk.getPos());
        }
        for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
            this.setBlockEntity(blockEntity);
        }
        this.pendingBlockEntities.putAll(chunk.getBlockEntityNbts());
        for (int i = 0; i < chunk.getPostProcessing().length; ++i) {
            this.postProcessing[i] = chunk.getPostProcessing()[i];
        }
        this.setAllStarts(chunk.getAllStarts());
        this.setAllReferences(chunk.getAllReferences());
        for (Map.Entry<Heightmap.Types, Heightmap> entry : chunk.getHeightmaps()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(entry.getKey())) continue;
            this.setHeightmap(entry.getKey(), entry.getValue().getRawData());
        }
        this.setLightCorrect(chunk.isLightCorrect());
        this.markUnsaved();
        this.needsDecoration = true;
        this.persistentDataContainer = chunk.persistentDataContainer;
        this.starlight$setBlockNibbles(chunk.starlight$getBlockNibbles());
        this.starlight$setSkyNibbles(chunk.starlight$getSkyNibbles());
        this.starlight$setSkyEmptinessMap(chunk.starlight$getSkyEmptinessMap());
        this.starlight$setBlockEmptinessMap(chunk.starlight$getBlockEmptinessMap());
    }

    public void setUnsavedListener(UnsavedListener unsavedListener) {
        this.unsavedListener = unsavedListener;
        if (this.isUnsaved()) {
            unsavedListener.setUnsaved(this.chunkPos);
        }
    }

    @Override
    public long getInhabitedTime() {
        return this.level.paperConfig().chunks.fixedChunkInhabitedTime < 0 ? super.getInhabitedTime() : (long)this.level.paperConfig().chunks.fixedChunkInhabitedTime;
    }

    @Override
    public void markUnsaved() {
        boolean isUnsaved = this.isUnsaved();
        super.markUnsaved();
        if (!isUnsaved) {
            this.unsavedListener.setUnsaved(this.chunkPos);
        }
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public ChunkAccess.PackedTicks getTicksForSerialization(long gametime) {
        return new ChunkAccess.PackedTicks(this.blockTicks.pack(gametime), this.fluidTicks.pack(gametime));
    }

    @Override
    public GameEventListenerRegistry getListenerRegistry(int sectionY) {
        GameEventListenerRegistry gameEventListenerRegistry;
        ServerLevel serverLevel = this.level;
        if (serverLevel instanceof ServerLevel) {
            ServerLevel serverLevel2 = serverLevel;
            gameEventListenerRegistry = (GameEventListenerRegistry)this.gameEventListenerRegistrySections.computeIfAbsent(sectionY, i -> new EuclideanGameEventListenerRegistry(serverLevel2, sectionY, this::removeGameEventListenerRegistry));
        } else {
            gameEventListenerRegistry = super.getListenerRegistry(sectionY);
        }
        return gameEventListenerRegistry;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return this.getBlockStateFinal(x, y, z);
    }

    public BlockState getBlockStateFinal(int x, int y, int z) {
        int sectionIndex = this.getSectionIndex(y);
        if (sectionIndex < 0 || sectionIndex >= this.sections.length || this.sections[sectionIndex].nonEmptyBlockCount == 0) {
            return Blocks.AIR.defaultBlockState();
        }
        return this.sections[sectionIndex].states.get((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF);
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockStateFinal(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public final FluidState getFluidIfLoaded(BlockPos blockposition) {
        return this.getFluidState(blockposition);
    }

    @Override
    public final BlockState getBlockStateIfLoaded(BlockPos blockposition) {
        return this.getBlockState(blockposition);
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        return this.getFluidState(pos.getX(), pos.getY(), pos.getZ());
    }

    public FluidState getFluidState(int x, int y, int z) {
        LevelChunkSection levelChunkSection;
        int sectionIndex = this.getSectionIndex(y);
        if (sectionIndex >= 0 && sectionIndex < this.sections.length && !(levelChunkSection = this.sections[sectionIndex]).hasOnlyAir()) {
            return levelChunkSection.states.get((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF).getFluidState();
        }
        return Fluids.EMPTY.defaultFluidState();
    }

    @Override
    @Nullable
    public BlockState setBlockState(BlockPos pos, BlockState state, boolean isMoving) {
        return this.setBlockState(pos, state, isMoving, true);
    }

    @Nullable
    public BlockState setBlockState(BlockPos pos, BlockState state, boolean isMoving, boolean doPlace) {
        int i2;
        int i1;
        int y = pos.getY();
        LevelChunkSection section = this.getSection(this.getSectionIndex(y));
        boolean hasOnlyAir = section.hasOnlyAir();
        if (hasOnlyAir && state.isAir()) {
            return null;
        }
        int i = pos.getX() & 0xF;
        BlockState blockState = section.setBlockState(i, i1 = y & 0xF, i2 = pos.getZ() & 0xF, state);
        if (blockState == state) {
            return null;
        }
        Block block = state.getBlock();
        this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING).update(i, y, i2, state);
        this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).update(i, y, i2, state);
        this.heightmaps.get(Heightmap.Types.OCEAN_FLOOR).update(i, y, i2, state);
        this.heightmaps.get(Heightmap.Types.WORLD_SURFACE).update(i, y, i2, state);
        boolean hasOnlyAir1 = section.hasOnlyAir();
        if (hasOnlyAir != hasOnlyAir1) {
            this.level.getChunkSource().getLightEngine().updateSectionStatus(pos, hasOnlyAir1);
            this.level.getChunkSource().onSectionEmptinessChanged(this.chunkPos.x, SectionPos.blockToSectionCoord(y), this.chunkPos.z, hasOnlyAir1);
        }
        if (LightEngine.hasDifferentLightProperties(blockState, state)) {
            ProfilerFiller profilerFiller = Profiler.get();
            profilerFiller.push("updateSkyLightSources");
            profilerFiller.popPush("queueCheckLight");
            this.level.getChunkSource().getLightEngine().checkBlock(pos);
            profilerFiller.pop();
        }
        boolean hasBlockEntity = blockState.hasBlockEntity();
        if (!this.level.isClientSide && !this.level.isBlockPlaceCancelled) {
            blockState.onRemove(this.level, pos, state, isMoving);
        } else if (!blockState.is(block) && hasBlockEntity) {
            this.removeBlockEntity(pos);
        }
        if (!section.getBlockState(i, i1, i2).is(block)) {
            return null;
        }
        if (!this.level.isClientSide && doPlace && (!this.level.captureBlockStates || block instanceof BaseEntityBlock)) {
            state.onPlace(this.level, pos, blockState, isMoving);
        }
        if (state.hasBlockEntity()) {
            BlockEntity blockEntity = this.getBlockEntity(pos, EntityCreationType.CHECK);
            if (blockEntity != null && !blockEntity.isValidBlockState(state)) {
                LOGGER.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{pos, blockEntity.getType().builtInRegistryHolder().key().location(), state});
                this.removeBlockEntity(pos);
                blockEntity = null;
            }
            if (blockEntity == null) {
                blockEntity = ((EntityBlock)((Object)block)).newBlockEntity(pos, state);
                if (blockEntity != null) {
                    this.addAndRegisterBlockEntity(blockEntity);
                }
            } else {
                blockEntity.setBlockState(state);
                this.updateBlockEntityTicker(blockEntity);
            }
        }
        this.markUnsaved();
        return blockState;
    }

    @Override
    @Deprecated
    public void addEntity(Entity entity) {
    }

    @Nullable
    private BlockEntity createBlockEntity(BlockPos pos) {
        BlockState blockState = this.getBlockState(pos);
        return !blockState.hasBlockEntity() ? null : ((EntityBlock)((Object)blockState.getBlock())).newBlockEntity(pos, blockState);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.getBlockEntity(pos, EntityCreationType.CHECK);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos, EntityCreationType creationType) {
        BlockEntity blockEntity1;
        CompoundTag compoundTag;
        BlockEntity blockEntity = this.level.capturedTileEntities.get(pos);
        if (blockEntity == null) {
            blockEntity = this.blockEntities.get(pos);
        }
        if (blockEntity == null && (compoundTag = this.pendingBlockEntities.remove(pos)) != null && (blockEntity1 = this.promotePendingBlockEntity(pos, compoundTag)) != null) {
            return blockEntity1;
        }
        if (blockEntity == null) {
            if (creationType == EntityCreationType.IMMEDIATE && (blockEntity = this.createBlockEntity(pos)) != null) {
                this.addAndRegisterBlockEntity(blockEntity);
            }
        } else if (blockEntity.isRemoved()) {
            this.blockEntities.remove(pos);
            return null;
        }
        return blockEntity;
    }

    public void addAndRegisterBlockEntity(BlockEntity blockEntity) {
        this.setBlockEntity(blockEntity);
        if (this.isInLevel()) {
            ServerLevel serverLevel = this.level;
            if (serverLevel instanceof ServerLevel) {
                ServerLevel serverLevel2 = serverLevel;
                this.addGameEventListener(blockEntity, serverLevel2);
            }
            this.updateBlockEntityTicker(blockEntity);
        }
    }

    private boolean isInLevel() {
        return this.loaded || this.level.isClientSide();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isTicking(BlockPos pos) {
        if (!this.level.getWorldBorder().isWithinBounds(pos)) return false;
        ServerLevel serverLevel = this.level;
        if (!(serverLevel instanceof ServerLevel)) return true;
        ServerLevel serverLevel2 = serverLevel;
        if (!this.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING)) return false;
        if (!serverLevel2.areEntitiesLoaded(ChunkPos.asLong(pos))) return false;
        return true;
    }

    @Override
    public void setBlockEntity(BlockEntity blockEntity) {
        BlockPos blockPos = blockEntity.getBlockPos();
        BlockState blockState = this.getBlockState(blockPos);
        if (!blockState.hasBlockEntity()) {
            ServerInternalException e = new ServerInternalException("Trying to set block entity %s at position %s, but state %s does not allow it".formatted(blockEntity, blockPos, blockState));
            e.printStackTrace();
            ServerInternalException.reportInternalException((Throwable)e);
        } else {
            BlockState blockState1 = blockEntity.getBlockState();
            if (blockState != blockState1) {
                if (!blockEntity.getType().isValid(blockState)) {
                    LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{blockEntity, blockPos, blockState});
                    return;
                }
                if (blockState.getBlock() != blockState1.getBlock()) {
                    LOGGER.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{blockEntity, blockPos, blockState, blockState1});
                }
                blockEntity.setBlockState(blockState);
            }
            blockEntity.setLevel(this.level);
            blockEntity.clearRemoved();
            BlockEntity blockEntity1 = this.blockEntities.put(blockPos.immutable(), blockEntity);
            if (blockEntity1 != null && blockEntity1 != blockEntity) {
                blockEntity1.setRemoved();
            }
        }
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbtForSaving(BlockPos pos, HolderLookup.Provider registries) {
        BlockEntity blockEntity = this.getBlockEntity(pos);
        if (blockEntity != null && !blockEntity.isRemoved()) {
            CompoundTag compoundTag = blockEntity.saveWithFullMetadata(this.level.registryAccess());
            compoundTag.putBoolean("keepPacked", false);
            return compoundTag;
        }
        CompoundTag compoundTag = this.pendingBlockEntities.get(pos);
        if (compoundTag != null) {
            compoundTag = compoundTag.copy();
            compoundTag.putBoolean("keepPacked", true);
        }
        return compoundTag;
    }

    @Override
    public void removeBlockEntity(BlockPos pos) {
        if (this.isInLevel()) {
            BlockEntity blockEntity = this.blockEntities.remove(pos);
            if (!this.pendingBlockEntities.isEmpty()) {
                this.pendingBlockEntities.remove(pos);
            }
            if (blockEntity != null) {
                ServerLevel serverLevel = this.level;
                if (serverLevel instanceof ServerLevel) {
                    ServerLevel serverLevel2 = serverLevel;
                    this.removeGameEventListener(blockEntity, serverLevel2);
                }
                blockEntity.setRemoved();
            }
        }
        this.removeBlockEntityTicker(pos);
    }

    private <T extends BlockEntity> void removeGameEventListener(T blockEntity, ServerLevel level) {
        GameEventListener listener;
        Block block = blockEntity.getBlockState().getBlock();
        if (block instanceof EntityBlock && (listener = ((EntityBlock)((Object)block)).getListener(level, blockEntity)) != null) {
            int sectionPosY = SectionPos.blockToSectionCoord(blockEntity.getBlockPos().getY());
            GameEventListenerRegistry listenerRegistry = this.getListenerRegistry(sectionPosY);
            listenerRegistry.unregister(listener);
        }
    }

    private void removeGameEventListenerRegistry(int sectionY) {
        this.gameEventListenerRegistrySections.remove(sectionY);
    }

    private void removeBlockEntityTicker(BlockPos pos) {
        RebindableTickingBlockEntityWrapper rebindableTickingBlockEntityWrapper = this.tickersInLevel.remove(pos);
        if (rebindableTickingBlockEntityWrapper != null) {
            rebindableTickingBlockEntityWrapper.rebind(NULL_TICKER);
        }
    }

    public void runPostLoad() {
        if (this.postLoad != null) {
            this.postLoad.run(this);
            this.postLoad = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        if (this.loadedTicketLevel) {
            LOGGER.error("Double calling chunk load!", new Throwable());
        }
        this.loadedTicketLevel = true;
        CraftServer server = this.level.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((Chunk)bukkitChunk, this.needsDecoration));
            CraftEventFactory.callEntitiesLoadEvent(this.level, this.chunkPos, this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.level.getSeed());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.chunkPos.x * xRand + (long)this.chunkPos.z * zRand ^ this.level.getSeed());
                CraftWorld world = this.level.getWorld();
                if (world != null) {
                    this.level.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((World)world, random, (Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.level.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        if (!this.loadedTicketLevel) {
            LOGGER.error("Double calling chunk unload!", new Throwable());
        }
        CraftServer server = this.level.getCraftServer();
        CraftEventFactory.callEntitiesUnloadEvent(this.level, this.chunkPos, this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((Chunk)bukkitChunk, true);
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
        this.loadedTicketLevel = false;
    }

    @Override
    public boolean isUnsaved() {
        long gameTime = this.level.getGameTime();
        if (this.blockTicks.moonrise$isDirty(gameTime) || this.fluidTicks.moonrise$isDirty(gameTime)) {
            return true;
        }
        return super.isUnsaved();
    }

    @Override
    public boolean tryMarkSaved() {
        if (!this.isUnsaved()) {
            return false;
        }
        this.blockTicks.moonrise$clearDirty();
        this.fluidTicks.moonrise$clearDirty();
        super.tryMarkSaved();
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    public void replaceWithPacketData(FriendlyByteBuf buffer, CompoundTag tag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> outputTagConsumer) {
        this.clearAllBlockEntities();
        for (LevelChunkSection levelChunkSection : this.sections) {
            levelChunkSection.read(buffer);
        }
        for (Heightmap.Types types : Heightmap.Types.values()) {
            String serializationKey = types.getSerializationKey();
            if (!tag.contains(serializationKey, 12)) continue;
            this.setHeightmap(types, tag.getLongArray(serializationKey));
        }
        this.initializeLightSources();
        outputTagConsumer.accept((pos, blockEntityType, blockEntityTag) -> {
            BlockEntity blockEntity = this.getBlockEntity(pos, EntityCreationType.IMMEDIATE);
            if (blockEntity != null && blockEntityTag != null && blockEntity.getType() == blockEntityType) {
                blockEntity.loadWithComponents(blockEntityTag, this.level.registryAccess());
            }
        });
    }

    public void replaceBiomes(FriendlyByteBuf buffer) {
        for (LevelChunkSection levelChunkSection : this.sections) {
            levelChunkSection.readBiomes(buffer);
        }
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public Level getLevel() {
        return this.level;
    }

    public Map<BlockPos, BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void postProcessGeneration(ServerLevel level) {
        ChunkPos pos = this.getPos();
        for (int i = 0; i < this.postProcessing.length; ++i) {
            if (this.postProcessing[i] == null) continue;
            for (Short _short : this.postProcessing[i]) {
                BlockState blockState1;
                BlockPos blockPos = ProtoChunk.unpackOffsetCoordinates(_short, this.getSectionYFromSectionIndex(i), pos);
                BlockState blockState = this.getBlockState(blockPos);
                FluidState fluidState = blockState.getFluidState();
                if (!fluidState.isEmpty()) {
                    fluidState.tick(level, blockPos, blockState);
                }
                if (blockState.getBlock() instanceof LiquidBlock || (blockState1 = Block.updateFromNeighbourShapes(blockState, level, blockPos)) == blockState) continue;
                level.setBlock(blockPos, blockState1, 20);
            }
            this.postProcessing[i].clear();
        }
        for (BlockPos blockPos1 : ImmutableList.copyOf(this.pendingBlockEntities.keySet())) {
            this.getBlockEntity(blockPos1);
        }
        this.pendingBlockEntities.clear();
        this.upgradeData.upgrade(this);
        this.postProcessingDone = true;
    }

    @Nullable
    private BlockEntity promotePendingBlockEntity(BlockPos pos, CompoundTag tag) {
        BlockEntity blockEntity;
        BlockState blockState = this.getBlockState(pos);
        if ("DUMMY".equals(tag.getString("id"))) {
            if (blockState.hasBlockEntity()) {
                blockEntity = ((EntityBlock)((Object)blockState.getBlock())).newBlockEntity(pos, blockState);
            } else {
                blockEntity = null;
                LOGGER.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)pos, (Object)blockState);
            }
        } else {
            blockEntity = BlockEntity.loadStatic(pos, blockState, tag, this.level.registryAccess());
        }
        if (blockEntity != null) {
            blockEntity.setLevel(this.level);
            this.addAndRegisterBlockEntity(blockEntity);
        } else {
            LOGGER.warn("Tried to load a block entity for block {} but failed at location {}", (Object)blockState, (Object)pos);
        }
        return blockEntity;
    }

    public void unpackTicks(long pos) {
        this.blockTicks.unpack(pos);
        this.fluidTicks.unpack(pos);
    }

    public void registerTickContainerInLevel(ServerLevel level) {
        ((LevelTicks)level.getBlockTicks()).addContainer(this.chunkPos, this.blockTicks);
        ((LevelTicks)level.getFluidTicks()).addContainer(this.chunkPos, this.fluidTicks);
    }

    public void unregisterTickContainerFromLevel(ServerLevel level) {
        ((LevelTicks)level.getBlockTicks()).removeContainer(this.chunkPos);
        ((LevelTicks)level.getFluidTicks()).removeContainer(this.chunkPos);
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return ChunkStatus.FULL;
    }

    public FullChunkStatus getFullStatus() {
        return this.fullStatus == null ? FullChunkStatus.FULL : this.fullStatus.get();
    }

    public void setFullStatus(Supplier<FullChunkStatus> fullStatus) {
        this.fullStatus = fullStatus;
    }

    public void clearAllBlockEntities() {
        this.blockEntities.values().forEach(BlockEntity::setRemoved);
        this.blockEntities.clear();
        this.tickersInLevel.values().forEach(ticker -> ticker.rebind(NULL_TICKER));
        this.tickersInLevel.clear();
    }

    public void registerAllBlockEntitiesAfterLevelLoad() {
        this.blockEntities.values().forEach(blockEntity -> {
            ServerLevel patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = patt0$temp;
                this.addGameEventListener(blockEntity, serverLevel);
            }
            this.updateBlockEntityTicker(blockEntity);
        });
    }

    private <T extends BlockEntity> void addGameEventListener(T blockEntity, ServerLevel level) {
        GameEventListener listener;
        Block block = blockEntity.getBlockState().getBlock();
        if (block instanceof EntityBlock && (listener = ((EntityBlock)((Object)block)).getListener(level, blockEntity)) != null) {
            this.getListenerRegistry(SectionPos.blockToSectionCoord(blockEntity.getBlockPos().getY())).register(listener);
        }
    }

    private <T extends BlockEntity> void updateBlockEntityTicker(T blockEntity) {
        BlockState blockState = blockEntity.getBlockState();
        BlockEntityTicker<?> ticker = blockState.getTicker(this.level, blockEntity.getType());
        if (ticker == null) {
            this.removeBlockEntityTicker(blockEntity.getBlockPos());
        } else {
            this.tickersInLevel.compute(blockEntity.getBlockPos(), (pos, ticker1) -> {
                TickingBlockEntity tickingBlockEntity = this.createTicker(blockEntity, ticker);
                if (ticker1 != null) {
                    ticker1.rebind(tickingBlockEntity);
                    return ticker1;
                }
                if (this.isInLevel()) {
                    RebindableTickingBlockEntityWrapper rebindableTickingBlockEntityWrapper = new RebindableTickingBlockEntityWrapper(tickingBlockEntity);
                    this.level.addBlockEntityTicker(rebindableTickingBlockEntityWrapper);
                    return rebindableTickingBlockEntityWrapper;
                }
                return null;
            });
        }
    }

    private <T extends BlockEntity> TickingBlockEntity createTicker(T blockEntity, BlockEntityTicker<T> ticker) {
        return new BoundTickingBlockEntity(this, blockEntity, ticker);
    }

    private /* synthetic */ String lambda$getBlockState$2(int x, int y, int z) throws Exception {
        return CrashReportCategory.formatLocation((LevelHeightAccessor)this, x, y, z);
    }

    @FunctionalInterface
    public static interface PostLoadProcessor {
        public void run(LevelChunk var1);
    }

    @FunctionalInterface
    public static interface UnsavedListener {
        public void setUnsaved(ChunkPos var1);
    }

    public static enum EntityCreationType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }

    static class RebindableTickingBlockEntityWrapper
    implements TickingBlockEntity {
        private TickingBlockEntity ticker;

        RebindableTickingBlockEntityWrapper(TickingBlockEntity ticker) {
            this.ticker = ticker;
        }

        void rebind(TickingBlockEntity ticker) {
            this.ticker = ticker;
        }

        @Override
        public void tick() {
            this.ticker.tick();
        }

        @Override
        public boolean isRemoved() {
            return this.ticker.isRemoved();
        }

        @Override
        public BlockPos getPos() {
            return this.ticker.getPos();
        }

        @Override
        public String getType() {
            return this.ticker.getType();
        }

        public String toString() {
            return String.valueOf(this.ticker) + " <wrapped>";
        }
    }

    static class BoundTickingBlockEntity<T extends BlockEntity>
    implements TickingBlockEntity {
        private final T blockEntity;
        private final BlockEntityTicker<T> ticker;
        private boolean loggedInvalidBlockState;
        final /* synthetic */ LevelChunk this$0;

        BoundTickingBlockEntity(T blockEntity, BlockEntityTicker<T> ticker) {
            this.this$0 = this$0;
            this.blockEntity = blockEntity;
            this.ticker = ticker;
        }

        @Override
        public void tick() {
            BlockPos blockPos;
            if (!((BlockEntity)this.blockEntity).isRemoved() && ((BlockEntity)this.blockEntity).hasLevel() && this.this$0.isTicking(blockPos = ((BlockEntity)this.blockEntity).getBlockPos())) {
                try {
                    ProfilerFiller profilerFiller = Profiler.get();
                    profilerFiller.push(this::getType);
                    BlockState blockState = this.this$0.getBlockState(blockPos);
                    if (((BlockEntity)this.blockEntity).getType().isValid(blockState)) {
                        this.ticker.tick(this.this$0.level, ((BlockEntity)this.blockEntity).getBlockPos(), blockState, this.blockEntity);
                        this.loggedInvalidBlockState = false;
                    } else {
                        this.this$0.removeBlockEntity(this.getPos());
                        if (!this.loggedInvalidBlockState) {
                            this.loggedInvalidBlockState = true;
                            LOGGER.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::getType), LogUtils.defer(this::getPos), blockState});
                        }
                    }
                    profilerFiller.pop();
                }
                catch (Throwable var5) {
                    String msg = String.format("BlockEntity threw exception at %s:%s,%s,%s", this.this$0.getLevel().getWorld().getName(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
                    MinecraftServer.LOGGER.error(msg, var5);
                    this.this$0.level.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, var5)));
                    this.this$0.removeBlockEntity(this.getPos());
                }
            }
        }

        @Override
        public boolean isRemoved() {
            return ((BlockEntity)this.blockEntity).isRemoved();
        }

        @Override
        public BlockPos getPos() {
            return ((BlockEntity)this.blockEntity).getBlockPos();
        }

        @Override
        public String getType() {
            return BlockEntityType.getKey(((BlockEntity)this.blockEntity).getType()).toString();
        }

        public String toString() {
            return "Level ticker for " + this.getType() + "@" + String.valueOf(this.getPos());
        }
    }
}

