/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.SingleValuePalette;
import org.jetbrains.annotations.Nullable;

public class PalettedContainer<T>
implements PaletteResize<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private final PaletteResize<T> dummyPaletteResize = (bits, objectAdded) -> 0;
    public final IdMap<T> registry;
    private final T @Nullable [] presetValues;
    public volatile Data<T> data;
    private final Strategy strategy;

    public void acquire() {
    }

    public void release() {
    }

    @Deprecated
    @DoNotUse
    public static <T> Codec<PalettedContainer<T>> codecRW(IdMap<T> registry, Codec<T> codec, Strategy strategy, T value) {
        return PalettedContainer.codecRW(registry, codec, strategy, value, null);
    }

    public static <T> Codec<PalettedContainer<T>> codecRW(IdMap<T> registry, Codec<T> codec, Strategy strategy, T value, T @Nullable [] presetValues) {
        PalettedContainerRO.Unpacker unpacker = (idListx, paletteProviderx, serialized) -> PalettedContainer.unpack(idListx, paletteProviderx, serialized, value, presetValues);
        return PalettedContainer.codec(registry, codec, strategy, value, unpacker);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(IdMap<T> registry, Codec<T> codec, Strategy strategy, T value) {
        PalettedContainerRO.Unpacker unpacker = (registry1, strategy1, packedData) -> PalettedContainer.unpack(registry1, strategy1, packedData, value, null).map(container -> container);
        return PalettedContainer.codec(registry, codec, strategy, value, unpacker);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(IdMap<T> registry, Codec<T> codec, Strategy strategy, T value, PalettedContainerRO.Unpacker<T, C> unpacker) {
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.mapResult(ExtraCodecs.orElsePartial(value)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.PackedData::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.PackedData::storage)).apply((Applicative)instance, PalettedContainerRO.PackedData::new)).comapFlatMap(packedData -> unpacker.read(registry, strategy, (PalettedContainerRO.PackedData)packedData), container -> container.pack(registry, strategy));
    }

    private void updateData(Data<T> data) {
        if (data != null) {
            ((FastPaletteData)data).moonrise$setPalette(data.palette.moonrise$getRawPalette(data));
        }
    }

    private T readPaletteSlow(Data<T> data, int paletteIdx) {
        return data.palette.valueFor(paletteIdx);
    }

    private T readPalette(Data<T> data, int paletteIdx) {
        T[] palette = ((FastPaletteData)data).moonrise$getPalette();
        if (palette == null) {
            return this.readPaletteSlow(data, paletteIdx);
        }
        Object ret = palette[paletteIdx];
        if (ret == null) {
            throw new IllegalArgumentException("Palette index out of bounds");
        }
        return ret;
    }

    @Deprecated
    @DoNotUse
    public PalettedContainer(IdMap<T> registry, Strategy strategy, Configuration<T> configuration, BitStorage storage, List<T> values) {
        this(registry, strategy, configuration, storage, values, null, null);
    }

    public PalettedContainer(IdMap<T> registry, Strategy strategy, Configuration<T> configuration, BitStorage storage, List<T> values, T defaultValue, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.registry = registry;
        this.strategy = strategy;
        this.data = new Data<T>(configuration, storage, configuration.factory().create(configuration.bits(), registry, this, values));
        if (presetValues != null && (configuration.factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY ? this.data.palette.valueFor(0) != defaultValue : configuration.factory() != Strategy.GLOBAL_PALETTE_FACTORY)) {
            int maxSize = 1 << configuration.bits();
            for (T presetValue : presetValues) {
                if (this.data.palette.getSize() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(values);
                    allValues.addAll(Arrays.asList(presetValues));
                    int newBits = Mth.ceillog2(allValues.size());
                    if (newBits <= configuration.bits()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.data.palette.idFor(presetValue);
            }
        }
        this.updateData(this.data);
    }

    private PalettedContainer(IdMap<T> registry, Strategy strategy, Data<T> data, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.registry = registry;
        this.strategy = strategy;
        this.data = data;
        this.updateData(this.data);
    }

    private PalettedContainer(PalettedContainer<T> other, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.registry = other.registry;
        this.strategy = other.strategy;
        this.data = other.data.copy(this);
    }

    @Deprecated
    @DoNotUse
    public PalettedContainer(IdMap<T> registry, T palette, Strategy strategy) {
        this(registry, palette, strategy, null);
    }

    public PalettedContainer(IdMap<T> registry, T palette, Strategy strategy, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.strategy = strategy;
        this.registry = registry;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(palette);
        this.updateData(this.data);
    }

    private Data<T> createOrReuseData(@javax.annotation.Nullable Data<T> data, int id) {
        Configuration<T> configuration = this.strategy.getConfiguration(this.registry, id);
        return data != null && configuration.equals(data.configuration()) ? data : configuration.createData(this.registry, this, this.strategy.size());
    }

    @Override
    public synchronized int onResize(int bits, T objectAdded) {
        Data<T> data = this.data;
        if (this.presetValues != null && objectAdded != null && data.configuration().factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.presetValues);
            duplicates += presetValues.contains(objectAdded) ? 1 : 0;
            bits = Mth.ceillog2((1 << this.strategy.calculateBitsForSerialization(this.registry, 1 << bits)) + presetValues.size() - (duplicates += presetValues.contains(data.palette.valueFor(0)) ? 1 : 0));
        }
        Data data1 = this.createOrReuseData(data, bits);
        data1.copyFrom(data.palette, data.storage);
        this.data = data1;
        this.addPresetValues();
        this.updateData(this.data);
        return objectAdded == null ? -1 : data1.palette.idFor(objectAdded);
    }

    private void addPresetValues() {
        if (this.presetValues != null && this.data.configuration().factory() != Strategy.GLOBAL_PALETTE_FACTORY) {
            for (T presetValue : this.presetValues) {
                this.data.palette.idFor(presetValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T getAndSet(int x, int y, int z, T state) {
        T var5;
        this.acquire();
        try {
            var5 = this.getAndSet(this.strategy.getIndex(x, y, z), state);
        }
        finally {
            this.release();
        }
        return var5;
    }

    public T getAndSetUnchecked(int x, int y, int z, T state) {
        return this.getAndSet(this.strategy.getIndex(x, y, z), state);
    }

    private T getAndSet(int index, T state) {
        int paletteIdx = this.data.palette.idFor(state);
        Data<T> data = this.data;
        int prev = data.storage.getAndSet(index, paletteIdx);
        return this.readPalette(data, prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(int x, int y, int z, T state) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(x, y, z), state);
        }
        finally {
            this.release();
        }
    }

    private void set(int index, T state) {
        int i = this.data.palette.idFor(state);
        this.data.storage.set(index, i);
    }

    @Override
    public T get(int x, int y, int z) {
        return this.get(this.strategy.getIndex(x, y, z));
    }

    public T get(int index) {
        Data<T> data = this.data;
        return this.readPalette(data, data.storage.get(index));
    }

    @Override
    public void getAll(Consumer<T> consumer) {
        Palette palette = this.data.palette();
        IntArraySet set = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)set).add(arg_0));
        set.forEach(id -> consumer.accept(palette.valueFor(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(FriendlyByteBuf buffer) {
        this.acquire();
        try {
            byte _byte = buffer.readByte();
            Data<T> data = this.createOrReuseData(this.data, _byte);
            data.palette.read(buffer);
            buffer.readLongArray(data.storage.getRaw());
            this.data = data;
            this.addPresetValues();
            this.updateData(this.data);
        }
        finally {
            this.release();
        }
    }

    @Override
    @Deprecated
    @DoNotUse
    public void write(FriendlyByteBuf buffer) {
        this.write(buffer, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(FriendlyByteBuf buffer, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
        this.acquire();
        try {
            this.data.write(buffer, chunkPacketInfo, chunkSectionIndex);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setPresetValues(chunkSectionIndex, this.presetValues);
            }
        }
        finally {
            this.release();
        }
    }

    private static <T> DataResult<PalettedContainer<T>> unpack(IdMap<T> registry, Strategy strategy, PalettedContainerRO.PackedData<T> packedData, T defaultValue, T @Nullable [] presetValues) {
        BitStorage bitStorage;
        List<T> list = packedData.paletteEntries();
        int size = strategy.size();
        int i = strategy.calculateBitsForSerialization(registry, list.size());
        Configuration<T> configuration = strategy.getConfiguration(registry, i);
        if (i == 0) {
            bitStorage = new ZeroBitStorage(size);
        } else {
            Optional<LongStream> optional = packedData.storage();
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] longs = optional.get().toArray();
            try {
                if (configuration.factory() == Strategy.GLOBAL_PALETTE_FACTORY) {
                    HashMapPalette<Object> palette = new HashMapPalette<Object>(registry, i, (bits, objectAdded) -> 0, list);
                    SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i, size, longs);
                    int[] ints = new int[size];
                    simpleBitStorage.unpack(ints);
                    PalettedContainer.swapPalette(ints, id -> registry.getId(palette.valueFor(id)));
                    bitStorage = new SimpleBitStorage(configuration.bits(), size, ints);
                } else {
                    bitStorage = new SimpleBitStorage(configuration.bits(), size, longs);
                }
            }
            catch (SimpleBitStorage.InitializationException var13) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var13.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(registry, strategy, configuration, bitStorage, list, defaultValue, presetValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PalettedContainerRO.PackedData<T> pack(IdMap<T> registry, Strategy strategy) {
        PalettedContainerRO.PackedData<T> var12;
        this.acquire();
        try {
            Optional<LongStream> optional;
            HashMapPalette<T> hashMapPalette = new HashMapPalette<T>(registry, this.data.storage.getBits(), this.dummyPaletteResize);
            int size = strategy.size();
            int[] ints = new int[size];
            this.data.storage.unpack(ints);
            PalettedContainer.swapPalette(ints, id -> hashMapPalette.idFor(this.data.palette.valueFor(id)));
            int i = strategy.calculateBitsForSerialization(registry, hashMapPalette.getSize());
            if (i != 0) {
                SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i, size, ints);
                optional = Optional.of(Arrays.stream(simpleBitStorage.getRaw()));
            } else {
                optional = Optional.empty();
            }
            var12 = new PalettedContainerRO.PackedData<T>(hashMapPalette.getEntries(), optional);
        }
        finally {
            this.release();
        }
        return var12;
    }

    private static <T> void swapPalette(int[] bits, IntUnaryOperator operator) {
        int i = -1;
        int i1 = -1;
        for (int i2 = 0; i2 < bits.length; ++i2) {
            int i3 = bits[i2];
            if (i3 != i) {
                i = i3;
                i1 = operator.applyAsInt(i3);
            }
            bits[i2] = i1;
        }
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize();
    }

    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        return this.data.palette.maybeHas(predicate);
    }

    @Override
    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this, this.presetValues);
    }

    @Override
    public PalettedContainer<T> recreate() {
        return new PalettedContainer<T>(this.registry, this.data.palette.valueFor(0), this.strategy, this.presetValues);
    }

    @Override
    public void count(CountConsumer<T> countConsumer) {
        if (this.data.palette.getSize() == 1) {
            countConsumer.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
        } else {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            this.data.storage.getAll((int id) -> map.addTo(id, 1));
            map.int2IntEntrySet().forEach(idEntry -> countConsumer.accept(this.data.palette.valueFor(idEntry.getIntKey()), idEntry.getIntValue()));
        }
    }

    public static abstract class Strategy {
        public static final Palette.Factory SINGLE_VALUE_PALETTE_FACTORY = SingleValuePalette::create;
        public static final Palette.Factory LINEAR_PALETTE_FACTORY = LinearPalette::create;
        public static final Palette.Factory HASHMAP_PALETTE_FACTORY = HashMapPalette::create;
        static final Palette.Factory GLOBAL_PALETTE_FACTORY = GlobalPalette::create;
        public static final Strategy SECTION_STATES = new Strategy(4){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> registry, int size) {
                return switch (size) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, size);
                    case 1, 2, 3, 4 -> new Configuration(LINEAR_PALETTE_FACTORY, 4);
                    case 5, 6, 7, 8 -> new Configuration(HASHMAP_PALETTE_FACTORY, size);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(registry.size()));
                };
            }
        };
        public static final Strategy SECTION_BIOMES = new Strategy(2){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> registry, int size) {
                return switch (size) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, size);
                    case 1, 2, 3 -> new Configuration(LINEAR_PALETTE_FACTORY, size);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(registry.size()));
                };
            }
        };
        private final int sizeBits;

        Strategy(int sizeBits) {
            this.sizeBits = sizeBits;
        }

        public int size() {
            return 1 << this.sizeBits * 3;
        }

        public int getIndex(int x, int y, int z) {
            return (y << this.sizeBits | z) << this.sizeBits | x;
        }

        public abstract <A> Configuration<A> getConfiguration(IdMap<A> var1, int var2);

        <A> int calculateBitsForSerialization(IdMap<A> registry, int size) {
            int i = Mth.ceillog2(size);
            Configuration<A> configuration = this.getConfiguration(registry, i);
            return configuration.factory() == GLOBAL_PALETTE_FACTORY ? i : configuration.bits();
        }
    }

    public static final class Data<T>
    implements FastPaletteData<T> {
        private final Configuration<T> configuration;
        private final BitStorage storage;
        private final Palette<T> palette;
        private T[] moonrise$palette;

        public Data(Configuration<T> configuration, BitStorage storage, Palette<T> palette) {
            this.configuration = configuration;
            this.storage = storage;
            this.palette = palette;
        }

        public Configuration<T> configuration() {
            return this.configuration;
        }

        public BitStorage storage() {
            return this.storage;
        }

        public Palette<T> palette() {
            return this.palette;
        }

        @Override
        public final T[] moonrise$getPalette() {
            return this.moonrise$palette;
        }

        @Override
        public final void moonrise$setPalette(T[] palette) {
            this.moonrise$palette = palette;
        }

        public void copyFrom(Palette<T> palette, BitStorage bitStorage) {
            for (int i = 0; i < bitStorage.getSize(); ++i) {
                T object = palette.valueFor(bitStorage.get(i));
                this.storage.set(i, this.palette.idFor(object));
            }
        }

        public int getSerializedSize() {
            return 1 + this.palette.getSerializedSize() + VarInt.getByteSize(this.storage.getRaw().length) + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf buffer, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
            buffer.writeByte(this.storage.getBits());
            this.palette.write(buffer);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setBits(chunkSectionIndex, this.configuration.bits());
                chunkPacketInfo.setPalette(chunkSectionIndex, this.palette);
                chunkPacketInfo.setIndex(chunkSectionIndex, buffer.writerIndex() + VarInt.getByteSize(this.storage.getRaw().length));
            }
            buffer.writeLongArray(this.storage.getRaw());
        }

        public Data<T> copy(PaletteResize<T> resizeHandler) {
            return new Data<T>(this.configuration, this.storage.copy(), this.palette.copy(resizeHandler));
        }
    }

    record Configuration<T>(Palette.Factory factory, int bits) {
        public Data<T> createData(IdMap<T> registry, PaletteResize<T> paletteResize, int size) {
            BitStorage bitStorage = this.bits == 0 ? new ZeroBitStorage(size) : new SimpleBitStorage(this.bits, size);
            Palette<T> palette = this.factory.create(this.bits, registry, paletteResize, List.of());
            return new Data<T>(this, bitStorage, palette);
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

