/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkStorage;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ChunkStorage
implements AutoCloseable,
ChunkSystemChunkStorage {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    protected final DataFixer fixerUpper;
    @Nullable
    private volatile LegacyStructureDataHandler legacyStructureHandler;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RegionFileStorage storage;

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    public ChunkStorage(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync) {
        this.fixerUpper = fixerUpper;
        this.storage = new IOWorker((RegionStorageInfo)info, (Path)folder, (boolean)sync).storage;
    }

    public boolean isOldChunkAround(ChunkPos pos, int radius) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag upgradeChunkTag(ResourceKey<LevelStem> levelKey, Supplier<DimensionDataStorage> storage, CompoundTag chunkData, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> chunkGeneratorKey, ChunkPos pos, @Nullable LevelAccessor levelAccessor) {
        int version = ChunkStorage.getVersion(chunkData);
        if (version == SharedConstants.getCurrentVersion().getDataVersion().getVersion()) {
            return chunkData;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            if (version < 1493 && (chunkData = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, chunkData, version, 1493)).getCompound("Level").getBoolean("hasLegacyStructureData")) {
                LegacyStructureDataHandler legacyStructureHandler;
                LegacyStructureDataHandler legacyStructureDataHandler = legacyStructureHandler = this.getLegacyStructureHandler(levelKey, storage);
                synchronized (legacyStructureDataHandler) {
                    chunkData = legacyStructureHandler.updateFromLegacy(chunkData);
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = levelAccessor != null ? ((ServerLevel)levelAccessor).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (version <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(chunkData.getCompound("Level").getString("Status"));
            }
            ChunkStorage.injectDatafixingContext(chunkData, levelKey, chunkGeneratorKey);
            chunkData = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, chunkData, Math.max(1493, version), SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            if (stopBelowZero) {
                chunkData.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            ChunkStorage.removeDatafixingContext(chunkData);
            NbtUtils.addCurrentDataVersion(chunkData);
            return chunkData;
        }
        catch (Exception var9) {
            CrashReport crashReport = CrashReport.forThrowable(var9, "Updated chunk");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Updated chunk details");
            crashReportCategory.setDetail("Data version", version);
            throw new ReportedException(crashReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LegacyStructureDataHandler getLegacyStructureHandler(ResourceKey<LevelStem> level, Supplier<DimensionDataStorage> storage) {
        LegacyStructureDataHandler legacyStructureDataHandler = this.legacyStructureHandler;
        if (legacyStructureDataHandler == null) {
            ChunkStorage chunkStorage = this;
            synchronized (chunkStorage) {
                legacyStructureDataHandler = this.legacyStructureHandler;
                if (legacyStructureDataHandler == null) {
                    this.legacyStructureHandler = legacyStructureDataHandler = LegacyStructureDataHandler.getLegacyStructureHandler(level, storage.get());
                }
            }
        }
        return legacyStructureDataHandler;
    }

    public static void injectDatafixingContext(CompoundTag chunkData, ResourceKey<LevelStem> levelKey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> chunkGeneratorKey) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("dimension", levelKey.location().toString());
        chunkGeneratorKey.ifPresent(generator -> compoundTag.putString("generator", generator.location().toString()));
        chunkData.put("__context", compoundTag);
    }

    private static void removeDatafixingContext(CompoundTag tag) {
        tag.remove("__context");
    }

    public static int getVersion(CompoundTag chunkData) {
        return NbtUtils.getDataVersion(chunkData, -1);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.read(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CompletableFuture<Void> write(ChunkPos pos, Supplier<CompoundTag> tagSupplier) {
        Supplier<CompoundTag> guardedPosCheck = () -> {
            CompoundTag nbt = (CompoundTag)tagSupplier.get();
            if (nbt != null && !pos.equals(SerializableChunkData.getChunkCoordinate(nbt))) {
                String world = this instanceof ChunkMap ? ((ChunkMap)this).level.getWorld().getName() : null;
                throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(pos) + " but compound says coordinate is " + String.valueOf(SerializableChunkData.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
            }
            return nbt;
        };
        this.handleLegacyStructureIndex(pos);
        try {
            this.storage.write(pos, guardedPosCheck.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLegacyStructureIndex(ChunkPos chunkPos) {
        if (this.legacyStructureHandler != null) {
            LegacyStructureDataHandler legacyStructureDataHandler = this.legacyStructureHandler;
            synchronized (legacyStructureDataHandler) {
                this.legacyStructureHandler.removeIndex(chunkPos.toLong());
            }
        }
    }

    public void flushWorker() {
        try {
            this.storage.flush();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public ChunkScanAccess chunkScanner() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.scanChunk(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }
}

