/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public record SerializableChunkData(Registry<Biome> biomeRegistry, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData, @Nullable Tag persistentDataContainer) {
    public static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState(), null);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";
    private static final int CURRENT_DATA_VERSION = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
    private static final boolean JUST_CORRUPT_IT = Boolean.getBoolean("Paper.ignoreWorldDataVersion");

    public static ChunkPos getChunkCoordinate(CompoundTag chunkData) {
        int dataVersion = ChunkStorage.getVersion(chunkData);
        if (dataVersion < 2842) {
            CompoundTag levelData = chunkData.getCompound("Level");
            return new ChunkPos(levelData.getInt(X_POS_TAG), levelData.getInt(Z_POS_TAG));
        }
        return new ChunkPos(chunkData.getInt(X_POS_TAG), chunkData.getInt(Z_POS_TAG));
    }

    public static long getLastWorldSaveTime(CompoundTag chunkData) {
        int dataVersion = ChunkStorage.getVersion(chunkData);
        if (dataVersion < 2842) {
            CompoundTag levelData = chunkData.getCompound("Level");
            return levelData.getLong("LastUpdate");
        }
        return chunkData.getLong("LastUpdate");
    }

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor levelHeightAccessor, RegistryAccess registries, CompoundTag tag) {
        boolean _boolean;
        ServerLevel serverLevel = (ServerLevel)levelHeightAccessor;
        if (!tag.contains("Status", 8)) {
            return null;
        }
        if (tag.contains("DataVersion", 99)) {
            int dataVersion = tag.getInt("DataVersion");
            if (!JUST_CORRUPT_IT && dataVersion > CURRENT_DATA_VERSION) {
                new RuntimeException("Server attempted to load chunk saved with newer version of minecraft! " + dataVersion + " > " + CURRENT_DATA_VERSION).printStackTrace();
                System.exit(1);
            }
        }
        ChunkPos chunkPos = new ChunkPos(tag.getInt(X_POS_TAG), tag.getInt(Z_POS_TAG));
        long _long = tag.getLong("LastUpdate");
        long _long1 = tag.getLong("InhabitedTime");
        ChunkStatus chunkStatus = ChunkStatus.byName(tag.getString("Status"));
        UpgradeData upgradeData = tag.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(tag.getCompound(TAG_UPGRADE_DATA), levelHeightAccessor) : UpgradeData.EMPTY;
        boolean bl = _boolean = chunkStatus.isOrAfter(ChunkStatus.LIGHT) && tag.get(IS_LIGHT_ON_TAG) != null && tag.getInt("starlight.light_version") == 9;
        BlendingData.Packed packed = tag.contains("blending_data", 10) ? (BlendingData.Packed)BlendingData.Packed.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("blending_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        BelowZeroRetrogen belowZeroRetrogen = tag.contains("below_zero_retrogen", 10) ? (BelowZeroRetrogen)BelowZeroRetrogen.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("below_zero_retrogen")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        long[] longArray = tag.contains("carving_mask", 12) ? tag.getLongArray("carving_mask") : null;
        CompoundTag compound = tag.getCompound(HEIGHTMAPS_TAG);
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Heightmap.Types types : chunkStatus.heightmapsAfter()) {
            String serializationKey = types.getSerializationKey();
            if (!compound.contains(serializationKey, 12)) continue;
            map.put(types, compound.getLongArray(serializationKey));
        }
        List<SavedTick<Block>> list = SavedTick.loadTickList(tag.getList(BLOCK_TICKS_TAG, 10), string -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(string)), chunkPos);
        List<SavedTick<Fluid>> list1 = SavedTick.loadTickList(tag.getList(FLUID_TICKS_TAG, 10), string -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(string)), chunkPos);
        ChunkAccess.PackedTicks packedTicks = new ChunkAccess.PackedTicks(list, list1);
        ListTag list2 = tag.getList("PostProcessing", 9);
        ShortList[] lists = new ShortList[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            ListTag list3 = list2.getList(i);
            ShortArrayList list4 = new ShortArrayList(list3.size());
            for (int i1 = 0; i1 < list3.size(); ++i1) {
                list4.add(list3.getShort(i1));
            }
            lists[i] = list4;
        }
        List list5 = Lists.transform((List)tag.getList("entities", 10), tag1 -> (CompoundTag)tag1);
        List list6 = Lists.transform((List)tag.getList("block_entities", 10), tag1 -> (CompoundTag)tag1);
        CompoundTag compound1 = tag.getCompound("structures");
        ListTag list7 = tag.getList(SECTIONS_TAG, 10);
        ArrayList<SectionData> list8 = new ArrayList<SectionData>(list7.size());
        HolderLookup.RegistryLookup registry = registries.lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainer<Holder<Biome>>> codec = SerializableChunkData.makeBiomeCodecRW((Registry<Biome>)registry);
        for (int i2 = 0; i2 < list7.size(); ++i2) {
            LevelChunkSection levelChunkSection;
            CompoundTag compound2;
            CompoundTag sectionData = compound2 = list7.getCompound(i2);
            byte _byte = compound2.getByte("Y");
            if (_byte >= levelHeightAccessor.getMinSectionY() && _byte <= levelHeightAccessor.getMaxSectionY()) {
                PalettedContainer palettedContainer;
                BlockState[] presetBlockStates = serverLevel.chunkPacketBlockController.getPresetBlockStates(serverLevel, chunkPos, _byte);
                if (compound2.contains("block_states", 10)) {
                    Codec<PalettedContainer<BlockState>> blockStateCodec = presetBlockStates == null ? BLOCK_STATE_CODEC : PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState(), presetBlockStates);
                    palettedContainer = (PalettedContainer)blockStateCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)sectionData.getCompound("block_states")).promotePartial(string -> SerializableChunkData.logErrors(chunkPos, _byte, string)).getOrThrow(ChunkReadException::new);
                } else {
                    palettedContainer = new PalettedContainer(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES, presetBlockStates);
                }
                PalettedContainer palettedContainerRo = compound2.contains("biomes", 10) ? (PalettedContainer)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound2.getCompound("biomes")).promotePartial(string -> SerializableChunkData.logErrors(chunkPos, _byte, string)).getOrThrow(ChunkReadException::new) : new PalettedContainer(registry.asHolderIdMap(), registry.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES, null);
                levelChunkSection = new LevelChunkSection(palettedContainer, palettedContainerRo);
            } else {
                levelChunkSection = null;
            }
            DataLayer dataLayer = compound2.contains(BLOCK_LIGHT_TAG, 7) ? new DataLayer(compound2.getByteArray(BLOCK_LIGHT_TAG)) : null;
            DataLayer dataLayer1 = compound2.contains(SKY_LIGHT_TAG, 7) ? new DataLayer(compound2.getByteArray(SKY_LIGHT_TAG)) : null;
            SectionData serializableChunkData = new SectionData(_byte, levelChunkSection, dataLayer, dataLayer1);
            if (sectionData.contains("starlight.blocklight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setBlockLightState(sectionData.getInt("starlight.blocklight_state"));
            }
            if (sectionData.contains("starlight.skylight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setSkyLightState(sectionData.getInt("starlight.skylight_state"));
            }
            list8.add(serializableChunkData);
        }
        return new SerializableChunkData((Registry<Biome>)registry, chunkPos, levelHeightAccessor.getMinSectionY(), _long, _long1, chunkStatus, packed, belowZeroRetrogen, upgradeData, longArray, map, packedTicks, lists, _boolean, list8, list5, list6, compound1, tag.get("ChunkBukkitValues"));
    }

    private ProtoChunk loadStarlightLightData(ServerLevel world, ProtoChunk ret) {
        boolean hasSkyLight = world.dimensionType().hasSkyLight();
        int minSection = WorldUtil.getMinLightSection(world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        if (!this.lightCorrect) {
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
            return ret;
        }
        try {
            for (SectionData sectionData : this.sectionData) {
                int y = sectionData.y();
                DataLayer blockLight = sectionData.blockLight();
                DataLayer skyLight = sectionData.skyLight();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.getData()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.getData()), skyState);
                    continue;
                }
                skyNibbles[y - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.setLightCorrect(false);
            LOGGER.error("Failed to parse light data for chunk " + String.valueOf(ret.getPos()) + " in world '" + WorldUtil.getWorldName(world) + "'", thr);
        }
        return ret;
    }

    public ProtoChunk read(ServerLevel level, PoiManager poiManager, RegionStorageInfo regionStorageInfo, ChunkPos pos) {
        Iterator protoChunkTicks1;
        ChunkAccess chunkAccess;
        if (!Objects.equals(pos, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{pos, pos, this.chunkPos});
            level.getServer().reportMisplacedChunk(this.chunkPos, pos, regionStorageInfo);
        }
        int sectionsCount = level.getSectionsCount();
        LevelChunkSection[] levelChunkSections = new LevelChunkSection[sectionsCount];
        boolean hasSkyLight = level.dimensionType().hasSkyLight();
        ServerChunkCache chunkSource = level.getChunkSource();
        LevelLightEngine lightEngine = ((ChunkSource)chunkSource).getLightEngine();
        HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.BIOME);
        boolean flag = false;
        for (SectionData sectionData : this.sectionData) {
            boolean flag2;
            SectionPos sectionPos = SectionPos.of(pos, sectionData.y);
            if (sectionData.chunkSection != null) {
                levelChunkSections[level.getSectionIndexFromSectionY((int)sectionData.y)] = sectionData.chunkSection;
            }
            boolean flag1 = sectionData.blockLight != null;
            boolean bl = flag2 = hasSkyLight && sectionData.skyLight != null;
            if (!flag1 && !flag2) continue;
            if (!flag) {
                lightEngine.retainData(pos, true);
                flag = true;
            }
            if (flag1) {
                lightEngine.queueSectionData(LightLayer.BLOCK, sectionPos, sectionData.blockLight);
            }
            if (!flag2) continue;
            lightEngine.queueSectionData(LightLayer.SKY, sectionPos, sectionData.skyLight);
        }
        ChunkType chunkType = this.chunkStatus.getChunkType();
        if (chunkType == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> levelChunkTicks = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            LevelChunkTicks<Fluid> levelChunkTicks1 = new LevelChunkTicks<Fluid>(this.packedTicks.fluids());
            chunkAccess = new LevelChunk(level.getLevel(), pos, this.upgradeData, levelChunkTicks, levelChunkTicks1, this.inhabitedTime, levelChunkSections, SerializableChunkData.postLoadChunk(level, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunkTicks<Block> protoChunkTicks = ProtoChunkTicks.load(this.packedTicks.blocks());
            protoChunkTicks1 = ProtoChunkTicks.load(this.packedTicks.fluids());
            ProtoChunk protoChunk = new ProtoChunk(pos, this.upgradeData, levelChunkSections, protoChunkTicks, (ProtoChunkTicks<Fluid>)((Object)protoChunkTicks1), level, (Registry<Biome>)registry, BlendingData.unpack(this.blendingData));
            chunkAccess = protoChunk;
            protoChunk.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                protoChunk.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            protoChunk.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                protoChunk.setLightEngine(lightEngine);
            }
        }
        protoChunkTicks1 = this.persistentDataContainer;
        if (protoChunkTicks1 instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)((Object)protoChunkTicks1);
            chunkAccess.persistentDataContainer.putAll(compoundTag);
        }
        chunkAccess.setLightCorrect(this.lightCorrect);
        EnumSet<Heightmap.Types> set = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types types : chunkAccess.getPersistedStatus().heightmapsAfter()) {
            long[] longs = this.heightmaps.get(types);
            if (longs != null) {
                chunkAccess.setHeightmap(types, longs);
                continue;
            }
            set.add(types);
        }
        Heightmap.primeHeightmaps(chunkAccess, set);
        chunkAccess.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel(level), this.structureData, level.getSeed()));
        chunkAccess.setAllReferences(SerializableChunkData.unpackStructureReferences(level.registryAccess(), pos, this.structureData));
        for (int i = 0; i < this.postProcessingSections.length; ++i) {
            chunkAccess.addPackedPostProcess(this.postProcessingSections[i], i);
        }
        if (chunkType == ChunkType.LEVELCHUNK) {
            return this.loadStarlightLightData(level, new ImposterProtoChunk((LevelChunk)chunkAccess, false));
        }
        ProtoChunk protoChunk1 = (ProtoChunk)chunkAccess;
        for (CompoundTag compoundTag : this.entities) {
            protoChunk1.addEntity(compoundTag);
        }
        for (CompoundTag compoundTag : this.blockEntities) {
            BlockPos blockposition = BlockEntity.getPosFromTag(compoundTag);
            if (blockposition.getX() >> 4 != this.chunkPos.x || blockposition.getZ() >> 4 != this.chunkPos.z) {
                LOGGER.warn("Tile entity serialized in chunk {} in world '{}' positioned at {} is located outside of the chunk", new Object[]{this.chunkPos, level.getWorld().getName(), blockposition});
                continue;
            }
            protoChunk1.setBlockEntityNbt(compoundTag);
        }
        if (this.carvingMask != null) {
            protoChunk1.setCarvingMask(new CarvingMask(this.carvingMask, chunkAccess.getMinY()));
        }
        return this.loadStarlightLightData(level, protoChunk1);
    }

    private static void logErrors(ChunkPos chunkPos, int sectionY, String error) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.x, sectionY, chunkPos.z, error});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> biomeRegistry) {
        return PalettedContainer.codecRO(biomeRegistry.asHolderIdMap(), biomeRegistry.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, biomeRegistry.getOrThrow(Biomes.PLAINS));
    }

    private static Codec<PalettedContainer<Holder<Biome>>> makeBiomeCodecRW(Registry<Biome> biomeRegistry) {
        return PalettedContainer.codecRW(biomeRegistry.asHolderIdMap(), biomeRegistry.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, biomeRegistry.getOrThrow(Biomes.PLAINS), null);
    }

    public static SerializableChunkData copyOf(ServerLevel level, ChunkAccess chunk) {
        ArrayList<SectionData> list;
        if (!chunk.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(chunk));
        }
        ChunkPos pos = chunk.getPos();
        ArrayList<SectionData> sectionsList = list = new ArrayList<SectionData>();
        LevelChunkSection[] sections = chunk.getSections();
        ThreadedLevelLightEngine lightEngine = level.getChunkSource().getLightEngine();
        int minLightSection = WorldUtil.getMinLightSection(level);
        int maxLightSection = WorldUtil.getMaxLightSection(level);
        int minBlockSection = WorldUtil.getMinSection(level);
        LevelChunkSection[] chunkSections = chunk.getSections();
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            LevelChunkSection chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].copy() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState saveState = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && saveState == null) continue;
            SectionData sectionData = new SectionData(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new DataLayer(blockNibble.data)), saveState == null ? null : (saveState.data == null ? null : new DataLayer(saveState.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (saveState != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(saveState.state);
            }
            sectionsList.add(sectionData);
        }
        ArrayList<CompoundTag> list1 = new ArrayList<CompoundTag>(chunk.getBlockEntitiesPos().size());
        for (BlockPos blockPos : chunk.getBlockEntitiesPos()) {
            CompoundTag blockEntityNbtForSaving = chunk.getBlockEntityNbtForSaving(blockPos, level.registryAccess());
            if (blockEntityNbtForSaving == null) continue;
            list1.add(blockEntityNbtForSaving);
        }
        ArrayList<CompoundTag> list2 = new ArrayList<CompoundTag>();
        long[] longs = null;
        if (chunk.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            list2.addAll(protoChunk.getEntities());
            CarvingMask carvingMask = protoChunk.getCarvingMask();
            if (carvingMask != null) {
                longs = carvingMask.toArray();
            }
        }
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Map.Entry entry : chunk.getHeightmaps()) {
            if (!chunk.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            long[] rawData = ((Heightmap)entry.getValue()).getRawData();
            map.put((Heightmap.Types)entry.getKey(), (long[])rawData.clone());
        }
        ChunkAccess.PackedTicks ticksForSerialization = chunk.getTicksForSerialization(level.getGameTime());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(chunk.getPostProcessing()).map(list3 -> list3 != null ? new ShortArrayList(list3) : null).toArray(ShortList[]::new);
        CompoundTag compoundTag = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel(level), pos, chunk.getAllStarts(), chunk.getAllReferences());
        CompoundTag persistentDataContainer = null;
        if (!chunk.persistentDataContainer.isEmpty()) {
            persistentDataContainer = chunk.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData((Registry<Biome>)level.registryAccess().lookupOrThrow(Registries.BIOME), pos, chunk.getMinSectionY(), level.getGameTime(), chunk.getInhabitedTime(), chunk.getPersistedStatus(), Optionull.map(chunk.getBlendingData(), BlendingData::pack), chunk.getBelowZeroRetrogen(), chunk.getUpgradeData().copy(), longs, map, ticksForSerialization, shortListArray, chunk.isLightCorrect(), list, list2, list1, compoundTag, persistentDataContainer);
    }

    public CompoundTag write() {
        CompoundTag compoundTag = NbtUtils.addCurrentDataVersion(new CompoundTag());
        compoundTag.putInt(X_POS_TAG, this.chunkPos.x);
        compoundTag.putInt("yPos", this.minSectionY);
        compoundTag.putInt(Z_POS_TAG, this.chunkPos.z);
        compoundTag.putLong("LastUpdate", this.lastUpdateTime);
        compoundTag.putLong("InhabitedTime", this.inhabitedTime);
        compoundTag.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        if (this.blendingData != null) {
            BlendingData.Packed.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.blendingData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put("blending_data", (Tag)tag));
        }
        if (this.belowZeroRetrogen != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.belowZeroRetrogen).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put("below_zero_retrogen", (Tag)tag));
        }
        if (!this.upgradeData.isEmpty()) {
            compoundTag.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        ListTag listTag = new ListTag();
        Codec<PalettedContainerRO<Holder<Biome>>> codec = SerializableChunkData.makeBiomeCodec(this.biomeRegistry);
        for (SectionData sectionData : this.sectionData) {
            CompoundTag compoundTag1;
            CompoundTag sectionNBT = compoundTag1 = new CompoundTag();
            LevelChunkSection levelChunkSection = sectionData.chunkSection;
            if (levelChunkSection != null) {
                compoundTag1.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, levelChunkSection.getStates()).getOrThrow());
                compoundTag1.put("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, levelChunkSection.getBiomes()).getOrThrow());
            }
            if (sectionData.blockLight != null) {
                compoundTag1.putByteArray(BLOCK_LIGHT_TAG, sectionData.blockLight.getData());
            }
            if (sectionData.skyLight != null) {
                compoundTag1.putByteArray(SKY_LIGHT_TAG, sectionData.skyLight.getData());
            }
            int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
            int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
            if (blockState > 0) {
                sectionNBT.putInt("starlight.blocklight_state", blockState);
            }
            if (skyState > 0) {
                sectionNBT.putInt("starlight.skylight_state", skyState);
            }
            if (compoundTag1.isEmpty()) continue;
            compoundTag1.putByte("Y", (byte)sectionData.y);
            listTag.add(compoundTag1);
        }
        compoundTag.put(SECTIONS_TAG, listTag);
        if (this.lightCorrect) {
            compoundTag.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag listTag1 = new ListTag();
        listTag1.addAll(this.blockEntities);
        compoundTag.put("block_entities", listTag1);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            ListTag listTag2 = new ListTag();
            listTag2.addAll(this.entities);
            compoundTag.put("entities", listTag2);
            if (this.carvingMask != null) {
                compoundTag.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks(compoundTag, this.packedTicks);
        compoundTag.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        CompoundTag compoundTag2 = new CompoundTag();
        this.heightmaps.forEach((types, longs) -> compoundTag2.put(types.getSerializationKey(), new LongArrayTag((long[])longs)));
        compoundTag.put(HEIGHTMAPS_TAG, compoundTag2);
        compoundTag.put("structures", this.structureData);
        if (this.persistentDataContainer != null) {
            compoundTag.put("ChunkBukkitValues", this.persistentDataContainer);
        }
        if (this.lightCorrect && !this.chunkStatus.isBefore(ChunkStatus.LIGHT)) {
            compoundTag.putBoolean(IS_LIGHT_ON_TAG, false);
            compoundTag.putInt("starlight.light_version", 9);
        }
        return compoundTag;
    }

    private static void saveTicks(CompoundTag tag, ChunkAccess.PackedTicks ticks) {
        ListTag listTag = new ListTag();
        for (SavedTick<Block> savedTick : ticks.blocks()) {
            listTag.add(savedTick.save(block -> BuiltInRegistries.BLOCK.getKey((Block)block).toString()));
        }
        tag.put(BLOCK_TICKS_TAG, listTag);
        ListTag listTag1 = new ListTag();
        for (SavedTick<Fluid> savedTick1 : ticks.fluids()) {
            listTag1.add(savedTick1.save(fluid -> BuiltInRegistries.FLUID.getKey((Fluid)fluid).toString()));
        }
        tag.put(FLUID_TICKS_TAG, listTag1);
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag tag) {
        return tag != null ? ChunkStatus.byName(tag.getString("Status")).getChunkType() : ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel level, List<CompoundTag> entities, List<CompoundTag> blockEntities) {
        return entities.isEmpty() && blockEntities.isEmpty() ? null : chunk -> {
            if (!entities.isEmpty()) {
                level.addLegacyChunkEntities(EntityType.loadEntitiesRecursive(entities, level, EntitySpawnReason.LOAD));
            }
            for (CompoundTag compoundTag : blockEntities) {
                boolean _boolean = compoundTag.getBoolean("keepPacked");
                if (_boolean) {
                    chunk.setBlockEntityNbt(compoundTag);
                    continue;
                }
                BlockPos posFromTag = BlockEntity.getPosFromTag(compoundTag);
                ChunkPos chunkPos = chunk.getPos();
                if (posFromTag.getX() >> 4 != chunkPos.x || posFromTag.getZ() >> 4 != chunkPos.z) {
                    LOGGER.warn("Tile entity serialized in chunk " + String.valueOf(chunkPos) + " in world '" + level.getWorld().getName() + "' positioned at " + String.valueOf(posFromTag) + " is located outside of the chunk");
                    continue;
                }
                BlockEntity blockEntity = BlockEntity.loadStatic(posFromTag, chunk.getBlockState(posFromTag), compoundTag, level.registryAccess());
                if (blockEntity == null) continue;
                chunk.setBlockEntity(blockEntity);
            }
        };
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext context, ChunkPos pos, Map<Structure, StructureStart> structureStarts, Map<Structure, LongSet> references) {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag compoundTag1 = new CompoundTag();
        HolderLookup.RegistryLookup registry = context.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> entry : structureStarts.entrySet()) {
            ResourceLocation key = registry.getKey(entry.getKey());
            compoundTag1.put(key.toString(), entry.getValue().createTag(context, pos));
        }
        compoundTag.put("starts", compoundTag1);
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> entry1 : references.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            ResourceLocation key1 = registry.getKey(entry1.getKey());
            compoundTag2.put(key1.toString(), new LongArrayTag(entry1.getValue()));
        }
        compoundTag.put("References", compoundTag2);
        return compoundTag;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext context, CompoundTag tag, long seed) {
        HashMap map = Maps.newHashMap();
        HolderLookup.RegistryLookup registry = context.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        CompoundTag compound = tag.getCompound("starts");
        for (String string : compound.getAllKeys()) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse(string);
            Structure structure = (Structure)registry.getValue(resourceLocation);
            if (structure == null) {
                LOGGER.error("Unknown structure start: {}", (Object)resourceLocation);
                continue;
            }
            StructureStart structureStart = StructureStart.loadStaticStart(context, compound.getCompound(string), seed);
            if (structureStart == null) continue;
            Tag persistentBase = compound.getCompound(string).get("StructureBukkitValues");
            if (persistentBase instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)persistentBase;
                structureStart.persistentDataContainer.putAll(compoundTag);
            }
            map.put(structure, structureStart);
        }
        return map;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess registries, ChunkPos pos, CompoundTag tag) {
        HashMap map = Maps.newHashMap();
        HolderLookup.RegistryLookup registry = registries.lookupOrThrow(Registries.STRUCTURE);
        CompoundTag compound = tag.getCompound("References");
        for (String string : compound.getAllKeys()) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse(string);
            Structure structure = (Structure)registry.getValue(resourceLocation);
            if (structure == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourceLocation, (Object)pos);
                continue;
            }
            long[] longArray = compound.getLongArray(string);
            if (longArray.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(longArray).filter(l -> {
                ChunkPos chunkPos = new ChunkPos(l);
                if (chunkPos.getChessboardDistance(pos) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourceLocation, chunkPos, pos});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    private static ListTag packOffsets(ShortList[] offsets) {
        ListTag listTag = new ListTag();
        for (ShortList list : offsets) {
            ListTag listTag1 = new ListTag();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    listTag1.add(ShortTag.valueOf(list.getShort(i)));
                }
            }
            listTag.add(listTag1);
        }
        return listTag;
    }

    public static final class SectionData
    implements StarlightSectionData {
        private final int y;
        @Nullable
        private final LevelChunkSection chunkSection;
        @Nullable
        private final DataLayer blockLight;
        @Nullable
        private final DataLayer skyLight;
        private int blockLightState = -1;
        private int skyLightState = -1;

        @Override
        public final int starlight$getBlockLightState() {
            return this.blockLightState;
        }

        @Override
        public final void starlight$setBlockLightState(int state) {
            this.blockLightState = state;
        }

        @Override
        public final int starlight$getSkyLightState() {
            return this.skyLightState;
        }

        @Override
        public final void starlight$setSkyLightState(int state) {
            this.skyLightState = state;
        }

        public SectionData(int y, @Nullable LevelChunkSection chunkSection, @Nullable DataLayer blockLight, @Nullable DataLayer skyLight) {
            this.y = y;
            this.chunkSection = chunkSection;
            this.blockLight = blockLight;
            this.skyLight = skyLight;
        }

        public int y() {
            return this.y;
        }

        @Nullable
        public LevelChunkSection chunkSection() {
            return this.chunkSection;
        }

        @Nullable
        public DataLayer blockLight() {
            return this.blockLight;
        }

        @Nullable
        public DataLayer skyLight() {
            return this.skyLight;
        }
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String message) {
            super(message);
        }
    }
}

