/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.block.DragonEggFormEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.boss.CraftDragonBattle;
import org.slf4j.Logger;

public class EndDragonFight {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_DRAGON_RESPAWN = 1200;
    private static final int TIME_BETWEEN_CRYSTAL_SCANS = 100;
    public static final int TIME_BETWEEN_PLAYER_SCANS = 20;
    private static final int ARENA_SIZE_CHUNKS = 8;
    public static final int ARENA_TICKET_LEVEL = 9;
    public static final int GATEWAY_COUNT = 20;
    private static final int GATEWAY_DISTANCE = 96;
    public static final int DRAGON_SPAWN_Y = 128;
    private final Predicate<Entity> validPlayer;
    private static final Component DEFAULT_BOSS_EVENT_NAME = Component.translatable("entity.minecraft.ender_dragon");
    public final ServerBossEvent dragonEvent = (ServerBossEvent)new ServerBossEvent(DEFAULT_BOSS_EVENT_NAME, BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).setPlayBossMusic(true).setCreateWorldFog(true);
    public final ServerLevel level;
    private final BlockPos origin;
    public final ObjectArrayList<Integer> gateways = new ObjectArrayList();
    private final BlockPattern exitPortalPattern;
    private int ticksSinceDragonSeen;
    private int crystalsAlive;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan = 21;
    private boolean dragonKilled;
    public boolean previouslyKilled;
    private boolean skipArenaLoadedCheck = false;
    @Nullable
    public UUID dragonUUID;
    private boolean needsStateScanning = true;
    @Nullable
    public BlockPos portalLocation;
    @Nullable
    public DragonRespawnAnimation respawnStage;
    private int respawnTime;
    @Nullable
    public List<EndCrystal> respawnCrystals;

    public EndDragonFight(ServerLevel level, long seed, Data data) {
        this(level, seed, data, BlockPos.ZERO);
    }

    public EndDragonFight(ServerLevel level, long seed, Data data, BlockPos origin) {
        this.level = level;
        this.origin = origin;
        this.validPlayer = EntitySelector.ENTITY_STILL_ALIVE.and(EntitySelector.withinDistance(origin.getX(), 128 + origin.getY(), origin.getZ(), 192.0));
        this.needsStateScanning = data.needsStateScanning;
        this.dragonUUID = data.dragonUUID.orElse(null);
        this.dragonKilled = data.dragonKilled;
        this.previouslyKilled = data.previouslyKilled;
        if (data.isRespawning) {
            this.respawnStage = DragonRespawnAnimation.START;
        }
        if (data == Data.DEFAULT && !level.paperConfig().entities.spawning.scanForLegacyEnderDragon) {
            this.needsStateScanning = false;
            this.dragonKilled = true;
        }
        this.portalLocation = data.exitPortalLocation.orElse(null);
        this.gateways.addAll((Collection)data.gateways.orElseGet(() -> {
            ObjectArrayList list = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Util.shuffle(list, RandomSource.create(seed));
            return list;
        }));
        this.exitPortalPattern = BlockPatternBuilder.start().aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").aisle("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").where('#', BlockInWorld.hasState(BlockPredicate.forBlock(Blocks.BEDROCK))).build();
    }

    @Deprecated
    @VisibleForTesting
    public void skipArenaLoadedCheck() {
        this.skipArenaLoadedCheck = true;
    }

    public Data saveData() {
        return new Data(this.needsStateScanning, this.dragonKilled, this.previouslyKilled, false, Optional.ofNullable(this.dragonUUID), Optional.ofNullable(this.portalLocation), Optional.of(this.gateways));
    }

    public void tick() {
        this.dragonEvent.setVisible(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.dragonEvent.getPlayers().isEmpty()) {
            this.level.getChunkSource().addRegionTicket(TicketType.DRAGON, new ChunkPos(0, 0), 9, Unit.INSTANCE);
            boolean isArenaLoaded = this.isArenaLoaded();
            if (this.needsStateScanning && isArenaLoaded) {
                this.scanState();
                this.needsStateScanning = false;
            }
            if (this.respawnStage != null) {
                if (this.respawnCrystals == null && isArenaLoaded) {
                    this.respawnStage = null;
                    this.tryRespawn();
                }
                this.respawnStage.tick(this.level, this, this.respawnCrystals, this.respawnTime++, this.portalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUUID == null || ++this.ticksSinceDragonSeen >= 1200) && isArenaLoaded) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && isArenaLoaded) {
                    this.updateCrystalCount();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.level.getChunkSource().removeRegionTicket(TicketType.DRAGON, new ChunkPos(0, 0), 9, Unit.INSTANCE);
        }
    }

    private void scanState() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean hasActiveExitPortal = this.hasActiveExitPortal();
        if (hasActiveExitPortal) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.spawnExitPortal(false);
            }
        }
        List<? extends EnderDragon> dragons = this.level.getDragons();
        if (dragons.isEmpty()) {
            this.dragonKilled = true;
        } else {
            EnderDragon enderDragon = dragons.get(0);
            this.dragonUUID = enderDragon.getUUID();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)enderDragon);
            this.dragonKilled = false;
            if (!hasActiveExitPortal && this.level.paperConfig().entities.behavior.shouldRemoveDragon) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                enderDragon.discard(null);
                this.dragonUUID = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List<? extends EnderDragon> dragons = this.level.getDragons();
        if (dragons.isEmpty()) {
            LOGGER.debug("Haven't seen the dragon, respawning it");
            this.createNewDragon();
        } else {
            LOGGER.debug("Haven't seen our dragon, but found another one to use.");
            this.dragonUUID = dragons.get(0).getUUID();
        }
    }

    public void setRespawnStage(DragonRespawnAnimation state) {
        if (this.respawnStage == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnTime = 0;
        if (state == DragonRespawnAnimation.END) {
            this.respawnStage = null;
            this.dragonKilled = false;
            EnderDragon enderDragon = this.createNewDragon();
            if (enderDragon != null) {
                for (ServerPlayer serverPlayer : this.dragonEvent.getPlayers()) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, enderDragon);
                }
            }
        } else {
            this.respawnStage = state;
        }
    }

    private boolean hasActiveExitPortal() {
        for (int i = -8; i <= 8; ++i) {
            for (int i1 = -8; i1 <= 8; ++i1) {
                LevelChunk chunk = this.level.getChunk(i, i1);
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    if (!(blockEntity instanceof TheEndPortalBlockEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public BlockPattern.BlockPatternMatch findExitPortal() {
        int i1;
        ChunkPos chunkPos = new ChunkPos(this.origin);
        for (int i = -8 + chunkPos.x; i <= 8 + chunkPos.x; ++i) {
            for (i1 = -8 + chunkPos.z; i1 <= 8 + chunkPos.z; ++i1) {
                LevelChunk chunk = this.level.getChunk(i, i1);
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    BlockPattern.BlockPatternMatch blockPatternMatch;
                    if (!(blockEntity instanceof TheEndPortalBlockEntity) || (blockPatternMatch = this.exitPortalPattern.find(this.level, blockEntity.getBlockPos())) == null) continue;
                    BlockPos pos = blockPatternMatch.getBlock(3, 3, 3).getPos();
                    if (this.portalLocation == null) {
                        this.portalLocation = pos;
                    }
                    return blockPatternMatch;
                }
            }
        }
        BlockPos location = EndPodiumFeature.getLocation(this.origin);
        for (int i2 = i1 = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, location).getY(); i2 >= this.level.getMinY(); --i2) {
            BlockPattern.BlockPatternMatch blockPatternMatch1 = this.exitPortalPattern.find(this.level, new BlockPos(location.getX(), i2, location.getZ()));
            if (blockPatternMatch1 == null) continue;
            if (this.portalLocation == null) {
                this.portalLocation = blockPatternMatch1.getBlock(3, 3, 3).getPos();
            }
            return blockPatternMatch1;
        }
        return null;
    }

    private boolean isArenaLoaded() {
        if (this.skipArenaLoadedCheck) {
            return true;
        }
        ChunkPos chunkPos = new ChunkPos(this.origin);
        for (int i = -8 + chunkPos.x; i <= 8 + chunkPos.x; ++i) {
            for (int i1 = 8 + chunkPos.z; i1 <= 8 + chunkPos.z; ++i1) {
                ChunkAccess chunk = this.level.getChunk(i, i1, ChunkStatus.FULL, false);
                if (!(chunk instanceof LevelChunk)) {
                    return false;
                }
                FullChunkStatus fullStatus = ((LevelChunk)chunk).getFullStatus();
                if (fullStatus.isOrAfter(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayer serverPlayer : this.level.getPlayers(this.validPlayer)) {
            this.dragonEvent.addPlayer(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set1 = Sets.newHashSet(this.dragonEvent.getPlayers());
        set1.removeAll(set);
        for (ServerPlayer serverPlayer1 : set1) {
            this.dragonEvent.removePlayer(serverPlayer1);
        }
    }

    private void updateCrystalCount() {
        this.ticksSinceCrystalsScanned = 0;
        this.crystalsAlive = 0;
        for (SpikeFeature.EndSpike endSpike : SpikeFeature.getSpikesForLevel(this.level)) {
            this.crystalsAlive += this.level.getEntitiesOfClass(EndCrystal.class, endSpike.getTopBoundingBox()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.crystalsAlive);
    }

    public void setDragonKilled(EnderDragon dragon) {
        if (dragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.spawnExitPortal(true);
            this.spawnNewGateway();
            BlockPos eggPosition = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.getLocation(this.origin));
            CraftBlockState eggState = CraftBlockStates.getBlockState(this.level, eggPosition);
            eggState.setData(Blocks.DRAGON_EGG.defaultBlockState());
            DragonEggFormEvent eggEvent = new DragonEggFormEvent((Block)CraftBlock.at(this.level, eggPosition), (BlockState)eggState, (DragonBattle)new CraftDragonBattle(this));
            if (!this.level.paperConfig().entities.behavior.enderDragonsDeathAlwaysPlacesDragonEgg && this.previouslyKilled) {
                eggEvent.setCancelled(true);
            }
            if (eggEvent.callEvent()) {
                eggEvent.getNewState().update(true);
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void removeAllGateways() {
        this.gateways.clear();
    }

    public boolean spawnNewGatewayIfPossible() {
        if (!this.gateways.isEmpty()) {
            this.spawnNewGateway();
            return true;
        }
        return false;
    }

    public List<EndCrystal> getSpikeCrystals() {
        ArrayList<EndCrystal> endCrystals = new ArrayList<EndCrystal>();
        for (SpikeFeature.EndSpike spike : SpikeFeature.getSpikesForLevel(this.level)) {
            endCrystals.addAll(this.level.getEntitiesOfClass(EndCrystal.class, spike.getTopBoundingBox()));
        }
        return endCrystals;
    }

    private void spawnNewGateway() {
        if (!this.gateways.isEmpty()) {
            int i = (Integer)this.gateways.remove(this.gateways.size() - 1);
            int floor = Mth.floor(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            int floor1 = Mth.floor(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            this.spawnNewGateway(new BlockPos(floor, 75, floor1));
        }
    }

    public void spawnNewGateway(BlockPos pos) {
        this.level.levelEvent(3000, pos, 0);
        this.level.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.get(EndFeatures.END_GATEWAY_DELAYED)).ifPresent(endGatewayFeature -> ((ConfiguredFeature)endGatewayFeature.value()).place(this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), pos));
    }

    public void spawnExitPortal(boolean active) {
        EndPodiumFeature endPodiumFeature = new EndPodiumFeature(active);
        if (this.portalLocation == null) {
            this.portalLocation = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.origin)).below();
            while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > 63) {
                this.portalLocation = this.portalLocation.below();
            }
        }
        if (this.portalLocation.getY() <= this.level.getMinY()) {
            this.portalLocation = this.portalLocation.atY(this.level.getMinY() + 1);
        }
        if (endPodiumFeature.place(FeatureConfiguration.NONE, this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), this.portalLocation)) {
            int i = Mth.positiveCeilDiv(4, 16);
            this.level.getChunkSource().chunkMap.waitForLightBeforeSending(new ChunkPos(this.portalLocation), i);
        }
    }

    @Nullable
    private EnderDragon createNewDragon() {
        this.level.getChunkAt(new BlockPos(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ()));
        EnderDragon enderDragon = EntityType.ENDER_DRAGON.create(this.level, EntitySpawnReason.EVENT);
        if (enderDragon != null) {
            enderDragon.setDragonFight(this);
            enderDragon.setFightOrigin(this.origin);
            enderDragon.getPhaseManager().setPhase(EnderDragonPhase.HOLDING_PATTERN);
            enderDragon.moveTo(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
            this.level.addFreshEntity(enderDragon);
            this.dragonUUID = enderDragon.getUUID();
            this.resetSpikeCrystals();
        }
        return enderDragon;
    }

    public void updateDragon(EnderDragon dragon) {
        if (dragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(dragon.getHealth() / dragon.getMaxHealth());
            this.ticksSinceDragonSeen = 0;
            if (dragon.hasCustomName()) {
                this.dragonEvent.setName(dragon.getDisplayName());
            } else {
                this.dragonEvent.setName(DEFAULT_BOSS_EVENT_NAME);
            }
        }
    }

    public int getCrystalsAlive() {
        return this.crystalsAlive;
    }

    public void onCrystalDestroyed(EndCrystal crystal, DamageSource dmgSrc) {
        if (this.respawnStage != null && this.respawnCrystals.contains(crystal)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnStage = null;
            this.respawnTime = 0;
            this.resetSpikeCrystals();
            this.spawnExitPortal(true);
        } else {
            this.updateCrystalCount();
            Entity entity = this.level.getEntity(this.dragonUUID);
            if (entity instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)entity;
                enderDragon.onCrystalDestroyed(this.level, crystal, crystal.blockPosition(), dmgSrc);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public boolean tryRespawn() {
        return this.tryRespawn(null);
    }

    public boolean tryRespawn(@Nullable BlockPos placedEndCrystalPos) {
        if (this.dragonKilled && this.respawnStage == null) {
            BlockPos blockPos = this.portalLocation;
            if (blockPos == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.BlockPatternMatch blockPatternMatch = this.findExitPortal();
                if (blockPatternMatch == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.spawnExitPortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & saved its location for next time.");
                }
                blockPos = this.portalLocation;
            }
            if (placedEndCrystalPos != null) {
                int dy = placedEndCrystalPos.getY() - blockPos.getY();
                if (dy != 0 && dy != 1) {
                    return false;
                }
                int dx = placedEndCrystalPos.getX() - blockPos.getX();
                int dz = placedEndCrystalPos.getZ() - blockPos.getZ();
                if (!(dx >= -1 && dx <= 1 && dz >= -3 && dz <= 3 || dx >= -3 && dx <= 3 && dz >= -1 && dz <= 1)) {
                    return false;
                }
            }
            ArrayList list = Lists.newArrayList();
            BlockPos blockPos1 = blockPos.above(1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List<EndCrystal> entitiesOfClass = this.level.getEntitiesOfClass(EndCrystal.class, new AABB(blockPos1.relative(direction, 2)));
                if (entitiesOfClass.isEmpty()) {
                    return false;
                }
                list.addAll(entitiesOfClass);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            return this.respawnDragon(list);
        }
        return false;
    }

    public boolean respawnDragon(List<EndCrystal> crystals) {
        if (this.dragonKilled && this.respawnStage == null) {
            BlockPattern.BlockPatternMatch blockPatternMatch = this.findExitPortal();
            while (blockPatternMatch != null) {
                for (int i = 0; i < this.exitPortalPattern.getWidth(); ++i) {
                    for (int i1 = 0; i1 < this.exitPortalPattern.getHeight(); ++i1) {
                        for (int i2 = 0; i2 < this.exitPortalPattern.getDepth(); ++i2) {
                            BlockInWorld block = blockPatternMatch.getBlock(i, i1, i2);
                            if (!block.getState().is(Blocks.BEDROCK) && !block.getState().is(Blocks.END_PORTAL)) continue;
                            this.level.setBlockAndUpdate(block.getPos(), Blocks.END_STONE.defaultBlockState());
                        }
                    }
                }
                blockPatternMatch = this.findExitPortal();
            }
            this.respawnStage = DragonRespawnAnimation.START;
            this.respawnTime = 0;
            this.spawnExitPortal(false);
            this.respawnCrystals = crystals;
            return true;
        }
        return false;
    }

    public void resetSpikeCrystals() {
        for (SpikeFeature.EndSpike endSpike : SpikeFeature.getSpikesForLevel(this.level)) {
            for (EndCrystal endCrystal : this.level.getEntitiesOfClass(EndCrystal.class, endSpike.getTopBoundingBox())) {
                endCrystal.setInvulnerable(false);
                endCrystal.setBeamTarget(null);
            }
        }
    }

    @Nullable
    public UUID getDragonUUID() {
        return this.dragonUUID;
    }

    public record Data(boolean needsStateScanning, boolean dragonKilled, boolean previouslyKilled, boolean isRespawning, Optional<UUID> dragonUUID, Optional<BlockPos> exitPortalLocation, Optional<List<Integer>> gateways) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(Data::needsStateScanning), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(Data::dragonKilled), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(Data::previouslyKilled), (App)Codec.BOOL.lenientOptionalFieldOf("IsRespawning", (Object)false).forGetter(Data::isRespawning), (App)UUIDUtil.CODEC.lenientOptionalFieldOf("Dragon").forGetter(Data::dragonUUID), (App)BlockPos.CODEC.lenientOptionalFieldOf("ExitPortalLocation").forGetter(Data::exitPortalLocation), (App)Codec.list((Codec)Codec.INT).lenientOptionalFieldOf("Gateways").forGetter(Data::gateways)).apply((Applicative)instance, Data::new));
        public static final Data DEFAULT = new Data(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());
    }
}

