/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PatrolSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        int patrolSpawnDelay;
        if (level.paperConfig().entities.behavior.pillagerPatrols.disable || level.paperConfig().entities.behavior.pillagerPatrols.spawnChance == 0.0) {
            return 0;
        }
        if (!spawnEnemies) {
            return 0;
        }
        if (!level.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING)) {
            return 0;
        }
        RandomSource randomSource = level.random;
        int size = level.players().size();
        if (size < 1) {
            return 0;
        }
        ServerPlayer player = level.players().get(randomSource.nextInt(size));
        if (player.isSpectator()) {
            return 0;
        }
        if (level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.perPlayer) {
            --player.patrolSpawnDelay;
            patrolSpawnDelay = player.patrolSpawnDelay;
        } else {
            --this.nextTick;
            patrolSpawnDelay = this.nextTick;
        }
        if (patrolSpawnDelay > 0) {
            return 0;
        }
        long days = level.paperConfig().entities.behavior.pillagerPatrols.start.perPlayer ? (long)player.getStats().getValue(Stats.CUSTOM.get(Stats.PLAY_TIME)) / 24000L : level.getDayTime() / 24000L;
        if (level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.perPlayer) {
            player.patrolSpawnDelay += level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.ticks + randomSource.nextInt(1200);
        } else {
            this.nextTick += level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.ticks + randomSource.nextInt(1200);
        }
        if (days < (long)level.paperConfig().entities.behavior.pillagerPatrols.start.day || !level.isDay()) {
            return 0;
        }
        if (randomSource.nextDouble() >= level.paperConfig().entities.behavior.pillagerPatrols.spawnChance) {
            return 0;
        }
        if (size < 1) {
            return 0;
        }
        if (player.isSpectator()) {
            return 0;
        }
        if (level.isCloseToVillage(player.blockPosition(), 2)) {
            return 0;
        }
        int i = (24 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        int i1 = (24 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        BlockPos.MutableBlockPos mutableBlockPos = player.blockPosition().mutable().move(i, 0, i1);
        int i2 = 10;
        if (!level.hasChunksAt(mutableBlockPos.getX() - 10, mutableBlockPos.getZ() - 10, mutableBlockPos.getX() + 10, mutableBlockPos.getZ() + 10)) {
            return 0;
        }
        Holder<Biome> biome = level.getBiome(mutableBlockPos);
        if (biome.is(BiomeTags.WITHOUT_PATROL_SPAWNS)) {
            return 0;
        }
        int i3 = 0;
        int i4 = (int)Math.ceil(level.getCurrentDifficultyAt(mutableBlockPos).getEffectiveDifficulty()) + 1;
        for (int i5 = 0; i5 < i4; ++i5) {
            ++i3;
            mutableBlockPos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, mutableBlockPos).getY());
            if (i5 == 0) {
                if (!this.spawnPatrolMember(level, mutableBlockPos, randomSource, true)) {
                    break;
                }
            } else {
                this.spawnPatrolMember(level, mutableBlockPos, randomSource, false);
            }
            mutableBlockPos.setX(mutableBlockPos.getX() + randomSource.nextInt(5) - randomSource.nextInt(5));
            mutableBlockPos.setZ(mutableBlockPos.getZ() + randomSource.nextInt(5) - randomSource.nextInt(5));
        }
        return i3;
    }

    private boolean spawnPatrolMember(ServerLevel level, BlockPos pos, RandomSource random, boolean leader) {
        BlockState blockState = level.getBlockState(pos);
        if (!NaturalSpawner.isValidEmptySpawnBlock(level, pos, blockState, blockState.getFluidState(), EntityType.PILLAGER)) {
            return false;
        }
        if (!PatrollingMonster.checkPatrollingMonsterSpawnRules(EntityType.PILLAGER, level, EntitySpawnReason.PATROL, pos, random)) {
            return false;
        }
        PatrollingMonster patrollingMonster = EntityType.PILLAGER.create(level, EntitySpawnReason.PATROL);
        if (patrollingMonster != null) {
            if (leader) {
                patrollingMonster.setPatrolLeader(true);
                patrollingMonster.findPatrolTarget();
            }
            patrollingMonster.setPos(pos.getX(), pos.getY(), pos.getZ());
            patrollingMonster.finalizeSpawn(level, level.getCurrentDifficultyAt(pos), EntitySpawnReason.PATROL, null);
            level.addFreshEntityWithPassengers(patrollingMonster, CreatureSpawnEvent.SpawnReason.PATROL);
            return true;
        }
        return false;
    }
}

