/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.destroystokyo.paper.event.entity.PhantomPreSpawnEvent;
import io.papermc.paper.util.MCUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PhantomSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnEnemies) {
            return 0;
        }
        if (!level.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return 0;
        }
        if (level.paperConfig().entities.behavior.phantomsSpawnAttemptMaxSeconds <= 0) {
            return 0;
        }
        RandomSource randomSource = level.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        int spawnAttemptMinSeconds = level.paperConfig().entities.behavior.phantomsSpawnAttemptMinSeconds;
        int spawnAttemptMaxSeconds = level.paperConfig().entities.behavior.phantomsSpawnAttemptMaxSeconds;
        this.nextTick += (spawnAttemptMinSeconds + randomSource.nextInt(spawnAttemptMaxSeconds - spawnAttemptMinSeconds + 1)) * 20;
        if (level.getSkyDarken() < 5 && level.dimensionType().hasSkyLight()) {
            return 0;
        }
        int i = 0;
        block0: for (ServerPlayer serverPlayer : level.players()) {
            FluidState fluidState;
            BlockState blockState;
            BlockPos blockPos1;
            DifficultyInstance currentDifficultyAt;
            if (serverPlayer.isSpectator() || level.paperConfig().entities.behavior.phantomsDoNotSpawnOnCreativePlayers && serverPlayer.isCreative()) continue;
            BlockPos blockPos = serverPlayer.blockPosition();
            if (level.dimensionType().hasSkyLight() && (blockPos.getY() < level.getSeaLevel() || !level.canSeeSky(blockPos)) || !(currentDifficultyAt = level.getCurrentDifficultyAt(blockPos)).isHarderThan(randomSource.nextFloat() * 3.0f)) continue;
            ServerStatsCounter stats = serverPlayer.getStats();
            int i1 = Mth.clamp(stats.getValue(Stats.CUSTOM.get(Stats.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            int i2 = 24000;
            if (randomSource.nextInt(i1) < level.paperConfig().entities.behavior.playerInsomniaStartTicks || !NaturalSpawner.isValidEmptySpawnBlock(level, blockPos1 = blockPos.above(20 + randomSource.nextInt(15)).east(-10 + randomSource.nextInt(21)).south(-10 + randomSource.nextInt(21)), blockState = level.getBlockState(blockPos1), fluidState = level.getFluidState(blockPos1), EntityType.PHANTOM)) continue;
            SpawnGroupData spawnGroupData = null;
            int i3 = 1 + randomSource.nextInt(currentDifficultyAt.getDifficulty().getId() + 1);
            for (int i4 = 0; i4 < i3; ++i4) {
                PhantomPreSpawnEvent event = new PhantomPreSpawnEvent(MCUtil.toLocation(level, blockPos1), (Entity)serverPlayer.getBukkitEntity(), CreatureSpawnEvent.SpawnReason.NATURAL);
                if (!event.callEvent()) {
                    if (!event.shouldAbortSpawn()) continue;
                    continue block0;
                }
                Phantom phantom = EntityType.PHANTOM.create(level, EntitySpawnReason.NATURAL);
                if (phantom == null) continue;
                phantom.spawningEntity = serverPlayer.getUUID();
                phantom.moveTo(blockPos1, 0.0f, 0.0f);
                spawnGroupData = phantom.finalizeSpawn(level, currentDifficultyAt, EntitySpawnReason.NATURAL, spawnGroupData);
                level.addFreshEntityWithPassengers(phantom, CreatureSpawnEvent.SpawnReason.NATURAL);
                ++i;
            }
        }
        return i;
    }
}

