/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class EndPlatformFeature
extends Feature<NoneFeatureConfiguration> {
    public EndPlatformFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        EndPlatformFeature.createEndPlatform(context.level(), context.origin(), false);
        return true;
    }

    public static void createEndPlatform(ServerLevelAccessor level, BlockPos pos, boolean dropBlocks) {
        EndPlatformFeature.createEndPlatform(level, pos, dropBlocks, null);
    }

    public static void createEndPlatform(ServerLevelAccessor level, BlockPos pos, boolean dropBlocks, net.minecraft.world.entity.Entity entity) {
        BlockStateListPopulator blockList = new BlockStateListPopulator(level);
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = -2; i <= 2; ++i) {
            for (int i1 = -2; i1 <= 2; ++i1) {
                for (int i2 = -1; i2 < 3; ++i2) {
                    Block block;
                    BlockPos.MutableBlockPos blockPos = mutableBlockPos.set(pos).move(i1, i2, i);
                    Block block2 = block = i2 == -1 ? Blocks.OBSIDIAN : Blocks.AIR;
                    if (blockList.getBlockState(blockPos).is(block)) continue;
                    if (dropBlocks) {
                        blockList.destroyBlock(blockPos, true, null);
                    }
                    blockList.setBlock(blockPos, block.defaultBlockState(), 3);
                }
            }
        }
        if (entity != null) {
            CraftWorld bworld = level.getLevel().getWorld();
            PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)entity.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
            level.getLevel().getCraftServer().getPluginManager().callEvent((Event)portalEvent);
            if (portalEvent.isCancelled()) {
                return;
            }
        }
        if (dropBlocks) {
            blockList.getList().forEach(state -> level.destroyBlock(state.getPosition(), true, null));
        }
        blockList.updateList();
    }
}

