/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AlterGroundDecorator
extends TreeDecorator {
    public static final MapCodec<AlterGroundDecorator> CODEC = BlockStateProvider.CODEC.fieldOf("provider").xmap(AlterGroundDecorator::new, decorator -> decorator.provider);
    private final BlockStateProvider provider;

    public AlterGroundDecorator(BlockStateProvider provider) {
        this.provider = provider;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ALTER_GROUND;
    }

    @Override
    public void place(TreeDecorator.Context context) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList<BlockPos> list1 = context.roots();
        ObjectArrayList<BlockPos> list2 = context.logs();
        if (list1.isEmpty()) {
            list.addAll(list2);
        } else if (!list2.isEmpty() && ((BlockPos)list1.get(0)).getY() == ((BlockPos)list2.get(0)).getY()) {
            list.addAll(list2);
            list.addAll(list1);
        } else {
            list.addAll(list1);
        }
        if (!list.isEmpty()) {
            int y = ((BlockPos)list.get(0)).getY();
            list.stream().filter(pos -> pos.getY() == y).forEach(blockPos -> {
                this.placeCircle(context, blockPos.west().north());
                this.placeCircle(context, blockPos.east(2).north());
                this.placeCircle(context, blockPos.west().south(2));
                this.placeCircle(context, blockPos.east(2).south(2));
                for (int i = 0; i < 5; ++i) {
                    int randomInt = context.random().nextInt(64);
                    int i1 = randomInt % 8;
                    int i2 = randomInt / 8;
                    if (i1 != 0 && i1 != 7 && i2 != 0 && i2 != 7) continue;
                    this.placeCircle(context, blockPos.offset(-3 + i1, 0, -3 + i2));
                }
            });
        }
    }

    private void placeCircle(TreeDecorator.Context context, BlockPos pos) {
        for (int i = -2; i <= 2; ++i) {
            for (int i1 = -2; i1 <= 2; ++i1) {
                if (Math.abs(i) == 2 && Math.abs(i1) == 2) continue;
                this.placeBlockAt(context, pos.offset(i, 0, i1));
            }
        }
    }

    private void placeBlockAt(TreeDecorator.Context context, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockPos = pos.above(i);
            if (Feature.isGrassOrDirt(context.level(), blockPos)) {
                context.setBlock(blockPos, this.provider.getState(context.random(), pos));
                break;
            }
            if (!context.isAir(blockPos) && i < 0) break;
        }
    }
}

