/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CocoaDecorator
extends TreeDecorator {
    public static final MapCodec<CocoaDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CocoaDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public CocoaDecorator(float probability) {
        this.probability = probability;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.COCOA;
    }

    @Override
    public void place(TreeDecorator.Context context) {
        ObjectArrayList<BlockPos> list;
        if (context.logs().isEmpty()) {
            return;
        }
        RandomSource randomSource = context.random();
        if (!(randomSource.nextFloat() >= this.probability) && !(list = context.logs()).isEmpty()) {
            int y = ((BlockPos)list.getFirst()).getY();
            list.stream().filter(pos -> pos.getY() - y <= 2).forEach(blockPos -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction opposite;
                    BlockPos blockPos1;
                    if (!(randomSource.nextFloat() <= 0.25f) || !context.isAir(blockPos1 = blockPos.offset((opposite = direction.getOpposite()).getStepX(), 0, opposite.getStepZ()))) continue;
                    context.setBlock(blockPos1, (BlockState)((BlockState)Blocks.COCOA.defaultBlockState().setValue(CocoaBlock.AGE, randomSource.nextInt(3))).setValue(HorizontalDirectionalBlock.FACING, direction));
                }
            });
        }
    }
}

