/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CreakingHeartDecorator
extends TreeDecorator {
    public static final MapCodec<CreakingHeartDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CreakingHeartDecorator::new, creakingHeartDecorator -> Float.valueOf(creakingHeartDecorator.probability));
    private final float probability;

    public CreakingHeartDecorator(float probability) {
        this.probability = probability;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.CREAKING_HEART;
    }

    @Override
    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        ObjectArrayList<BlockPos> list = context.logs();
        if (!list.isEmpty() && !(randomSource.nextFloat() >= this.probability)) {
            ArrayList<BlockPos> list1 = new ArrayList<BlockPos>((Collection<BlockPos>)list);
            Util.shuffle(list1, randomSource);
            Optional<BlockPos> optional = list1.stream().filter(pos -> {
                for (Direction direction : Direction.values()) {
                    if (context.checkBlock(pos.relative(direction), blockState -> blockState.is(BlockTags.LOGS))) continue;
                    return false;
                }
                return true;
            }).findFirst();
            if (!optional.isEmpty()) {
                context.setBlock(optional.get(), (BlockState)((BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.ACTIVE, true)).setValue(CreakingHeartBlock.NATURAL, true));
            }
        }
    }
}

