/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class StructureFeatureIndexSavedData
extends SavedData {
    private static final String TAG_REMAINING_INDEXES = "Remaining";
    private static final String TAG_All_INDEXES = "All";
    private final LongSet all;
    private final LongSet remaining;

    public static SavedData.Factory<StructureFeatureIndexSavedData> factory() {
        return new SavedData.Factory<StructureFeatureIndexSavedData>(StructureFeatureIndexSavedData::new, StructureFeatureIndexSavedData::load, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES);
    }

    private StructureFeatureIndexSavedData(LongSet all, LongSet remaining) {
        this.all = all;
        this.remaining = remaining;
    }

    public StructureFeatureIndexSavedData() {
        this((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
    }

    public static StructureFeatureIndexSavedData load(CompoundTag tag, HolderLookup.Provider registries) {
        return new StructureFeatureIndexSavedData((LongSet)new LongOpenHashSet(tag.getLongArray(TAG_All_INDEXES)), (LongSet)new LongOpenHashSet(tag.getLongArray(TAG_REMAINING_INDEXES)));
    }

    @Override
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLongArray(TAG_All_INDEXES, this.all.toLongArray());
        tag.putLongArray(TAG_REMAINING_INDEXES, this.remaining.toLongArray());
        return tag;
    }

    public void addIndex(long index) {
        this.all.add(index);
        this.remaining.add(index);
        this.setDirty();
    }

    public boolean hasStartIndex(long index) {
        return this.all.contains(index);
    }

    public boolean hasUnhandledIndex(long index) {
        return this.remaining.contains(index);
    }

    public void removeIndex(long index) {
        if (this.remaining.remove(index)) {
            this.setDirty();
        }
    }

    public LongSet getAll() {
        return this.all;
    }
}

