/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.util.TransformerGeneratorAccess;

public class StructureTemplate {
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    public final List<Palette> palettes = Lists.newArrayList();
    public final List<StructureEntityInfo> entityInfoList = Lists.newArrayList();
    private Vec3i size = Vec3i.ZERO;
    private String author = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public Vec3i getSize() {
        return this.size;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(Level level, BlockPos pos, Vec3i size, boolean withEntities, @Nullable Block toIgnore) {
        if (size.getX() >= 1 && size.getY() >= 1 && size.getZ() >= 1) {
            BlockPos blockPos = pos.offset(size).offset(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockPos1 = new BlockPos(Math.min(pos.getX(), blockPos.getX()), Math.min(pos.getY(), blockPos.getY()), Math.min(pos.getZ(), blockPos.getZ()));
            BlockPos blockPos2 = new BlockPos(Math.max(pos.getX(), blockPos.getX()), Math.max(pos.getY(), blockPos.getY()), Math.max(pos.getZ(), blockPos.getZ()));
            this.size = size;
            for (BlockPos blockPos3 : BlockPos.betweenClosed(blockPos1, blockPos2)) {
                BlockPos blockPos4 = blockPos3.subtract(blockPos1);
                BlockState blockState = level.getBlockState(blockPos3);
                if (toIgnore != null && blockState.is(toIgnore)) continue;
                BlockEntity blockEntity = level.getBlockEntity(blockPos3);
                StructureBlockInfo structureBlockInfo = blockEntity != null ? new StructureBlockInfo(blockPos4, blockState, blockEntity.saveWithId(level.registryAccess())) : new StructureBlockInfo(blockPos4, blockState, null);
                StructureTemplate.addToLists(structureBlockInfo, list, list1, list2);
            }
            List<StructureBlockInfo> list3 = StructureTemplate.buildInfoList(list, list1, list2);
            this.palettes.clear();
            this.palettes.add(new Palette(list3));
            if (withEntities) {
                this.fillEntityList(level, blockPos1, blockPos2);
            } else {
                this.entityInfoList.clear();
            }
        }
    }

    private static void addToLists(StructureBlockInfo blockInfo, List<StructureBlockInfo> normalBlocks, List<StructureBlockInfo> blocksWithNbt, List<StructureBlockInfo> blocksWithSpecialShape) {
        if (blockInfo.nbt != null) {
            blocksWithNbt.add(blockInfo);
        } else if (!blockInfo.state.getBlock().hasDynamicShape() && blockInfo.state.isCollisionShapeFullBlock(EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            normalBlocks.add(blockInfo);
        } else {
            blocksWithSpecialShape.add(blockInfo);
        }
    }

    private static List<StructureBlockInfo> buildInfoList(List<StructureBlockInfo> normalBlocks, List<StructureBlockInfo> blocksWithNbt, List<StructureBlockInfo> blocksWithSpecialShape) {
        Comparator<StructureBlockInfo> comparator = Comparator.comparingInt(structureBlockInfo -> structureBlockInfo.pos.getY()).thenComparingInt(structureBlockInfo -> structureBlockInfo.pos.getX()).thenComparingInt(structureBlockInfo -> structureBlockInfo.pos.getZ());
        normalBlocks.sort(comparator);
        blocksWithSpecialShape.sort(comparator);
        blocksWithNbt.sort(comparator);
        ArrayList list = Lists.newArrayList();
        list.addAll(normalBlocks);
        list.addAll(blocksWithSpecialShape);
        list.addAll(blocksWithNbt);
        return list;
    }

    private void fillEntityList(Level level, BlockPos startPos, BlockPos endPos) {
        List<Entity> entitiesOfClass = level.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks(startPos, endPos), entity1 -> !(entity1 instanceof Player));
        this.entityInfoList.clear();
        for (Entity entity : entitiesOfClass) {
            Vec3 vec3 = new Vec3(entity.getX() - (double)startPos.getX(), entity.getY() - (double)startPos.getY(), entity.getZ() - (double)startPos.getZ());
            CompoundTag compoundTag = new CompoundTag();
            entity.save(compoundTag);
            BlockPos blockPos = entity instanceof Painting ? ((Painting)entity).getPos().subtract(startPos) : BlockPos.containing(vec3);
            this.entityInfoList.add(new StructureEntityInfo(vec3, blockPos, compoundTag.copy()));
        }
    }

    public List<StructureBlockInfo> filterBlocks(BlockPos pos, StructurePlaceSettings settings, Block block) {
        return this.filterBlocks(pos, settings, block, true);
    }

    public List<JigsawBlockInfo> getJigsaws(BlockPos pos, Rotation rotation) {
        if (this.palettes.isEmpty()) {
            return new ArrayList<JigsawBlockInfo>();
        }
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setRotation(rotation);
        List<JigsawBlockInfo> list = structurePlaceSettings.getRandomPalette(this.palettes, pos).jigsaws();
        ArrayList<JigsawBlockInfo> list1 = new ArrayList<JigsawBlockInfo>(list.size());
        for (JigsawBlockInfo jigsawBlockInfo : list) {
            StructureBlockInfo structureBlockInfo = jigsawBlockInfo.info;
            list1.add(jigsawBlockInfo.withInfo(new StructureBlockInfo(StructureTemplate.calculateRelativePosition(structurePlaceSettings, structureBlockInfo.pos()).offset(pos), structureBlockInfo.state.rotate(structurePlaceSettings.getRotation()), structureBlockInfo.nbt)));
        }
        return list1;
    }

    public ObjectArrayList<StructureBlockInfo> filterBlocks(BlockPos pos, StructurePlaceSettings settings, Block block, boolean relativePosition) {
        ObjectArrayList list = new ObjectArrayList();
        BoundingBox boundingBox = settings.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return list;
        }
        for (StructureBlockInfo structureBlockInfo : settings.getRandomPalette(this.palettes, pos).blocks(block)) {
            BlockPos blockPos;
            BlockPos blockPos2 = blockPos = relativePosition ? StructureTemplate.calculateRelativePosition(settings, structureBlockInfo.pos).offset(pos) : structureBlockInfo.pos;
            if (boundingBox != null && !boundingBox.isInside(blockPos)) continue;
            list.add((Object)new StructureBlockInfo(blockPos, structureBlockInfo.state.rotate(settings.getRotation()), structureBlockInfo.nbt));
        }
        return list;
    }

    public BlockPos calculateConnectedPosition(StructurePlaceSettings decorator, BlockPos start, StructurePlaceSettings settings, BlockPos end) {
        BlockPos blockPos = StructureTemplate.calculateRelativePosition(decorator, start);
        BlockPos blockPos1 = StructureTemplate.calculateRelativePosition(settings, end);
        return blockPos.subtract(blockPos1);
    }

    public static BlockPos calculateRelativePosition(StructurePlaceSettings decorator, BlockPos pos) {
        return StructureTemplate.transform(pos, decorator.getMirror(), decorator.getRotation(), decorator.getRotationPivot());
    }

    public boolean placeInWorld(ServerLevelAccessor serverLevel, BlockPos offset, BlockPos pos, StructurePlaceSettings settings, RandomSource random, int flags) {
        List<StructureBlockInfo> list;
        if (this.palettes.isEmpty()) {
            return false;
        }
        ServerLevelAccessor wrappedAccess = serverLevel;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            serverLevel = transformerAccess.getHandle();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = settings.getRandomPalette(this.palettes, offset).blocks()).isEmpty() && (settings.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1)) {
            BoundingBox boundingBox = settings.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(settings.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(settings.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int i1 = Integer.MAX_VALUE;
            int i2 = Integer.MAX_VALUE;
            int i3 = Integer.MIN_VALUE;
            int i4 = Integer.MIN_VALUE;
            int i5 = Integer.MIN_VALUE;
            for (StructureBlockInfo structureBlockInfo : StructureTemplate.processBlockInfos(serverLevel, offset, pos, settings, list)) {
                BlockEntity blockEntity;
                BlockPos blockPos = structureBlockInfo.pos;
                if (boundingBox != null && !boundingBox.isInside(blockPos)) continue;
                FluidState fluidState = settings.shouldApplyWaterlogging() ? serverLevel.getFluidState(blockPos) : null;
                BlockState blockState = structureBlockInfo.state.mirror(settings.getMirror()).rotate(settings.getRotation());
                if (structureBlockInfo.nbt != null) {
                    blockEntity = serverLevel.getBlockEntity(blockPos);
                    if (!(serverLevel instanceof WorldGenLevel)) {
                        Clearable.tryClear(blockEntity);
                    }
                    serverLevel.setBlock(blockPos, Blocks.BARRIER.defaultBlockState(), 20);
                }
                if (structureTransformer != null) {
                    CompoundTag compoundTag;
                    CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((LevelReader)serverLevel, blockPos, blockState, null);
                    if (structureBlockInfo.nbt != null && craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                        entityState.loadData(structureBlockInfo.nbt);
                        if (craftBlockState instanceof CraftLootable) {
                            CraftLootable craftLootable = (CraftLootable)craftBlockState;
                            craftLootable.setSeed(random.nextLong());
                        }
                    }
                    craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                    blockState = craftBlockState.getHandle();
                    if (craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                        compoundTag = craftBlockEntityState.getSnapshotNBT();
                    } else {
                        compoundTag = null;
                    }
                    structureBlockInfo = new StructureBlockInfo(blockPos, blockState, compoundTag);
                }
                if (!serverLevel.setBlock(blockPos, blockState, flags)) continue;
                i = Math.min(i, blockPos.getX());
                i1 = Math.min(i1, blockPos.getY());
                i2 = Math.min(i2, blockPos.getZ());
                i3 = Math.max(i3, blockPos.getX());
                i4 = Math.max(i4, blockPos.getY());
                i5 = Math.max(i5, blockPos.getZ());
                list3.add(Pair.of((Object)blockPos, (Object)structureBlockInfo.nbt));
                if (structureBlockInfo.nbt != null && (blockEntity = serverLevel.getBlockEntity(blockPos)) != null) {
                    if (structureTransformer == null && blockEntity instanceof RandomizableContainer) {
                        structureBlockInfo.nbt.putLong("LootTableSeed", random.nextLong());
                    }
                    blockEntity.loadWithComponents(structureBlockInfo.nbt, serverLevel.registryAccess());
                }
                if (fluidState == null) continue;
                if (blockState.getFluidState().isSource()) {
                    list2.add(blockPos);
                    continue;
                }
                if (!(blockState.getBlock() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)((Object)blockState.getBlock())).placeLiquid(serverLevel, blockPos, blockState, fluidState);
                if (fluidState.isSource()) continue;
                list1.add(blockPos);
            }
            boolean flag = true;
            Direction[] directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockState1;
                    Object block;
                    BlockPos blockPos1 = (BlockPos)iterator.next();
                    FluidState fluidState1 = serverLevel.getFluidState(blockPos1);
                    for (int i6 = 0; i6 < directions.length && !fluidState1.isSource(); ++i6) {
                        BlockPos blockPos2 = blockPos1.relative(directions[i6]);
                        FluidState fluidState2 = serverLevel.getFluidState(blockPos2);
                        if (!fluidState2.isSource() || list2.contains(blockPos2)) continue;
                        fluidState1 = fluidState2;
                    }
                    if (!fluidState1.isSource() || !((block = (blockState1 = serverLevel.getBlockState(blockPos1)).getBlock()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)block).placeLiquid(serverLevel, blockPos1, blockState1, fluidState1);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= i3) {
                if (!settings.getKnownShape()) {
                    BitSetDiscreteVoxelShape discreteVoxelShape = new BitSetDiscreteVoxelShape(i3 - i + 1, i4 - i1 + 1, i5 - i2 + 1);
                    int i7 = i;
                    int i8 = i1;
                    int i6x = i2;
                    for (Pair pair : list3) {
                        BlockPos blockPos3 = (BlockPos)pair.getFirst();
                        ((DiscreteVoxelShape)discreteVoxelShape).fill(blockPos3.getX() - i7, blockPos3.getY() - i8, blockPos3.getZ() - i6x);
                    }
                    StructureTemplate.updateShapeAtEdge(serverLevel, flags, discreteVoxelShape, i7, i8, i6x);
                }
                for (Pair pair1 : list3) {
                    BlockEntity blockEntity;
                    BlockPos blockPos4 = (BlockPos)pair1.getFirst();
                    if (!settings.getKnownShape()) {
                        BlockState blockState2;
                        BlockState blockState1 = serverLevel.getBlockState(blockPos4);
                        if (blockState1 != (blockState2 = Block.updateFromNeighbourShapes(blockState1, serverLevel, blockPos4))) {
                            serverLevel.setBlock(blockPos4, blockState2, flags & 0xFFFFFFFE | 0x10);
                        }
                        serverLevel.blockUpdated(blockPos4, blockState2.getBlock());
                    }
                    if (pair1.getSecond() == null || (blockEntity = serverLevel.getBlockEntity(blockPos4)) == null || serverLevel instanceof WorldGenLevel) continue;
                    blockEntity.setChanged();
                }
            }
            if (!settings.isIgnoreEntities()) {
                this.placeEntities(wrappedAccess, offset, settings.getMirror(), settings.getRotation(), settings.getRotationPivot(), boundingBox, settings.shouldFinalizeEntities());
            }
            return true;
        }
        return false;
    }

    public static void updateShapeAtEdge(LevelAccessor level, int flags, DiscreteVoxelShape shape, BlockPos pos) {
        StructureTemplate.updateShapeAtEdge(level, flags, shape, pos.getX(), pos.getY(), pos.getZ());
    }

    public static void updateShapeAtEdge(LevelAccessor level, int flags, DiscreteVoxelShape shape, int x, int y, int z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos();
        shape.forAllFaces((direction, faceX, faceY, faceZ) -> {
            BlockState blockState3;
            mutableBlockPos.set(x + faceX, y + faceY, z + faceZ);
            mutableBlockPos1.setWithOffset((Vec3i)mutableBlockPos, direction);
            BlockState blockState = level.getBlockState(mutableBlockPos);
            BlockState blockState1 = level.getBlockState(mutableBlockPos1);
            BlockState blockState2 = blockState.updateShape(level, level, mutableBlockPos, direction, mutableBlockPos1, blockState1, level.getRandom());
            if (blockState != blockState2) {
                level.setBlock(mutableBlockPos, blockState2, flags & 0xFFFFFFFE);
            }
            if (blockState1 != (blockState3 = blockState1.updateShape(level, level, mutableBlockPos1, direction.getOpposite(), mutableBlockPos, blockState2, level.getRandom()))) {
                level.setBlock(mutableBlockPos1, blockState3, flags & 0xFFFFFFFE);
            }
        });
    }

    public static List<StructureBlockInfo> processBlockInfos(ServerLevelAccessor serverLevel, BlockPos offset, BlockPos pos, StructurePlaceSettings settings, List<StructureBlockInfo> blockInfos) {
        ArrayList<StructureBlockInfo> list = new ArrayList<StructureBlockInfo>();
        List<StructureBlockInfo> list1 = new ArrayList<StructureBlockInfo>();
        for (StructureBlockInfo structureBlockInfo : blockInfos) {
            BlockPos blockPos = StructureTemplate.calculateRelativePosition(settings, structureBlockInfo.pos).offset(offset);
            StructureBlockInfo structureBlockInfo1 = new StructureBlockInfo(blockPos, structureBlockInfo.state, structureBlockInfo.nbt != null ? structureBlockInfo.nbt.copy() : null);
            Iterator<StructureProcessor> iterator = settings.getProcessors().iterator();
            while (structureBlockInfo1 != null && iterator.hasNext()) {
                structureBlockInfo1 = iterator.next().processBlock(serverLevel, offset, pos, structureBlockInfo, structureBlockInfo1, settings);
            }
            if (structureBlockInfo1 == null) continue;
            list1.add(structureBlockInfo1);
            list.add(structureBlockInfo);
        }
        for (StructureProcessor structureProcessor : settings.getProcessors()) {
            list1 = structureProcessor.finalizeProcessing(serverLevel, offset, pos, list, list1, settings);
        }
        return list1;
    }

    private void placeEntities(ServerLevelAccessor serverLevel, BlockPos pos, Mirror mirror, Rotation rotation, BlockPos offset, @Nullable BoundingBox boundingBox, boolean withEntities) {
        for (StructureEntityInfo structureEntityInfo : this.entityInfoList) {
            BlockPos blockPos = StructureTemplate.transform(structureEntityInfo.blockPos, mirror, rotation, offset).offset(pos);
            if (boundingBox != null && !boundingBox.isInside(blockPos)) continue;
            CompoundTag compoundTag = structureEntityInfo.nbt.copy();
            Vec3 vec3 = StructureTemplate.transform(structureEntityInfo.pos, mirror, rotation, offset);
            Vec3 vec31 = vec3.add(pos.getX(), pos.getY(), pos.getZ());
            ListTag listTag = new ListTag();
            listTag.add(DoubleTag.valueOf(vec31.x));
            listTag.add(DoubleTag.valueOf(vec31.y));
            listTag.add(DoubleTag.valueOf(vec31.z));
            compoundTag.put("Pos", listTag);
            compoundTag.remove("UUID");
            StructureTemplate.createEntityIgnoreException(serverLevel, compoundTag).ifPresent(entity -> {
                float f = entity.rotate(rotation);
                entity.moveTo(vec31.x, vec31.y, vec31.z, f += entity.mirror(mirror) - entity.getYRot(), entity.getXRot());
                if (withEntities && entity instanceof Mob) {
                    ((Mob)entity).finalizeSpawn(serverLevel, serverLevel.getCurrentDifficultyAt(BlockPos.containing(vec31)), EntitySpawnReason.STRUCTURE, null);
                }
                serverLevel.addFreshEntityWithPassengers((Entity)entity);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ServerLevelAccessor level, CompoundTag tag) {
        return EntityType.create(tag, level.getLevel(), EntitySpawnReason.STRUCTURE, true);
    }

    public Vec3i getSize(Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new Vec3i(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPos transform(BlockPos targetPos, Mirror mirror, Rotation rotation, BlockPos offset) {
        int x = targetPos.getX();
        int y = targetPos.getY();
        int z = targetPos.getZ();
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                flag = false;
            }
        }
        int x1 = offset.getX();
        int z1 = offset.getZ();
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(x1 - z1 + z, y, x1 + z1 - x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(x1 + z1 - z, y, z1 - x1 + x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(x1 + x1 - x, y, z1 + z1 - z);
            }
        }
        return flag ? new BlockPos(x, y, z) : targetPos;
    }

    public static Vec3 transform(Vec3 target, Mirror mirror, Rotation rotation, BlockPos centerOffset) {
        double d = target.x;
        double d1 = target.y;
        double d2 = target.z;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d = 1.0 - d;
                break;
            }
            default: {
                flag = false;
            }
        }
        int x = centerOffset.getX();
        int z = centerOffset.getZ();
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3((double)(x - z) + d2, d1, (double)(x + z + 1) - d);
            }
            case CLOCKWISE_90: {
                return new Vec3((double)(x + z + 1) - d2, d1, (double)(z - x) + d);
            }
            case CLOCKWISE_180: {
                return new Vec3((double)(x + x + 1) - d, d1, (double)(z + z + 1) - d2);
            }
        }
        return flag ? new Vec3(d, d1, d2) : target;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos targetPos, Mirror mirror, Rotation rotation) {
        return StructureTemplate.getZeroPositionWithTransform(targetPos, mirror, rotation, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos pos, Mirror mirror, Rotation rotation, int sizeX, int sizeZ) {
        int i = mirror == Mirror.FRONT_BACK ? --sizeX : 0;
        int i1 = mirror == Mirror.LEFT_RIGHT ? --sizeZ : 0;
        BlockPos blockPos = pos;
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                blockPos = pos.offset(i1, 0, sizeX - i);
                break;
            }
            case CLOCKWISE_90: {
                blockPos = pos.offset(sizeZ - i1, 0, i);
                break;
            }
            case CLOCKWISE_180: {
                blockPos = pos.offset(sizeX - i, 0, sizeZ - i1);
                break;
            }
            case NONE: {
                blockPos = pos.offset(i, 0, i1);
            }
        }
        return blockPos;
    }

    public BoundingBox getBoundingBox(StructurePlaceSettings settings, BlockPos startPos) {
        return this.getBoundingBox(startPos, settings.getRotation(), settings.getRotationPivot(), settings.getMirror());
    }

    public BoundingBox getBoundingBox(BlockPos startPos, Rotation rotation, BlockPos pivotPos, Mirror mirror) {
        return StructureTemplate.getBoundingBox(startPos, rotation, pivotPos, mirror, this.size);
    }

    @VisibleForTesting
    protected static BoundingBox getBoundingBox(BlockPos startPos, Rotation rotation, BlockPos pivotPos, Mirror mirror, Vec3i size) {
        Vec3i vec3i = size.offset(-1, -1, -1);
        BlockPos blockPos = StructureTemplate.transform(BlockPos.ZERO, mirror, rotation, pivotPos);
        BlockPos blockPos1 = StructureTemplate.transform(BlockPos.ZERO.offset(vec3i), mirror, rotation, pivotPos);
        return BoundingBox.fromCorners(blockPos, blockPos1).move(startPos);
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.palettes.isEmpty()) {
            tag.put(BLOCKS_TAG, new ListTag());
            tag.put(PALETTE_TAG, new ListTag());
        } else {
            ArrayList list = Lists.newArrayList();
            SimplePalette simplePalette = new SimplePalette();
            list.add(simplePalette);
            for (int i = 1; i < this.palettes.size(); ++i) {
                list.add(new SimplePalette());
            }
            ListTag listTag = new ListTag();
            List<StructureBlockInfo> list1 = this.palettes.get(0).blocks();
            for (int i1 = 0; i1 < list1.size(); ++i1) {
                StructureBlockInfo structureBlockInfo = list1.get(i1);
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.put("pos", this.newIntegerList(structureBlockInfo.pos.getX(), structureBlockInfo.pos.getY(), structureBlockInfo.pos.getZ()));
                int i2 = simplePalette.idFor(structureBlockInfo.state);
                compoundTag.putInt(BLOCK_TAG_STATE, i2);
                if (structureBlockInfo.nbt != null) {
                    compoundTag.put("nbt", structureBlockInfo.nbt);
                }
                listTag.add(compoundTag);
                for (int i3 = 1; i3 < this.palettes.size(); ++i3) {
                    SimplePalette simplePalette1 = (SimplePalette)list.get(i3);
                    simplePalette1.addMapping(this.palettes.get((int)i3).blocks().get((int)i1).state, i2);
                }
            }
            tag.put(BLOCKS_TAG, listTag);
            if (list.size() == 1) {
                listTag1 = new ListTag();
                for (BlockState blockState : simplePalette) {
                    listTag1.add(NbtUtils.writeBlockState(blockState));
                }
                tag.put(PALETTE_TAG, listTag1);
            } else {
                listTag1 = new ListTag();
                for (SimplePalette simplePalette2 : list) {
                    ListTag listTag2 = new ListTag();
                    for (BlockState blockState1 : simplePalette2) {
                        listTag2.add(NbtUtils.writeBlockState(blockState1));
                    }
                    listTag1.add(listTag2);
                }
                tag.put(PALETTE_LIST_TAG, listTag1);
            }
        }
        ListTag listTag3 = new ListTag();
        for (StructureEntityInfo structureEntityInfo : this.entityInfoList) {
            CompoundTag compoundTag1 = new CompoundTag();
            compoundTag1.put("pos", this.newDoubleList(structureEntityInfo.pos.x, structureEntityInfo.pos.y, structureEntityInfo.pos.z));
            compoundTag1.put(ENTITY_TAG_BLOCKPOS, this.newIntegerList(structureEntityInfo.blockPos.getX(), structureEntityInfo.blockPos.getY(), structureEntityInfo.blockPos.getZ()));
            if (structureEntityInfo.nbt != null) {
                compoundTag1.put("nbt", structureEntityInfo.nbt);
            }
            listTag3.add(compoundTag1);
        }
        tag.put(ENTITIES_TAG, listTag3);
        tag.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        if (!this.persistentDataContainer.isEmpty()) {
            tag.put("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return NbtUtils.addCurrentDataVersion(tag);
    }

    public void load(HolderGetter<Block> blockGetter, CompoundTag tag) {
        int i;
        ListTag list2;
        this.palettes.clear();
        this.entityInfoList.clear();
        ListTag list = tag.getList(SIZE_TAG, 3);
        this.size = new Vec3i(list.getInt(0), list.getInt(1), list.getInt(2));
        ListTag list1 = tag.getList(BLOCKS_TAG, 10);
        if (tag.contains(PALETTE_LIST_TAG, 9)) {
            list2 = tag.getList(PALETTE_LIST_TAG, 9);
            for (i = 0; i < list2.size(); ++i) {
                this.loadPalette(blockGetter, list2.getList(i), list1);
            }
        } else {
            this.loadPalette(blockGetter, tag.getList(PALETTE_TAG, 10), list1);
        }
        list2 = tag.getList(ENTITIES_TAG, 10);
        for (i = 0; i < list2.size(); ++i) {
            CompoundTag compound = list2.getCompound(i);
            ListTag list3 = compound.getList("pos", 6);
            Vec3 vec3 = new Vec3(list3.getDouble(0), list3.getDouble(1), list3.getDouble(2));
            ListTag list4 = compound.getList(ENTITY_TAG_BLOCKPOS, 3);
            BlockPos blockPos = new BlockPos(list4.getInt(0), list4.getInt(1), list4.getInt(2));
            if (!compound.contains("nbt")) continue;
            CompoundTag compound1 = compound.getCompound("nbt");
            this.entityInfoList.add(new StructureEntityInfo(vec3, blockPos, compound1));
        }
        Tag tag2 = tag.get("BukkitValues");
        if (tag2 instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag2;
            this.persistentDataContainer.putAll(compoundTag);
        }
    }

    private void loadPalette(HolderGetter<Block> blockGetter, ListTag paletteTag, ListTag blocksTag) {
        SimplePalette simplePalette = new SimplePalette();
        for (int i = 0; i < paletteTag.size(); ++i) {
            simplePalette.addMapping(NbtUtils.readBlockState(blockGetter, paletteTag.getCompound(i)), i);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (int i1 = 0; i1 < blocksTag.size(); ++i1) {
            CompoundTag compound = blocksTag.getCompound(i1);
            ListTag list3 = compound.getList("pos", 3);
            BlockPos blockPos = new BlockPos(list3.getInt(0), list3.getInt(1), list3.getInt(2));
            BlockState blockState = simplePalette.stateFor(compound.getInt(BLOCK_TAG_STATE));
            CompoundTag compound1 = compound.contains("nbt") ? compound.getCompound("nbt") : null;
            StructureBlockInfo structureBlockInfo = new StructureBlockInfo(blockPos, blockState, compound1);
            StructureTemplate.addToLists(structureBlockInfo, list, list1, list2);
        }
        List<StructureBlockInfo> list4 = StructureTemplate.buildInfoList(list, list1, list2);
        this.palettes.add(new Palette(list4));
    }

    private ListTag newIntegerList(int ... values) {
        ListTag listTag = new ListTag();
        for (int i : values) {
            listTag.add(IntTag.valueOf(i));
        }
        return listTag;
    }

    private ListTag newDoubleList(double ... values) {
        ListTag listTag = new ListTag();
        for (double d : values) {
            listTag.add(DoubleTag.valueOf(d));
        }
        return listTag;
    }

    public static JigsawBlockEntity.JointType getJointType(CompoundTag tag, BlockState state) {
        return JigsawBlockEntity.JointType.CODEC.byName(tag.getString("joint"), () -> JigsawBlock.getFrontFacing(state).getAxis().isHorizontal() ? JigsawBlockEntity.JointType.ALIGNED : JigsawBlockEntity.JointType.ROLLABLE);
    }

    public record StructureBlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag nbt) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class Palette {
        private final List<StructureBlockInfo> blocks;
        private final Map<Block, List<StructureBlockInfo>> cache = Maps.newConcurrentMap();
        @Nullable
        private List<JigsawBlockInfo> cachedJigsaws;

        Palette(List<StructureBlockInfo> blocks) {
            this.blocks = blocks;
        }

        public List<JigsawBlockInfo> jigsaws() {
            if (this.cachedJigsaws == null) {
                this.cachedJigsaws = this.blocks(Blocks.JIGSAW).stream().map(JigsawBlockInfo::of).toList();
            }
            return this.cachedJigsaws;
        }

        public List<StructureBlockInfo> blocks() {
            return this.blocks;
        }

        public List<StructureBlockInfo> blocks(Block block) {
            return this.cache.computeIfAbsent(block, block1 -> this.blocks.stream().filter(structureBlockInfo -> structureBlockInfo.state.is((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class StructureEntityInfo {
        public final Vec3 pos;
        public final BlockPos blockPos;
        public final CompoundTag nbt;

        public StructureEntityInfo(Vec3 pos, BlockPos blockPos, CompoundTag nbt) {
            this.pos = pos;
            this.blockPos = blockPos;
            this.nbt = nbt;
        }
    }

    public record JigsawBlockInfo(StructureBlockInfo info, JigsawBlockEntity.JointType jointType, ResourceLocation name, ResourceLocation pool, ResourceLocation target, int placementPriority, int selectionPriority) {
        public static JigsawBlockInfo of(StructureBlockInfo structureBlockInfo) {
            CompoundTag compoundTag = Objects.requireNonNull(structureBlockInfo.nbt(), () -> String.valueOf(structureBlockInfo) + " nbt was null");
            return new JigsawBlockInfo(structureBlockInfo, StructureTemplate.getJointType(compoundTag, structureBlockInfo.state()), ResourceLocation.parse(compoundTag.getString("name")), ResourceLocation.parse(compoundTag.getString("pool")), ResourceLocation.parse(compoundTag.getString("target")), compoundTag.getInt("placement_priority"), compoundTag.getInt("selection_priority"));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.info.pos, this.info.state, this.name, this.pool, this.target, this.placementPriority, this.selectionPriority, this.info.nbt);
        }

        public JigsawBlockInfo withInfo(StructureBlockInfo info) {
            return new JigsawBlockInfo(info, this.jointType, this.name, this.pool, this.target, this.placementPriority, this.selectionPriority);
        }
    }

    static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        SimplePalette() {
        }

        public int idFor(BlockState state) {
            int id = this.ids.getId(state);
            if (id == -1) {
                id = this.lastId++;
                this.ids.addMapping(state, id);
            }
            return id;
        }

        @Nullable
        public BlockState stateFor(int id) {
            BlockState blockState = this.ids.byId(id);
            return blockState == null ? DEFAULT_BLOCK_STATE : blockState;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState state, int id) {
            this.ids.addMapping(state, id);
        }
    }
}

