/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = Maps.newHashMap();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage storage) {
        this.storage = storage;
    }

    private Container newStorage(String namespace) {
        Container container = new Container();
        this.namespaces.put(namespace, container);
        return container;
    }

    private SavedData.Factory<Container> factory(String namespace) {
        return new SavedData.Factory<Container>(() -> this.newStorage(namespace), (compoundTag, provider) -> this.newStorage(namespace).load((CompoundTag)compoundTag), DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
    }

    public CompoundTag get(ResourceLocation id) {
        String namespace = id.getNamespace();
        Container container = this.storage.get(this.factory(namespace), CommandStorage.createId(namespace));
        return container != null ? container.get(id.getPath()) : new CompoundTag();
    }

    public void set(ResourceLocation id, CompoundTag nbt) {
        String namespace = id.getNamespace();
        this.storage.computeIfAbsent(this.factory(namespace), CommandStorage.createId(namespace)).put(id.getPath(), nbt);
    }

    public Stream<ResourceLocation> keys() {
        return this.namespaces.entrySet().stream().flatMap(entry -> ((Container)entry.getValue()).getKeys((String)entry.getKey()));
    }

    private static String createId(String namespace) {
        return ID_PREFIX + namespace;
    }

    static class Container
    extends SavedData {
        private static final String TAG_CONTENTS = "contents";
        private final Map<String, CompoundTag> storage = Maps.newHashMap();

        Container() {
        }

        Container load(CompoundTag compoundTag) {
            CompoundTag compound = compoundTag.getCompound(TAG_CONTENTS);
            for (String string : compound.getAllKeys()) {
                this.storage.put(string, compound.getCompound(string));
            }
            return this;
        }

        @Override
        public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
            CompoundTag compoundTag = new CompoundTag();
            this.storage.forEach((key, storageCompoundTag) -> compoundTag.put((String)key, storageCompoundTag.copy()));
            tag.put(TAG_CONTENTS, compoundTag);
            return tag;
        }

        public CompoundTag get(String id) {
            CompoundTag compoundTag = this.storage.get(id);
            return compoundTag != null ? compoundTag : new CompoundTag();
        }

        public void put(String id, CompoundTag nbt) {
            if (nbt.isEmpty()) {
                this.storage.remove(id);
            } else {
                this.storage.put(id, nbt);
            }
            this.setDirty();
        }

        public Stream<ResourceLocation> getKeys(String namespace) {
            return this.storage.keySet().stream().map(key -> ResourceLocation.fromNamespaceAndPath(namespace, key));
        }
    }
}

