/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess levelStorageAccess, DataFixer fixerUpper) {
        this.fixerUpper = fixerUpper;
        this.playerDir = levelStorageAccess.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player player) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try {
            CompoundTag compoundTag = player.saveWithoutId(new CompoundTag());
            Path path = this.playerDir.toPath();
            Path path1 = Files.createTempFile(path, player.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            NbtIo.writeCompressed(compoundTag, path1);
            Path path2 = path.resolve(player.getStringUUID() + ".dat");
            Path path3 = path.resolve(player.getStringUUID() + ".dat_old");
            Util.safeReplaceFile(path2, path1, path3);
        }
        catch (Exception var7) {
            LOGGER.warn("Failed to save player data for {}", (Object)player.getScoreboardName(), (Object)var7);
        }
    }

    private void backup(String name, String stringUuid, String suffix) {
        Path path = this.playerDir.toPath();
        Path path1 = path.resolve(stringUuid + suffix);
        Path path2 = path.resolve(stringUuid + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + suffix);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception var7) {
                LOGGER.warn("Failed to copy the player.dat file for {}", (Object)name, (Object)var7);
            }
        }
    }

    private Optional<CompoundTag> load(String name, String stringUuid, String suffix) {
        File file = new File(this.playerDir, stringUuid + suffix);
        boolean usingWrongFile = false;
        if (Bukkit.getOnlineMode() && !file.exists() && (file = new File(this.playerDir, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).toString() + suffix)).exists()) {
            usingWrongFile = true;
            LOGGER.warn("Using offline mode UUID file for player {} as it is the only copy we can find.", (Object)name);
        }
        if (file.exists() && file.isFile()) {
            try {
                Optional<CompoundTag> optional = Optional.of(NbtIo.readCompressed(file.toPath(), NbtAccounter.unlimitedHeap()));
                if (usingWrongFile) {
                    file.renameTo(new File(file.getPath() + ".offline-read"));
                }
                return optional;
            }
            catch (Exception var5) {
                LOGGER.warn("Failed to load player data for {}", (Object)name);
            }
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> load(Player player) {
        return this.load(player.getName().getString(), player.getStringUUID()).map(tag -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CraftPlayer craftPlayer = serverPlayer.getBukkitEntity();
                long modified = new File(this.playerDir, player.getStringUUID() + ".dat").lastModified();
                if (modified < craftPlayer.getFirstPlayed()) {
                    craftPlayer.setFirstPlayed(modified);
                }
            }
            player.load((CompoundTag)tag);
            return tag;
        });
    }

    public Optional<CompoundTag> load(String name, String uuid) {
        Optional<CompoundTag> optional = this.load(name, uuid, ".dat");
        if (optional.isEmpty()) {
            this.backup(name, uuid, ".dat");
        }
        return optional.or(() -> this.load(name, uuid, ".dat_old")).map(compoundTag -> {
            int dataVersion = NbtUtils.getDataVersion(compoundTag, -1);
            compoundTag = MCDataConverter.convertTag(MCTypeRegistry.PLAYER, compoundTag, dataVersion, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            return compoundTag;
        });
    }

    public File getPlayerDir() {
        return this.playerDir;
    }
}

