/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import java.util.Arrays;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;

public abstract class DiscreteVoxelShape
implements CollisionDiscreteVoxelShape {
    private static final Direction.Axis[] AXIS_VALUES = Direction.Axis.values();
    protected final int xSize;
    protected final int ySize;
    protected final int zSize;
    private CachedShapeData cachedShapeData;

    @Override
    public final CachedShapeData moonrise$getOrCreateCachedShapeData() {
        long[] voxelSet;
        if (this.cachedShapeData != null) {
            return this.cachedShapeData;
        }
        DiscreteVoxelShape discreteVoxelShape = this;
        int sizeX = discreteVoxelShape.getXSize();
        int sizeY = discreteVoxelShape.getYSize();
        int sizeZ = discreteVoxelShape.getZSize();
        int maxIndex = sizeX * sizeY * sizeZ;
        int longsRequired = maxIndex + 63 >>> 6;
        boolean isEmpty = discreteVoxelShape.isEmpty();
        if (discreteVoxelShape instanceof BitSetDiscreteVoxelShape) {
            BitSetDiscreteVoxelShape bitsetShape = (BitSetDiscreteVoxelShape)discreteVoxelShape;
            voxelSet = bitsetShape.storage.toLongArray();
            if (voxelSet.length < longsRequired) {
                voxelSet = Arrays.copyOf(voxelSet, longsRequired);
            }
        } else {
            voxelSet = new long[longsRequired];
            if (!isEmpty) {
                int mulX = sizeZ * sizeY;
                for (int x = 0; x < sizeX; ++x) {
                    for (int y = 0; y < sizeY; ++y) {
                        for (int z = 0; z < sizeZ; ++z) {
                            if (!discreteVoxelShape.isFull(x, y, z)) continue;
                            int index = z + y * sizeZ + x * mulX;
                            int n = index >>> 6;
                            voxelSet[n] = voxelSet[n] | 1L << index;
                        }
                    }
                }
            }
        }
        boolean hasSingleAABB = sizeX == 1 && sizeY == 1 && sizeZ == 1 && !isEmpty && (voxelSet[0] & 1L) != 0L;
        int minFullX = discreteVoxelShape.firstFull(Direction.Axis.X);
        int minFullY = discreteVoxelShape.firstFull(Direction.Axis.Y);
        int minFullZ = discreteVoxelShape.firstFull(Direction.Axis.Z);
        int maxFullX = discreteVoxelShape.lastFull(Direction.Axis.X);
        int maxFullY = discreteVoxelShape.lastFull(Direction.Axis.Y);
        int maxFullZ = discreteVoxelShape.lastFull(Direction.Axis.Z);
        this.cachedShapeData = new CachedShapeData(sizeX, sizeY, sizeZ, voxelSet, minFullX, minFullY, minFullZ, maxFullX, maxFullY, maxFullZ, isEmpty, hasSingleAABB);
        return this.cachedShapeData;
    }

    protected DiscreteVoxelShape(int xSize, int ySize, int zSize) {
        if (xSize < 0 || ySize < 0 || zSize < 0) {
            throw new IllegalArgumentException("Need all positive sizes: x: " + xSize + ", y: " + ySize + ", z: " + zSize);
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
    }

    public boolean isFullWide(AxisCycle axis, int x, int y, int z) {
        return this.isFullWide(axis.cycle(x, y, z, Direction.Axis.X), axis.cycle(x, y, z, Direction.Axis.Y), axis.cycle(x, y, z, Direction.Axis.Z));
    }

    public boolean isFullWide(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.xSize && y < this.ySize && z < this.zSize && this.isFull(x, y, z);
    }

    public boolean isFull(AxisCycle rotation, int x, int y, int z) {
        return this.isFull(rotation.cycle(x, y, z, Direction.Axis.X), rotation.cycle(x, y, z, Direction.Axis.Y), rotation.cycle(x, y, z, Direction.Axis.Z));
    }

    public abstract boolean isFull(int var1, int var2, int var3);

    public abstract void fill(int var1, int var2, int var3);

    public boolean isEmpty() {
        for (Direction.Axis axis : AXIS_VALUES) {
            if (this.firstFull(axis) < this.lastFull(axis)) continue;
            return true;
        }
        return false;
    }

    public abstract int firstFull(Direction.Axis var1);

    public abstract int lastFull(Direction.Axis var1);

    public int firstFull(Direction.Axis axis, int y, int z) {
        int size = this.getSize(axis);
        if (y >= 0 && z >= 0) {
            Direction.Axis axis1 = AxisCycle.FORWARD.cycle(axis);
            Direction.Axis axis2 = AxisCycle.BACKWARD.cycle(axis);
            if (y < this.getSize(axis1) && z < this.getSize(axis2)) {
                AxisCycle axisCycle = AxisCycle.between(Direction.Axis.X, axis);
                for (int i = 0; i < size; ++i) {
                    if (!this.isFull(axisCycle, i, y, z)) continue;
                    return i;
                }
                return size;
            }
            return size;
        }
        return size;
    }

    public int lastFull(Direction.Axis axis, int y, int z) {
        if (y >= 0 && z >= 0) {
            Direction.Axis axis1 = AxisCycle.FORWARD.cycle(axis);
            Direction.Axis axis2 = AxisCycle.BACKWARD.cycle(axis);
            if (y < this.getSize(axis1) && z < this.getSize(axis2)) {
                int size = this.getSize(axis);
                AxisCycle axisCycle = AxisCycle.between(Direction.Axis.X, axis);
                for (int i = size - 1; i >= 0; --i) {
                    if (!this.isFull(axisCycle, i, y, z)) continue;
                    return i + 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public int getSize(Direction.Axis axis) {
        return axis.choose(this.xSize, this.ySize, this.zSize);
    }

    public int getXSize() {
        return this.getSize(Direction.Axis.X);
    }

    public int getYSize() {
        return this.getSize(Direction.Axis.Y);
    }

    public int getZSize() {
        return this.getSize(Direction.Axis.Z);
    }

    public void forAllEdges(IntLineConsumer consumer, boolean combine) {
        this.forAllAxisEdges(consumer, AxisCycle.NONE, combine);
        this.forAllAxisEdges(consumer, AxisCycle.FORWARD, combine);
        this.forAllAxisEdges(consumer, AxisCycle.BACKWARD, combine);
    }

    private void forAllAxisEdges(IntLineConsumer lineConsumer, AxisCycle axis, boolean combine) {
        AxisCycle axisCycle = axis.inverse();
        int size = this.getSize(axisCycle.cycle(Direction.Axis.X));
        int size1 = this.getSize(axisCycle.cycle(Direction.Axis.Y));
        int size2 = this.getSize(axisCycle.cycle(Direction.Axis.Z));
        for (int i = 0; i <= size; ++i) {
            for (int i1 = 0; i1 <= size1; ++i1) {
                int i2 = -1;
                for (int i3 = 0; i3 <= size2; ++i3) {
                    int i4 = 0;
                    int i5 = 0;
                    for (int i6 = 0; i6 <= 1; ++i6) {
                        for (int i7 = 0; i7 <= 1; ++i7) {
                            if (!this.isFullWide(axisCycle, i + i6 - 1, i1 + i7 - 1, i3)) continue;
                            ++i4;
                            i5 ^= i6 ^ i7;
                        }
                    }
                    if (i4 == 1 || i4 == 3 || i4 == 2 && !(i5 & true)) {
                        if (combine) {
                            if (i2 != -1) continue;
                            i2 = i3;
                            continue;
                        }
                        lineConsumer.consume(axisCycle.cycle(i, i1, i3, Direction.Axis.X), axisCycle.cycle(i, i1, i3, Direction.Axis.Y), axisCycle.cycle(i, i1, i3, Direction.Axis.Z), axisCycle.cycle(i, i1, i3 + 1, Direction.Axis.X), axisCycle.cycle(i, i1, i3 + 1, Direction.Axis.Y), axisCycle.cycle(i, i1, i3 + 1, Direction.Axis.Z));
                        continue;
                    }
                    if (i2 == -1) continue;
                    lineConsumer.consume(axisCycle.cycle(i, i1, i2, Direction.Axis.X), axisCycle.cycle(i, i1, i2, Direction.Axis.Y), axisCycle.cycle(i, i1, i2, Direction.Axis.Z), axisCycle.cycle(i, i1, i3, Direction.Axis.X), axisCycle.cycle(i, i1, i3, Direction.Axis.Y), axisCycle.cycle(i, i1, i3, Direction.Axis.Z));
                    i2 = -1;
                }
            }
        }
    }

    public void forAllBoxes(IntLineConsumer consumer, boolean combine) {
        BitSetDiscreteVoxelShape.forAllBoxes(this, consumer, combine);
    }

    public void forAllFaces(IntFaceConsumer faceConsumer) {
        this.forAllAxisFaces(faceConsumer, AxisCycle.NONE);
        this.forAllAxisFaces(faceConsumer, AxisCycle.FORWARD);
        this.forAllAxisFaces(faceConsumer, AxisCycle.BACKWARD);
    }

    private void forAllAxisFaces(IntFaceConsumer faceConsumer, AxisCycle axisRotation) {
        AxisCycle axisCycle = axisRotation.inverse();
        Direction.Axis axis = axisCycle.cycle(Direction.Axis.Z);
        int size = this.getSize(axisCycle.cycle(Direction.Axis.X));
        int size1 = this.getSize(axisCycle.cycle(Direction.Axis.Y));
        int size2 = this.getSize(axis);
        Direction direction = Direction.fromAxisAndDirection(axis, Direction.AxisDirection.NEGATIVE);
        Direction direction1 = Direction.fromAxisAndDirection(axis, Direction.AxisDirection.POSITIVE);
        for (int i = 0; i < size; ++i) {
            for (int i1 = 0; i1 < size1; ++i1) {
                boolean flag = false;
                for (int i2 = 0; i2 <= size2; ++i2) {
                    boolean flag1;
                    boolean bl = flag1 = i2 != size2 && this.isFull(axisCycle, i, i1, i2);
                    if (!flag && flag1) {
                        faceConsumer.consume(direction, axisCycle.cycle(i, i1, i2, Direction.Axis.X), axisCycle.cycle(i, i1, i2, Direction.Axis.Y), axisCycle.cycle(i, i1, i2, Direction.Axis.Z));
                    }
                    if (flag && !flag1) {
                        faceConsumer.consume(direction1, axisCycle.cycle(i, i1, i2 - 1, Direction.Axis.X), axisCycle.cycle(i, i1, i2 - 1, Direction.Axis.Y), axisCycle.cycle(i, i1, i2 - 1, Direction.Axis.Z));
                    }
                    flag = flag1;
                }
            }
        }
    }

    public static interface IntLineConsumer {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface IntFaceConsumer {
        public void consume(Direction var1, int var2, int var3, int var4);
    }
}

