/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;

public class Score
implements ReadOnlyScoreInfo {
    private static final String TAG_SCORE = "Score";
    private static final String TAG_LOCKED = "Locked";
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_FORMAT = "format";
    private int value;
    private boolean locked = true;
    @Nullable
    private Component display;
    @Nullable
    private NumberFormat numberFormat;

    @Override
    public int value() {
        return this.value;
    }

    public void value(int value) {
        this.value = value;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Nullable
    public Component display() {
        return this.display;
    }

    public void display(@Nullable Component display) {
        this.display = display;
    }

    @Override
    @Nullable
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public CompoundTag write(HolderLookup.Provider levelRegistry) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt(TAG_SCORE, this.value);
        compoundTag.putBoolean(TAG_LOCKED, this.locked);
        if (this.display != null) {
            compoundTag.putString(TAG_DISPLAY, Component.Serializer.toJson(this.display, levelRegistry));
        }
        if (this.numberFormat != null) {
            NumberFormatTypes.CODEC.encodeStart(levelRegistry.createSerializationContext(NbtOps.INSTANCE), (Object)this.numberFormat).ifSuccess(tag -> compoundTag.put(TAG_FORMAT, (Tag)tag));
        }
        return compoundTag;
    }

    public static Score read(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        Score score = new Score();
        score.value = tag.getInt(TAG_SCORE);
        score.locked = tag.getBoolean(TAG_LOCKED);
        if (tag.contains(TAG_DISPLAY, 8)) {
            score.display = Component.Serializer.fromJson(tag.getString(TAG_DISPLAY), levelRegistry);
        }
        if (tag.contains(TAG_FORMAT, 10)) {
            NumberFormatTypes.CODEC.parse(levelRegistry.createSerializationContext(NbtOps.INSTANCE), (Object)tag.get(TAG_FORMAT)).ifSuccess(numberFormat -> {
                score.numberFormat = numberFormat;
            });
        }
        return score;
    }
}

