/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public interface ScoreHolder {
    public static final String WILDCARD_NAME = "*";
    public static final ScoreHolder WILDCARD = new ScoreHolder(){

        @Override
        public String getScoreboardName() {
            return ScoreHolder.WILDCARD_NAME;
        }
    };

    public String getScoreboardName();

    @Nullable
    default public Component getDisplayName() {
        return null;
    }

    default public Component getFeedbackDisplayName() {
        Component displayName = this.getDisplayName();
        return displayName != null ? displayName.copy().withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.literal(this.getScoreboardName())))) : Component.literal(this.getScoreboardName());
    }

    public static ScoreHolder forNameOnly(final String name) {
        if (name.equals(WILDCARD_NAME)) {
            return WILDCARD;
        }
        final MutableComponent component = Component.literal(name);
        return new ScoreHolder(){

            @Override
            public String getScoreboardName() {
                return name;
            }

            @Override
            public Component getFeedbackDisplayName() {
                return component;
            }
        };
    }

    public static ScoreHolder fromGameProfile(GameProfile gameProfile) {
        final String name = gameProfile.getName();
        return new ScoreHolder(){

            @Override
            public String getScoreboardName() {
                return name;
            }
        };
    }
}

