/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public record SavedTick<T>(T type, BlockPos pos, int delay, TickPriority priority) {
    private static final String TAG_ID = "i";
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_DELAY = "t";
    private static final String TAG_PRIORITY = "p";
    public static final Hash.Strategy<SavedTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<SavedTick<?>>(){

        public int hashCode(SavedTick<?> savedTick) {
            return 31 * savedTick.pos().hashCode() + savedTick.type().hashCode();
        }

        public boolean equals(@Nullable SavedTick<?> first, @Nullable SavedTick<?> second) {
            return first == second || first != null && second != null && first.type() == second.type() && first.pos().equals(second.pos());
        }
    };

    public static <T> List<SavedTick<T>> loadTickList(ListTag tickList, Function<String, Optional<T>> idParser, ChunkPos chunkPos) {
        ArrayList list = new ArrayList(tickList.size());
        long packedChunkPos = chunkPos.toLong();
        for (int i = 0; i < tickList.size(); ++i) {
            CompoundTag compound = tickList.getCompound(i);
            SavedTick.loadTick(compound, idParser).ifPresent(savedTick -> {
                if (ChunkPos.asLong(savedTick.pos()) == packedChunkPos) {
                    list.add((SavedTick)savedTick);
                }
            });
        }
        return list;
    }

    public static <T> Optional<SavedTick<T>> loadTick(CompoundTag tag, Function<String, Optional<T>> idParser) {
        return idParser.apply(tag.getString(TAG_ID)).map(object -> {
            BlockPos blockPos = new BlockPos(tag.getInt(TAG_X), tag.getInt(TAG_Y), tag.getInt(TAG_Z));
            return new SavedTick<Object>(object, blockPos, tag.getInt(TAG_DELAY), TickPriority.byValue(tag.getInt(TAG_PRIORITY)));
        });
    }

    private static CompoundTag saveTick(String id, BlockPos pos, int delay, TickPriority priority) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString(TAG_ID, id);
        compoundTag.putInt(TAG_X, pos.getX());
        compoundTag.putInt(TAG_Y, pos.getY());
        compoundTag.putInt(TAG_Z, pos.getZ());
        compoundTag.putInt(TAG_DELAY, delay);
        compoundTag.putInt(TAG_PRIORITY, priority.getValue());
        return compoundTag;
    }

    public CompoundTag save(Function<T, String> idGetter) {
        return SavedTick.saveTick(idGetter.apply(this.type), this.pos, this.delay, this.priority);
    }

    public ScheduledTick<T> unpack(long gameTime, long subTickOrder) {
        return new ScheduledTick<T>(this.type, this.pos, gameTime + (long)this.delay, this.priority, subTickOrder);
    }

    public static <T> SavedTick<T> probe(T type, BlockPos pos) {
        return new SavedTick<T>(type, pos, 0, TickPriority.NORMAL);
    }
}

