/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.Holderable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Instrument;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jetbrains.annotations.NotNull;

public class CraftMusicInstrument
extends MusicInstrument
implements Holderable<Instrument> {
    private final Holder<Instrument> holder;

    public static MusicInstrument minecraftToBukkit(Instrument minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftToBukkit(minecraft, Registries.INSTRUMENT);
    }

    public static MusicInstrument minecraftHolderToBukkit(Holder<Instrument> minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.INSTRUMENT);
    }

    public static Instrument bukkitToMinecraft(MusicInstrument bukkit) {
        return (Instrument)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<Instrument> bukkitToMinecraftHolder(MusicInstrument bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.INSTRUMENT);
    }

    public static Object bukkitToString(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((CraftMusicInstrument)bukkit).toBukkitSerializationObject(Instrument.DIRECT_CODEC);
    }

    public static MusicInstrument stringToBukkit(Object string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return (MusicInstrument)Holderable.fromBukkitSerializationObject(string, Instrument.CODEC, RegistryKey.INSTRUMENT);
    }

    public boolean equals(Object o) {
        return this.implEquals(o);
    }

    public int hashCode() {
        return this.implHashCode();
    }

    public String toString() {
        return this.implToString();
    }

    public CraftMusicInstrument(Holder<Instrument> holder) {
        this.holder = holder;
    }

    @Override
    public Holder<Instrument> getHolder() {
        return this.holder;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return Holderable.super.getKey();
    }

    @NotNull
    public String translationKey() {
        ComponentContents componentContents = ((Instrument)this.getHandle()).description().getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        return translatableContents.getKey();
    }
}

