/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftBeacon
extends CraftBlockEntityState<BeaconBlockEntity>
implements Beacon {
    public CraftBeacon(World world, BeaconBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBeacon(CraftBeacon state, Location location) {
        super(state, location);
    }

    public Collection<LivingEntity> getEntitiesInRange() {
        this.ensureNoWorldGeneration();
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        if (tileEntity instanceof BeaconBlockEntity) {
            BeaconBlockEntity beacon = (BeaconBlockEntity)tileEntity;
            List<Player> nms = BeaconBlockEntity.getHumansInRange(beacon.getLevel(), beacon.getBlockPos(), beacon.levels, beacon);
            ArrayList<LivingEntity> bukkit = new ArrayList<LivingEntity>(nms.size());
            for (Player human : nms) {
                bukkit.add(human.getBukkitEntity());
            }
            return bukkit;
        }
        return new ArrayList<LivingEntity>();
    }

    public int getTier() {
        return ((BeaconBlockEntity)this.getSnapshot()).levels;
    }

    public PotionEffect getPrimaryEffect() {
        return ((BeaconBlockEntity)this.getSnapshot()).getPrimaryEffect();
    }

    public void setPrimaryEffect(PotionEffectType effect) {
        ((BeaconBlockEntity)this.getSnapshot()).primaryPower = effect != null ? CraftPotionEffectType.bukkitToMinecraftHolder(effect) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return ((BeaconBlockEntity)this.getSnapshot()).getSecondaryEffect();
    }

    public void setSecondaryEffect(PotionEffectType effect) {
        ((BeaconBlockEntity)this.getSnapshot()).secondaryPower = effect != null ? CraftPotionEffectType.bukkitToMinecraftHolder(effect) : null;
    }

    public net.kyori.adventure.text.Component customName() {
        BeaconBlockEntity be = (BeaconBlockEntity)this.getSnapshot();
        return be.name != null ? PaperAdventure.asAdventure(be.name) : null;
    }

    public void customName(net.kyori.adventure.text.Component customName) {
        ((BeaconBlockEntity)this.getSnapshot()).setCustomName(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public String getCustomName() {
        BeaconBlockEntity beacon = (BeaconBlockEntity)this.getSnapshot();
        return beacon.name != null ? CraftChatMessage.fromComponent(beacon.name) : null;
    }

    public void setCustomName(String name) {
        ((BeaconBlockEntity)this.getSnapshot()).setCustomName(CraftChatMessage.fromStringOrNull(name));
    }

    public boolean isLocked() {
        return ((BeaconBlockEntity)this.getSnapshot()).lockKey != LockCode.NO_LOCK;
    }

    public String getLock() {
        Optional<Component> customName = ((BeaconBlockEntity)this.getSnapshot()).lockKey.predicate().components().asPatch().get(DataComponents.CUSTOM_NAME);
        return customName != null ? customName.map(CraftChatMessage::fromComponent).orElse("") : "";
    }

    public void setLock(String key) {
        if (key == null) {
            ((BeaconBlockEntity)this.getSnapshot()).lockKey = LockCode.NO_LOCK;
        } else {
            DataComponentPredicate predicate = DataComponentPredicate.builder().expect(DataComponents.CUSTOM_NAME, CraftChatMessage.fromStringOrNull(key)).build();
            ((BeaconBlockEntity)this.getSnapshot()).lockKey = new LockCode(new ItemPredicate(Optional.empty(), MinMaxBounds.Ints.ANY, predicate, Collections.emptyMap()));
        }
    }

    public void setLockItem(ItemStack key) {
        ((BeaconBlockEntity)this.getSnapshot()).lockKey = key == null ? LockCode.NO_LOCK : new LockCode(CraftItemStack.asCriterionConditionItem(key));
    }

    @Override
    public CraftBeacon copy() {
        return new CraftBeacon(this, null);
    }

    @Override
    public CraftBeacon copy(Location location) {
        return new CraftBeacon(this, location);
    }

    public double getEffectRange() {
        return ((BeaconBlockEntity)this.getSnapshot()).getEffectRange();
    }

    public void setEffectRange(double range) {
        ((BeaconBlockEntity)this.getSnapshot()).setEffectRange(range);
    }

    public void resetEffectRange() {
        ((BeaconBlockEntity)this.getSnapshot()).resetEffectRange();
    }
}

