/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftLootable<ChestBlockEntity>
implements Chest {
    public CraftChest(World world, ChestBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftChest(CraftChest state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    public Inventory getBlockInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getTileEntity());
    }

    public Inventory getInventory() {
        CraftInventory inventory = (CraftInventory)this.getBlockInventory();
        if (!this.isPlaced() || this.isWorldGeneration()) {
            return inventory;
        }
        CraftWorld world = (CraftWorld)this.getWorld();
        ChestBlock blockChest = (ChestBlock)(this.getType() == Material.CHEST ? Blocks.CHEST : Blocks.TRAPPED_CHEST);
        MenuProvider nms = blockChest.getMenuProvider(this.data, world.getHandle(), this.getPosition(), true);
        if (nms instanceof ChestBlock.DoubleInventory) {
            inventory = new CraftInventoryDoubleChest((ChestBlock.DoubleInventory)nms);
        }
        return inventory;
    }

    public void open() {
        this.requirePlaced();
        if (!((ChestBlockEntity)this.getTileEntity()).openersCounter.opened && this.getWorldHandle() instanceof Level) {
            BlockState block = ((ChestBlockEntity)this.getTileEntity()).getBlockState();
            int openCount = ((ChestBlockEntity)this.getTileEntity()).openersCounter.getOpenerCount();
            ((ChestBlockEntity)this.getTileEntity()).openersCounter.onAPIOpen((Level)this.getWorldHandle(), this.getPosition(), block);
            ((ChestBlockEntity)this.getTileEntity()).openersCounter.openerAPICountChanged((Level)this.getWorldHandle(), this.getPosition(), block, openCount, openCount + 1);
        }
        ((ChestBlockEntity)this.getTileEntity()).openersCounter.opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((ChestBlockEntity)this.getTileEntity()).openersCounter.opened && this.getWorldHandle() instanceof Level) {
            BlockState block = ((ChestBlockEntity)this.getTileEntity()).getBlockState();
            int openCount = ((ChestBlockEntity)this.getTileEntity()).openersCounter.getOpenerCount();
            ((ChestBlockEntity)this.getTileEntity()).openersCounter.onAPIClose((Level)this.getWorldHandle(), this.getPosition(), block);
            ((ChestBlockEntity)this.getTileEntity()).openersCounter.openerAPICountChanged((Level)this.getWorldHandle(), this.getPosition(), block, openCount, 0);
        }
        ((ChestBlockEntity)this.getTileEntity()).openersCounter.opened = false;
    }

    @Override
    public CraftChest copy() {
        return new CraftChest(this, null);
    }

    @Override
    public CraftChest copy(Location location) {
        return new CraftChest(this, location);
    }

    public boolean isOpen() {
        return ((ChestBlockEntity)this.getTileEntity()).openersCounter.opened;
    }

    public boolean isBlocked() {
        if (!this.isPlaced()) {
            return false;
        }
        LevelAccessor world = this.getWorldHandle();
        if (ChestBlock.isChestBlockedAt(world, this.getPosition())) {
            return true;
        }
        if (ChestBlock.getBlockType(this.data) == DoubleBlockCombiner.BlockType.SINGLE) {
            return false;
        }
        Direction direction = ChestBlock.getConnectedDirection(this.data);
        BlockPos neighbourBlockPos = this.getPosition().relative(direction);
        BlockState neighbourBlockState = world.getBlockStateIfLoaded(neighbourBlockPos);
        return neighbourBlockState != null && neighbourBlockState.is(this.data.getBlock()) && ChestBlock.getBlockType(neighbourBlockState) != DoubleBlockCombiner.BlockType.SINGLE && ChestBlock.getConnectedDirection(neighbourBlockState) == direction.getOpposite() && ChestBlock.isChestBlockedAt(world, neighbourBlockPos);
    }
}

