/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Vault;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftVault
extends CraftBlockEntityState<VaultBlockEntity>
implements Vault {
    public CraftVault(World world, VaultBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftVault(CraftVault state, @Nullable Location location) {
        super(state, location);
    }

    @Override
    public CraftVault copy() {
        return new CraftVault(this, null);
    }

    @Override
    public CraftVault copy(Location location) {
        return new CraftVault(this, location);
    }

    public double getActivationRange() {
        return ((VaultBlockEntity)this.getSnapshot()).getConfig().activationRange();
    }

    public void setActivationRange(double activationRange) {
        Preconditions.checkArgument((boolean)Double.isFinite(activationRange), (Object)"activation range must not be NaN or infinite");
        Preconditions.checkArgument((activationRange <= this.getDeactivationRange() ? 1 : 0) != 0, (String)"New activation range (%s) must be less or equal to deactivation range (%s)", (Object)activationRange, (Object)this.getDeactivationRange());
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).getConfig();
        ((VaultBlockEntity)this.getSnapshot()).setConfig(new VaultConfig(config.lootTable(), activationRange, config.deactivationRange(), config.keyItem(), config.overrideLootTableToDisplay()));
    }

    public double getDeactivationRange() {
        return ((VaultBlockEntity)this.getSnapshot()).getConfig().deactivationRange();
    }

    public void setDeactivationRange(double deactivationRange) {
        Preconditions.checkArgument((boolean)Double.isFinite(deactivationRange), (Object)"deactivation range must not be NaN or infinite");
        Preconditions.checkArgument((deactivationRange >= this.getActivationRange() ? 1 : 0) != 0, (String)"New deactivation range (%s) must be more or equal to activation range (%s)", (Object)deactivationRange, (Object)this.getActivationRange());
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).getConfig();
        ((VaultBlockEntity)this.getSnapshot()).setConfig(new VaultConfig(config.lootTable(), config.activationRange(), deactivationRange, config.keyItem(), config.overrideLootTableToDisplay()));
    }

    public ItemStack getKeyItem() {
        return ((VaultBlockEntity)this.getSnapshot()).getConfig().keyItem().asBukkitCopy();
    }

    public void setKeyItem(ItemStack key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null");
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).getConfig();
        ((VaultBlockEntity)this.getSnapshot()).setConfig(new VaultConfig(config.lootTable(), config.activationRange(), config.deactivationRange(), CraftItemStack.asNMSCopy(key), config.overrideLootTableToDisplay()));
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(((VaultBlockEntity)this.getSnapshot()).getConfig().lootTable());
    }

    public void setLootTable(LootTable lootTable) {
        ResourceKey<net.minecraft.world.level.storage.loot.LootTable> lootTableKey = CraftLootTable.bukkitToMinecraft(lootTable);
        Preconditions.checkArgument((lootTableKey != null ? 1 : 0) != 0, (Object)"lootTable must not be null");
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).getConfig();
        ((VaultBlockEntity)this.getSnapshot()).setConfig(new VaultConfig(lootTableKey, config.activationRange(), config.deactivationRange(), config.keyItem(), config.overrideLootTableToDisplay()));
    }

    public @Nullable LootTable getDisplayedLootTable() {
        return ((VaultBlockEntity)this.getSnapshot()).getConfig().overrideLootTableToDisplay().map(CraftLootTable::minecraftToBukkit).orElse(null);
    }

    public void setDisplayedLootTable(@Nullable LootTable lootTable) {
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).getConfig();
        ((VaultBlockEntity)this.getSnapshot()).setConfig(new VaultConfig(config.lootTable(), config.activationRange(), config.deactivationRange(), config.keyItem(), Optional.ofNullable(CraftLootTable.bukkitToMinecraft(lootTable))));
    }

    public long getNextStateUpdateTime() {
        return ((VaultBlockEntity)this.getSnapshot()).serverData.stateUpdatingResumesAt();
    }

    public void setNextStateUpdateTime(long nextStateUpdateTime) {
        ((VaultBlockEntity)this.getSnapshot()).serverData.pauseStateUpdatingUntil(nextStateUpdateTime);
    }

    public @Unmodifiable Collection<UUID> getRewardedPlayers() {
        return ImmutableSet.copyOf(((VaultBlockEntity)this.getSnapshot()).serverData.getRewardedPlayers());
    }

    public boolean addRewardedPlayer(UUID playerUUID) {
        Preconditions.checkArgument((playerUUID != null ? 1 : 0) != 0, (Object)"playerUUID must not be null");
        return ((VaultBlockEntity)this.getSnapshot()).serverData.addToRewardedPlayers(playerUUID);
    }

    public boolean removeRewardedPlayer(UUID playerUUID) {
        Preconditions.checkArgument((playerUUID != null ? 1 : 0) != 0, (Object)"playerUUID must not be null");
        return ((VaultBlockEntity)this.getSnapshot()).serverData.removeFromRewardedPlayers(playerUUID);
    }

    public boolean hasRewardedPlayer(UUID playerUUID) {
        return ((VaultBlockEntity)this.getSnapshot()).serverData.getRewardedPlayers().contains(playerUUID);
    }

    public @Unmodifiable Set<UUID> getConnectedPlayers() {
        return ImmutableSet.copyOf(((VaultBlockEntity)this.getSnapshot()).getSharedData().getConnectedPlayers());
    }

    public boolean hasConnectedPlayer(UUID playerUUID) {
        return ((VaultBlockEntity)this.getSnapshot()).getSharedData().getConnectedPlayers().contains(playerUUID);
    }

    public ItemStack getDisplayedItem() {
        return CraftItemStack.asBukkitCopy(((VaultBlockEntity)this.getSnapshot()).getSharedData().getDisplayItem());
    }

    public void setDisplayedItem(ItemStack displayedItem) {
        Preconditions.checkArgument((displayedItem != null ? 1 : 0) != 0, (Object)"displayedItem must not be null");
        ((VaultBlockEntity)this.getSnapshot()).getSharedData().setDisplayItem(CraftItemStack.asNMSCopy(displayedItem));
    }
}

