/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.enchantments;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.enchantments.EnchantmentRarity;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.util.Holderable;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;

public class CraftEnchantment
extends org.bukkit.enchantments.Enchantment
implements Holderable<Enchantment> {
    private final Holder<Enchantment> handle;

    public static org.bukkit.enchantments.Enchantment minecraftToBukkit(Enchantment minecraft) {
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.minecraftToBukkit(minecraft, Registries.ENCHANTMENT);
    }

    public static org.bukkit.enchantments.Enchantment minecraftHolderToBukkit(Holder<Enchantment> minecraft) {
        return CraftEnchantment.minecraftToBukkit(minecraft.value());
    }

    public static Enchantment bukkitToMinecraft(org.bukkit.enchantments.Enchantment bukkit) {
        return (Enchantment)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<Enchantment> bukkitToMinecraftHolder(org.bukkit.enchantments.Enchantment bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.ENCHANTMENT);
    }

    public static String bukkitToString(org.bukkit.enchantments.Enchantment bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static org.bukkit.enchantments.Enchantment stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEnchantmentName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.get(RegistryKey.ENCHANTMENT, key, ApiVersion.CURRENT);
    }

    public CraftEnchantment(Holder<Enchantment> holder) {
        this.handle = holder;
    }

    @Override
    public Holder<Enchantment> getHolder() {
        return this.handle;
    }

    @Override
    public NamespacedKey getKey() {
        return Holderable.super.getKey();
    }

    public int getMaxLevel() {
        return ((Enchantment)this.getHandle()).getMaxLevel();
    }

    public int getStartLevel() {
        return ((Enchantment)this.getHandle()).getMinLevel();
    }

    public EnchantmentTarget getItemTarget() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isTreasure() {
        return this.handle.is(EnchantmentTags.TREASURE);
    }

    public boolean isCursed() {
        return this.handle.is(EnchantmentTags.CURSE);
    }

    public boolean canEnchantItem(ItemStack item) {
        return ((Enchantment)this.getHandle()).canEnchant(CraftItemStack.asNMSCopy(item));
    }

    public String getName() {
        String keyName;
        if (!this.getKey().getNamespace().equals("minecraft")) {
            return this.getKey().toString();
        }
        return switch (keyName = this.getKey().getKey().toUpperCase(Locale.ROOT)) {
            case "PROTECTION" -> "PROTECTION_ENVIRONMENTAL";
            case "FIRE_PROTECTION" -> "PROTECTION_FIRE";
            case "FEATHER_FALLING" -> "PROTECTION_FALL";
            case "BLAST_PROTECTION" -> "PROTECTION_EXPLOSIONS";
            case "PROJECTILE_PROTECTION" -> "PROTECTION_PROJECTILE";
            case "RESPIRATION" -> "OXYGEN";
            case "AQUA_AFFINITY" -> "WATER_WORKER";
            case "SHARPNESS" -> "DAMAGE_ALL";
            case "SMITE" -> "DAMAGE_UNDEAD";
            case "BANE_OF_ARTHROPODS" -> "DAMAGE_ARTHROPODS";
            case "LOOTING" -> "LOOT_BONUS_MOBS";
            case "EFFICIENCY" -> "DIG_SPEED";
            case "UNBREAKING" -> "DURABILITY";
            case "FORTUNE" -> "LOOT_BONUS_BLOCKS";
            case "POWER" -> "ARROW_DAMAGE";
            case "PUNCH" -> "ARROW_KNOCKBACK";
            case "FLAME" -> "ARROW_FIRE";
            case "INFINITY" -> "ARROW_INFINITE";
            case "LUCK_OF_THE_SEA" -> "LUCK";
            default -> keyName;
        };
    }

    public boolean conflictsWith(org.bukkit.enchantments.Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !Enchantment.areCompatible(this.handle, ench.handle);
    }

    public Component displayName(int level) {
        return PaperAdventure.asAdventure(Enchantment.getFullname(this.handle, level));
    }

    public String translationKey() {
        ComponentContents componentContents = ((Enchantment)this.getHandle()).description().getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        return translatableContents.getKey();
    }

    public boolean isTradeable() {
        return this.handle.is(EnchantmentTags.TRADEABLE);
    }

    public boolean isDiscoverable() {
        return this.handle.is(EnchantmentTags.IN_ENCHANTING_TABLE) || this.handle.is(EnchantmentTags.ON_RANDOM_LOOT) || this.handle.is(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT) || this.handle.is(EnchantmentTags.TRADEABLE) || this.handle.is(EnchantmentTags.ON_TRADED_EQUIPMENT);
    }

    public int getMinModifiedCost(int level) {
        return ((Enchantment)this.getHandle()).definition().minCost().calculate(level);
    }

    public int getMaxModifiedCost(int level) {
        return ((Enchantment)this.getHandle()).definition().maxCost().calculate(level);
    }

    public int getAnvilCost() {
        return ((Enchantment)this.getHandle()).definition().anvilCost();
    }

    public EnchantmentRarity getRarity() {
        throw new UnsupportedOperationException("Enchantments don't have a rarity anymore in 1.20.5+.");
    }

    public float getDamageIncrease(int level, EntityCategory entityCategory) {
        throw new UnsupportedOperationException("Enchantments are based on complex effect maps since 1.21, cannot compute a simple damage increase");
    }

    public float getDamageIncrease(int level, EntityType entityType) {
        throw new UnsupportedOperationException("Enchantments are based on complex effect maps since 1.21, cannot compute a simple damage increase");
    }

    public Set<EquipmentSlotGroup> getActiveSlotGroups() {
        return ((Enchantment)this.getHandle()).definition().slots().stream().map(CraftEquipmentSlot::getSlot).collect(Collectors.toSet());
    }

    public Component description() {
        return PaperAdventure.asAdventure(this.handle.value().description());
    }

    public RegistryKeySet<ItemType> getSupportedItems() {
        return PaperRegistrySets.convertToApi(RegistryKey.ITEM, this.handle.value().getSupportedItems());
    }

    public RegistryKeySet<ItemType> getPrimaryItems() {
        Optional<HolderSet<Item>> primaryItems = this.handle.value().definition().primaryItems();
        return primaryItems.map(holders -> PaperRegistrySets.convertToApi(RegistryKey.ITEM, holders)).orElse(null);
    }

    public int getWeight() {
        return this.handle.value().getWeight();
    }

    public RegistryKeySet<org.bukkit.enchantments.Enchantment> getExclusiveWith() {
        return PaperRegistrySets.convertToApi(RegistryKey.ENCHANTMENT, this.handle.value().exclusiveSet());
    }

    public String getTranslationKey() {
        return Util.makeDescriptionId("enchantment", this.handle.unwrapKey().get().location());
    }

    public boolean equals(Object other) {
        return Holderable.super.implEquals(other);
    }

    public int hashCode() {
        return Holderable.super.implHashCode();
    }

    public String toString() {
        return Holderable.super.implToString();
    }
}

