/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Rotations;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class CraftArmorStand
extends CraftLivingEntity
implements org.bukkit.entity.ArmorStand {
    public CraftArmorStand(CraftServer server, ArmorStand entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftArmorStand";
    }

    @Override
    public ArmorStand getHandle() {
        return (ArmorStand)super.getHandle();
    }

    public ItemStack getItemInHand() {
        return this.getEquipment().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getEquipment().setItemInHand(item);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    public void setBoots(ItemStack item) {
        this.getEquipment().setBoots(item);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    public void setLeggings(ItemStack item) {
        this.getEquipment().setLeggings(item);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    public void setChestplate(ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    public void setHelmet(ItemStack item) {
        this.getEquipment().setHelmet(item);
    }

    public EulerAngle getBodyPose() {
        return CraftArmorStand.fromNMS(this.getHandle().bodyPose);
    }

    public void setBodyPose(EulerAngle pose) {
        this.getHandle().setBodyPose(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().leftArmPose);
    }

    public void setLeftArmPose(EulerAngle pose) {
        this.getHandle().setLeftArmPose(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().rightArmPose);
    }

    public void setRightArmPose(EulerAngle pose) {
        this.getHandle().setRightArmPose(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().leftLegPose);
    }

    public void setLeftLegPose(EulerAngle pose) {
        this.getHandle().setLeftLegPose(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().rightLegPose);
    }

    public void setRightLegPose(EulerAngle pose) {
        this.getHandle().setRightLegPose(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getHeadPose() {
        return CraftArmorStand.fromNMS(this.getHandle().headPose);
    }

    public void setHeadPose(EulerAngle pose) {
        this.getHandle().setHeadPose(CraftArmorStand.toNMS(pose));
    }

    public boolean hasBasePlate() {
        return this.getHandle().showBasePlate();
    }

    public void setBasePlate(boolean basePlate) {
        this.getHandle().setNoBasePlate(!basePlate);
    }

    @Override
    public void setGravity(boolean gravity) {
        super.setGravity(gravity);
        this.getHandle().noPhysics = !gravity;
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.getHandle().setInvisible(invisible);
        super.setInvisible(invisible);
    }

    public boolean isVisible() {
        return !this.getHandle().isInvisible();
    }

    public void setVisible(boolean visible) {
        this.getHandle().setInvisible(!visible);
    }

    public boolean hasArms() {
        return this.getHandle().showArms();
    }

    public void setArms(boolean arms) {
        this.getHandle().setShowArms(arms);
    }

    public boolean isSmall() {
        return this.getHandle().isSmall();
    }

    public void setSmall(boolean small) {
        this.getHandle().setSmall(small);
    }

    private static EulerAngle fromNMS(net.minecraft.core.Rotations old) {
        return new EulerAngle(Math.toRadians(old.getX()), Math.toRadians(old.getY()), Math.toRadians(old.getZ()));
    }

    private static net.minecraft.core.Rotations toNMS(EulerAngle old) {
        return new net.minecraft.core.Rotations((float)Math.toDegrees(old.getX()), (float)Math.toDegrees(old.getY()), (float)Math.toDegrees(old.getZ()));
    }

    public boolean isMarker() {
        return this.getHandle().isMarker();
    }

    public void setMarker(boolean marker) {
        this.getHandle().setMarker(marker);
    }

    public void addEquipmentLock(org.bukkit.inventory.EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().disabledSlots |= 1 << CraftEquipmentSlot.getNMS(equipmentSlot).getFilterBit(lockType.ordinal() * 8);
    }

    public void removeEquipmentLock(org.bukkit.inventory.EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().disabledSlots &= ~(1 << CraftEquipmentSlot.getNMS(equipmentSlot).getFilterBit(lockType.ordinal() * 8));
    }

    public boolean hasEquipmentLock(org.bukkit.inventory.EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        return (this.getHandle().disabledSlots & 1 << CraftEquipmentSlot.getNMS(equipmentSlot).getFilterBit(lockType.ordinal() * 8)) != 0;
    }

    public boolean canMove() {
        return this.getHandle().canMove;
    }

    public void setCanMove(boolean move) {
        this.getHandle().canMove = move;
    }

    public ItemStack getItem(org.bukkit.inventory.EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot");
        Preconditions.checkArgument((slot != org.bukkit.inventory.EquipmentSlot.BODY ? 1 : 0) != 0, (Object)"Cannot get body item");
        return this.getHandle().getItemBySlot(CraftEquipmentSlot.getNMS(slot)).asBukkitMirror();
    }

    public void setItem(org.bukkit.inventory.EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot");
        Preconditions.checkArgument((slot != org.bukkit.inventory.EquipmentSlot.BODY ? 1 : 0) != 0, (Object)"Cannot set body item");
        switch (slot) {
            case HAND: {
                this.getEquipment().setItemInMainHand(item);
                return;
            }
            case OFF_HAND: {
                this.getEquipment().setItemInOffHand(item);
                return;
            }
            case FEET: {
                this.setBoots(item);
                return;
            }
            case LEGS: {
                this.setLeggings(item);
                return;
            }
            case CHEST: {
                this.setChestplate(item);
                return;
            }
            case HEAD: {
                this.setHelmet(item);
                return;
            }
        }
        throw new UnsupportedOperationException(slot.name());
    }

    public Set<org.bukkit.inventory.EquipmentSlot> getDisabledSlots() {
        HashSet<org.bukkit.inventory.EquipmentSlot> disabled = new HashSet<org.bukkit.inventory.EquipmentSlot>();
        for (org.bukkit.inventory.EquipmentSlot slot : org.bukkit.inventory.EquipmentSlot.values()) {
            if (!this.isSlotDisabled(slot)) continue;
            disabled.add(slot);
        }
        return disabled;
    }

    public void setDisabledSlots(org.bukkit.inventory.EquipmentSlot ... slots) {
        int disabled = 0;
        for (org.bukkit.inventory.EquipmentSlot slot : slots) {
            if (slot == org.bukkit.inventory.EquipmentSlot.OFF_HAND) continue;
            EquipmentSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
            disabled += (1 << nmsSlot.getFilterBit(0)) + (1 << nmsSlot.getFilterBit(8)) + (1 << nmsSlot.getFilterBit(16));
        }
        this.getHandle().disabledSlots = disabled;
    }

    public void addDisabledSlots(org.bukkit.inventory.EquipmentSlot ... slots) {
        Set<org.bukkit.inventory.EquipmentSlot> disabled = this.getDisabledSlots();
        Collections.addAll(disabled, slots);
        this.setDisabledSlots(disabled.toArray(new org.bukkit.inventory.EquipmentSlot[0]));
    }

    public void removeDisabledSlots(org.bukkit.inventory.EquipmentSlot ... slots) {
        Set<org.bukkit.inventory.EquipmentSlot> disabled = this.getDisabledSlots();
        for (org.bukkit.inventory.EquipmentSlot slot : slots) {
            disabled.remove(slot);
        }
        this.setDisabledSlots(disabled.toArray(new org.bukkit.inventory.EquipmentSlot[0]));
    }

    public boolean isSlotDisabled(org.bukkit.inventory.EquipmentSlot slot) {
        return this.getHandle().isDisabled(CraftEquipmentSlot.getNMS(slot));
    }

    public Rotations getBodyRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().bodyPose);
    }

    public void setBodyRotations(Rotations rotations) {
        this.getHandle().setBodyPose(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getLeftArmRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().leftArmPose);
    }

    public void setLeftArmRotations(Rotations rotations) {
        this.getHandle().setLeftArmPose(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getRightArmRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().rightArmPose);
    }

    public void setRightArmRotations(Rotations rotations) {
        this.getHandle().setRightArmPose(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getLeftLegRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().leftLegPose);
    }

    public void setLeftLegRotations(Rotations rotations) {
        this.getHandle().setLeftLegPose(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getRightLegRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().rightLegPose);
    }

    public void setRightLegRotations(Rotations rotations) {
        this.getHandle().setRightLegPose(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getHeadRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().headPose);
    }

    public void setHeadRotations(Rotations rotations) {
        this.getHandle().setHeadPose(CraftArmorStand.toNMSRotations(rotations));
    }

    private static Rotations fromNMSRotations(net.minecraft.core.Rotations old) {
        return Rotations.ofDegrees((double)old.getX(), (double)old.getY(), (double)old.getZ());
    }

    private static net.minecraft.core.Rotations toNMSRotations(Rotations old) {
        return new net.minecraft.core.Rotations((float)old.x(), (float)old.y(), (float)old.z());
    }

    public boolean canTick() {
        return this.getHandle().canTick;
    }

    public void setCanTick(boolean tick) {
        this.getHandle().canTick = tick;
        this.getHandle().canTickSetByAPI = true;
    }
}

