/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.Guardian;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.entity.LivingEntity;

public class CraftGuardian
extends CraftMonster
implements org.bukkit.entity.Guardian {
    private static final int MINIMUM_ATTACK_TICKS = -10;

    public CraftGuardian(CraftServer server, Guardian entity) {
        super(server, entity);
    }

    @Override
    public Guardian getHandle() {
        return (Guardian)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftGuardian";
    }

    @Override
    public void setTarget(LivingEntity target) {
        super.setTarget(target);
        if (target == null) {
            this.getHandle().setActiveAttackTarget(0);
        }
    }

    public boolean setLaser(boolean activated) {
        if (activated) {
            CraftLivingEntity target = this.getTarget();
            if (target == null) {
                return false;
            }
            this.getHandle().setActiveAttackTarget(target.getEntityId());
        } else {
            this.getHandle().setActiveAttackTarget(0);
        }
        return true;
    }

    public boolean hasLaser() {
        return this.getHandle().hasActiveAttackTarget();
    }

    public int getLaserDuration() {
        return this.getHandle().getAttackDuration();
    }

    public void setLaserTicks(int ticks) {
        Preconditions.checkArgument((ticks >= -10 ? 1 : 0) != 0, (String)"ticks must be >= %s. Given %s", (int)-10, (int)ticks);
        Guardian.GuardianAttackGoal goal = this.getHandle().guardianAttackGoal;
        if (goal != null) {
            goal.attackTime = ticks;
        }
    }

    public int getLaserTicks() {
        Guardian.GuardianAttackGoal goal = this.getHandle().guardianAttackGoal;
        return goal != null ? goal.attackTime : -10;
    }

    public boolean isElder() {
        return false;
    }

    public void setElder(boolean shouldBeElder) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean isMoving() {
        return this.getHandle().isMoving();
    }
}

