/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.damage.CraftDamageSource;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spigotmc.AsyncCatcher;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, net.minecraft.world.entity.LivingEntity entity) {
        super(server, entity);
        if (entity instanceof Mob || entity instanceof ArmorStand) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().getHealth()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        Preconditions.checkArgument(((health = (double)((float)health)) >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0, (String)"Health value (%s) must be between 0 and %s. (attribute base value: %s%s)", (Object)health, (Object)this.getMaxHealth(), (Object)this.getHandle().getAttribute(Attributes.MAX_HEALTH).getBaseValue(), (Object)(this instanceof CraftPlayer ? ", player: " + this.getName() : ""));
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().discard(null);
            return;
        }
        this.getHandle().setHealth((float)health);
        if (health == 0.0) {
            this.getHandle().die(this.getHandle().damageSources().generic());
        }
    }

    public void heal(double amount, EntityRegainHealthEvent.RegainReason reason) {
        this.getHandle().heal((float)amount, reason);
    }

    public double getAbsorptionAmount() {
        return this.getHandle().getAbsorptionAmount();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().setAbsorptionAmount((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().getMaxHealth();
    }

    public void setMaxHealth(double amount) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (String)"Max health amount (%s) must be greater than 0", (Object)amount);
        this.getHandle().getAttribute(Attributes.MAX_HEALTH).setBaseValue(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().getAttribute(Attributes.MAX_HEALTH).getAttribute().value().getDefaultValue());
    }

    public double getEyeHeight() {
        return this.getHandle().getEyeHeight();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public Block getTargetBlock(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockExact(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockFace(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, FluidCollisionMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode);
        return result != null ? result.getHitBlockFace() : null;
    }

    public TargetBlockInfo getTargetBlockInfo(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode.bukkit);
        if (result != null && result.getHitBlock() != null && result.getHitBlockFace() != null) {
            return new TargetBlockInfo(result.getHitBlock(), result.getHitBlockFace());
        }
        return null;
    }

    public Entity getTargetEntity(int maxDistance, boolean ignoreBlocks) {
        EntityHitResult rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : rayTrace.getEntity().getBukkitEntity();
    }

    public TargetEntityInfo getTargetEntityInfo(int maxDistance, boolean ignoreBlocks) {
        EntityHitResult rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new TargetEntityInfo((Entity)rayTrace.getEntity().getBukkitEntity(), new Vector(rayTrace.getLocation().x, rayTrace.getLocation().y, rayTrace.getLocation().z));
    }

    public RayTraceResult rayTraceEntities(int maxDistance, boolean ignoreBlocks) {
        EntityHitResult rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new RayTraceResult(CraftVector.toBukkit(rayTrace.getLocation()), (Entity)rayTrace.getEntity().getBukkitEntity());
    }

    public EntityHitResult rayTraceEntity(int maxDistance, boolean ignoreBlocks) {
        Vec3 eye;
        HitResult rayTraceBlocks;
        EntityHitResult rayTrace = this.getHandle().getTargetEntity(maxDistance);
        if (rayTrace == null) {
            return null;
        }
        if (!ignoreBlocks && (rayTraceBlocks = this.getHandle().getRayTrace(maxDistance, ClipContext.Fluid.NONE)) != null && (eye = this.getHandle().getEyePosition(1.0f)).distanceToSqr(rayTraceBlocks.getLocation()) <= eye.distanceToSqr(rayTrace.getLocation())) {
            return null;
        }
        return rayTrace;
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().getAirSupply();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().setAirSupply(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public ItemStack getItemInUse() {
        net.minecraft.world.item.ItemStack item = this.getHandle().getUseItem();
        return item.isEmpty() ? null : CraftItemStack.asCraftMirror(item);
    }

    public int getItemInUseTicks() {
        return this.getHandle().getUseItemRemainingTicks();
    }

    public void setItemInUseTicks(int ticks) {
        this.getHandle().useItemRemaining = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().removeArrowTime;
    }

    public void setArrowCooldown(int ticks) {
        this.getHandle().removeArrowTime = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().getArrowCount();
    }

    public void setArrowsInBody(int count, boolean fireEvent) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        if (!fireEvent) {
            this.getHandle().getEntityData().set(net.minecraft.world.entity.LivingEntity.DATA_ARROW_COUNT_ID, count);
        } else {
            this.getHandle().setArrowCount(count);
        }
    }

    public void setNextArrowRemoval(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"New amount of ticks before next arrow removal must be >= 0");
        this.getHandle().removeArrowTime = ticks;
    }

    public int getNextArrowRemoval() {
        return this.getHandle().removeArrowTime;
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().isInvulnerableTo((ServerLevel)this.getHandle().level(), this.getHandle().damageSources().generic());
    }

    public int getBeeStingerCooldown() {
        return this.getHandle().removeStingerTime;
    }

    public void setBeeStingerCooldown(int ticks) {
        this.getHandle().removeStingerTime = ticks;
    }

    public int getBeeStingersInBody() {
        return this.getHandle().getStingerCount();
    }

    public void setBeeStingersInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New bee stinger amount must be >= 0");
        this.getHandle().setStingerCount(count);
    }

    public void setNextBeeStingerRemoval(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"New amount of ticks before next bee stinger removal must be >= 0");
        this.getHandle().removeStingerTime = ticks;
    }

    public int getNextBeeStingerRemoval() {
        return this.getHandle().removeStingerTime;
    }

    public void damage(double amount) {
        this.damage(amount, this.getHandle().damageSources().generic());
    }

    public void damage(double amount, Entity source) {
        net.minecraft.world.damagesource.DamageSource reason = this.getHandle().damageSources().generic();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().damageSources().playerAttack(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().damageSources().mobAttack(((CraftLivingEntity)source).getHandle());
        }
        this.damage(amount, reason);
    }

    public void damage(double amount, DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        this.damage(amount, ((CraftDamageSource)damageSource).getHandle());
    }

    private void damage(double amount, net.minecraft.world.damagesource.DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        this.entity.hurt(damageSource, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().invulnerableDuration;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().invulnerableDuration = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().lastHurt;
    }

    public void setLastDamage(double damage) {
        this.getHandle().lastHurt = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().invulnerableTime;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().invulnerableTime = ticks;
    }

    public int getNoActionTicks() {
        return this.getHandle().getNoActionTime();
    }

    public void setNoActionTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().setNoActionTime(ticks);
    }

    @Override
    public net.minecraft.world.entity.LivingEntity getHandle() {
        return (net.minecraft.world.entity.LivingEntity)this.entity;
    }

    public void setHandle(net.minecraft.world.entity.LivingEntity entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + "}";
    }

    public org.bukkit.entity.Player getKiller() {
        return this.getHandle().lastHurtByPlayer == null ? null : (org.bukkit.entity.Player)this.getHandle().lastHurtByPlayer.getBukkitEntity();
    }

    public void setKiller(org.bukkit.entity.Player killer) {
        ServerPlayer entityPlayer = killer == null ? null : ((CraftPlayer)killer).getHandle();
        this.getHandle().lastHurtByPlayer = entityPlayer;
        this.getHandle().lastHurtByMob = entityPlayer;
        this.getHandle().lastHurtByPlayerTime = entityPlayer == null ? 0 : 100;
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        AsyncCatcher.catchOp("effect add");
        this.getHandle().addEffect(CraftPotionUtil.fromBukkit(effect), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().hasEffect(CraftPotionEffectType.bukkitToMinecraftHolder(type));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        MobEffectInstance handle = this.getHandle().getEffect(CraftPotionEffectType.bukkitToMinecraftHolder(type));
        return handle == null ? null : CraftPotionUtil.toBukkit(handle);
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(CraftPotionEffectType.bukkitToMinecraftHolder(type), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (MobEffectInstance handle : this.getHandle().activeEffects.values()) {
            effects.add(CraftPotionUtil.toBukkit(handle));
        }
        return effects;
    }

    public boolean clearActivePotionEffects() {
        return this.getHandle().removeAllEffects(EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public <T extends org.bukkit.entity.Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends org.bukkit.entity.Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        return this.launchProjectile(projectile, velocity, null);
    }

    public <T extends org.bukkit.entity.Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<? super T> function) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        Projectile launch = null;
        if (org.bukkit.entity.Snowball.class.isAssignableFrom(projectile)) {
            launch = new Snowball(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.SNOWBALL));
            ((ThrowableProjectile)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new ThrownEgg(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.EGG));
            ((ThrowableProjectile)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new ThrownEnderpearl(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.ENDER_PEARL));
            ((ThrowableProjectile)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new Arrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.ARROW), null);
                ((org.bukkit.entity.Arrow)launch.getBukkitEntity()).setBasePotionType(PotionType.WATER);
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new net.minecraft.world.entity.projectile.SpectralArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.SPECTRAL_ARROW), null) : (Trident.class.isAssignableFrom(projectile) ? new ThrownTrident(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.TRIDENT)) : new Arrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.ARROW), null));
            }
            ((net.minecraft.world.entity.projectile.AbstractArrow)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), 0.0f, Trident.class.isAssignableFrom(projectile) ? 2.5f : 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = LingeringPotion.class.isAssignableFrom(projectile) ? new net.minecraft.world.entity.projectile.ThrownPotion(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.LINGERING_POTION)) : new net.minecraft.world.entity.projectile.ThrownPotion(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.SPLASH_POTION));
            ((ThrowableProjectile)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new ThrownExperienceBottle(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.EXPERIENCE_BOTTLE));
            ((ThrowableProjectile)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof Player) {
            launch = new FishingHook((Player)this.getHandle(), (Level)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            Vec3 vec = new Vec3(direction.getX(), direction.getY(), direction.getZ());
            if (org.bukkit.entity.SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new SmallFireball(world, this.getHandle(), vec);
            } else if (org.bukkit.entity.WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new WitherSkull(world, this.getHandle(), vec);
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = new net.minecraft.world.entity.projectile.DragonFireball(world, this.getHandle(), vec);
            } else if (org.bukkit.entity.AbstractWindCharge.class.isAssignableFrom(projectile)) {
                launch = BreezeWindCharge.class.isAssignableFrom(projectile) ? EntityType.BREEZE_WIND_CHARGE.create(world, EntitySpawnReason.TRIGGERED) : EntityType.WIND_CHARGE.create(world, EntitySpawnReason.TRIGGERED);
                ((AbstractWindCharge)launch).setOwner(this.getHandle());
                ((AbstractWindCharge)launch).shootFromRotation(this.getHandle(), this.getHandle().getXRot(), this.getHandle().getYRot(), 0.0f, 1.5f, 1.0f);
            } else {
                launch = new LargeFireball(world, this.getHandle(), vec, 1);
            }
            ((AbstractHurtingProjectile)launch).projectileSource = this;
            launch.preserveMotion = true;
            launch.moveTo(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (org.bukkit.entity.LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = EntityType.LLAMA_SPIT.create(world, EntitySpawnReason.TRIGGERED);
            ((LlamaSpit)launch).setOwner(this.getHandle());
            ((LlamaSpit)launch).shoot(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.moveTo(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new net.minecraft.world.entity.projectile.ShulkerBullet(world, this.getHandle(), null, null);
            launch.moveTo(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new FireworkRocketEntity(world, FireworkRocketEntity.getDefaultItem(), this.getHandle(), location.getX(), location.getY() - (double)0.15f, location.getZ(), true);
            float f2 = 0.0f;
            int projectileSize = 1;
            int i = 0;
            float f3 = projectileSize == 1 ? 0.0f : 2.0f * f2 / (float)(projectileSize - 1);
            float f4 = (float)((projectileSize - 1) % 2) * f3 / 2.0f;
            float f5 = 1.0f;
            float yaw = f4 + f5 * (float)((i + 1) / 2) * f3;
            Vec3 vec3 = this.getHandle().getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec32 = this.getHandle().getViewVector(1.0f);
            Vector3f vector3f = vec32.toVector3f().rotate((Quaternionfc)quaternionf);
            ((FireworkRocketEntity)launch).shoot(vector3f.x(), vector3f.y(), vector3f.z(), 1.6f, 1.0f);
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (String)"Projectile (%s) not supported", (Object)projectile.getName());
        if (velocity != null) {
            ((org.bukkit.entity.Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        if (function != null) {
            function.accept((org.bukkit.entity.Projectile)launch.getBukkitEntity());
        }
        world.addFreshEntity(launch);
        return (T)((org.bukkit.entity.Projectile)launch.getBukkitEntity());
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().hasLineOfSight(((CraftEntity)other).getHandle());
    }

    public boolean hasLineOfSight(Location loc) {
        if (this.getHandle().level() != ((CraftWorld)loc.getWorld()).getHandle()) {
            return false;
        }
        Vec3 start = new Vec3(this.getHandle().getX(), this.getHandle().getEyeY(), this.getHandle().getZ());
        Vec3 end = new Vec3(loc.getX(), loc.getY(), loc.getZ());
        if (end.distanceToSqr(start) > 16384.0) {
            return false;
        }
        return this.getHandle().level().clipDirect(start, end, CollisionContext.of(this.getHandle())) == HitResult.Type.MISS;
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof Mob && !((Mob)this.getHandle()).isPersistenceRequired();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof Mob) {
            ((Mob)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof Mob) {
            ((Mob)this.getHandle()).setCanPickUpLoot(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof Mob) {
            return ((Mob)this.getHandle()).canPickUpLoot();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        return false;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        throw new IllegalStateException("Entity not leashed");
    }

    public boolean setLeashHolder(Entity holder) {
        return false;
    }

    public boolean isGliding() {
        return this.getHandle().getSharedFlag(7);
    }

    public void setGliding(boolean gliding) {
        this.getHandle().setSharedFlag(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().isSwimming();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().setSwimming(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().isAutoSpinAttack();
    }

    public void setRiptiding(boolean riptiding) {
        this.getHandle().setLivingEntityFlag(4, riptiding);
    }

    public boolean isSleeping() {
        return this.getHandle().isSleeping();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().onClimbable();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void registerAttribute(Attribute attribute) {
        this.getHandle().craftAttributes.registerAttribute(attribute);
    }

    public void setAI(boolean ai) {
        if (this.getHandle() instanceof Mob) {
            ((Mob)this.getHandle()).setNoAi(!ai);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof Mob ? !((Mob)this.getHandle()).isNoAi() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof Player) {
            ((Player)this.getHandle()).attack(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().doHurtTarget((ServerLevel)((CraftEntity)target).getHandle().level(), ((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().swing(InteractionHand.MAIN_HAND, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().swing(InteractionHand.OFF_HAND, true);
    }

    public void playHurtAnimation(float yaw) {
        Level level = this.getHandle().level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            float actualYaw = yaw + 90.0f;
            ClientboundHurtAnimationPacket packet = new ClientboundHurtAnimationPacket(this.getEntityId(), actualYaw);
            world.getChunkSource().broadcastAndSend(this.getHandle(), packet);
        }
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().getBrain().getMemory(CraftMemoryKey.bukkitToMinecraft(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t) {
        this.getHandle().getBrain().setMemory(CraftMemoryKey.bukkitToMinecraft(memoryKey), CraftMemoryMapper.toNms(t));
    }

    public Sound getHurtSound() {
        SoundEvent sound = this.getHandle().getHurtSound0(this.getHandle().damageSources().generic());
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        SoundEvent sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallSounds().small());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallSounds().big());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        return this.getEatingSound(itemStack);
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(itemStack);
        Consumable consumable = nms.get(DataComponents.CONSUMABLE);
        SoundEvent soundeffect = SoundEvents.GENERIC_DRINK.value();
        if (consumable != null) {
            net.minecraft.world.entity.LivingEntity livingEntity = this.getHandle();
            if (livingEntity instanceof Consumable.OverrideConsumeSound) {
                Consumable.OverrideConsumeSound consumable_b = (Consumable.OverrideConsumeSound)((Object)livingEntity);
                soundeffect = consumable_b.getConsumeSound(nms);
            } else {
                soundeffect = consumable.sound().value();
            }
        }
        return CraftSound.minecraftToBukkit(soundeffect);
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().canBreatheUnderwater();
    }

    public EntityCategory getCategory() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    @Override
    public boolean isInvisible() {
        return super.isInvisible();
    }

    @Override
    public void setInvisible(boolean invisible) {
        super.setInvisible(invisible);
    }

    public float getSidewaysMovement() {
        return this.getHandle().xxa;
    }

    public float getForwardsMovement() {
        return this.getHandle().zza;
    }

    public float getUpwardsMovement() {
        return this.getHandle().yya;
    }

    public int getArrowsStuck() {
        return this.getHandle().getArrowCount();
    }

    public void setArrowsStuck(int arrows) {
        this.getHandle().setArrowCount(arrows);
    }

    public int getShieldBlockingDelay() {
        return this.getHandle().getShieldBlockingDelay();
    }

    public void setShieldBlockingDelay(int delay) {
        this.getHandle().setShieldBlockingDelay(delay);
    }

    public void startUsingItem(org.bukkit.inventory.EquipmentSlot hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand must not be null");
        switch (hand) {
            case HAND: {
                this.getHandle().startUsingItem(InteractionHand.MAIN_HAND);
                break;
            }
            case OFF_HAND: {
                this.getHandle().startUsingItem(InteractionHand.OFF_HAND);
                break;
            }
            default: {
                throw new IllegalArgumentException("hand may only be HAND or OFF_HAND");
            }
        }
    }

    public void completeUsingActiveItem() {
        this.getHandle().completeUsingItem();
    }

    public ItemStack getActiveItem() {
        return this.getHandle().getUseItem().asBukkitMirror();
    }

    public void clearActiveItem() {
        this.getHandle().stopUsingItem();
    }

    public int getActiveItemRemainingTime() {
        return this.getHandle().getUseItemRemainingTicks();
    }

    public void setActiveItemRemainingTime(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        Preconditions.checkArgument((ticks <= this.getHandle().getUseItem().getUseDuration(this.getHandle()) ? 1 : 0) != 0, (Object)"ticks must be <= item use duration");
        this.getHandle().useItemRemaining = ticks;
    }

    public int getActiveItemUsedTime() {
        return this.getHandle().getTicksUsingItem();
    }

    public boolean hasActiveItem() {
        return this.getHandle().isUsingItem();
    }

    public org.bukkit.inventory.EquipmentSlot getActiveItemHand() {
        return CraftEquipmentSlot.getHand(this.getHandle().getUsedItemHand());
    }

    public boolean isJumping() {
        return this.getHandle().jumping;
    }

    public void setJumping(boolean jumping) {
        this.getHandle().setJumping(jumping);
        if (jumping && this.getHandle() instanceof Mob) {
            ((Mob)this.getHandle()).getJumpControl().jump();
        }
    }

    public void playPickupItemAnimation(Item item, int quantity) {
        this.getHandle().take(((CraftItem)item).getHandle(), quantity);
    }

    public float getHurtDirection() {
        return this.getHandle().getHurtDir();
    }

    public void setHurtDirection(float hurtDirection) {
        throw new UnsupportedOperationException("Cannot set the hurt direction on a non player");
    }

    public void knockback(double strength, double directionX, double directionZ) {
        Preconditions.checkArgument((strength > 0.0 ? 1 : 0) != 0, (Object)"Knockback strength must be > 0");
        this.getHandle().knockback(strength, directionX, directionZ);
    }

    public void broadcastSlotBreak(org.bukkit.inventory.EquipmentSlot slot) {
        this.getHandle().level().broadcastEntityEvent(this.getHandle(), net.minecraft.world.entity.LivingEntity.entityEventForEquipmentBreak(CraftEquipmentSlot.getNMS(slot)));
    }

    public void broadcastSlotBreak(org.bukkit.inventory.EquipmentSlot slot, Collection<org.bukkit.entity.Player> players) {
        if (players.isEmpty()) {
            return;
        }
        ClientboundEntityEventPacket packet = new ClientboundEntityEventPacket(this.getHandle(), net.minecraft.world.entity.LivingEntity.entityEventForEquipmentBreak(CraftEquipmentSlot.getNMS(slot)));
        players.forEach(player -> ((CraftPlayer)player).getHandle().connection.send(packet));
    }

    public ItemStack damageItemStack(ItemStack stack, int amount) {
        net.minecraft.world.item.ItemStack nmsStack;
        if (stack instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)stack;
            if (craftItemStack.handle == null || craftItemStack.handle.isEmpty()) {
                return stack;
            }
            nmsStack = craftItemStack.handle;
        } else {
            nmsStack = CraftItemStack.asNMSCopy(stack);
            stack = CraftItemStack.asCraftMirror(nmsStack);
        }
        this.damageItemStack0(nmsStack, amount, null);
        return stack;
    }

    public void damageItemStack(org.bukkit.inventory.EquipmentSlot slot, int amount) {
        EquipmentSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.damageItemStack0(this.getHandle().getItemBySlot(nmsSlot), amount, nmsSlot);
    }

    private void damageItemStack0(net.minecraft.world.item.ItemStack nmsStack, int amount, EquipmentSlot slot) {
        nmsStack.hurtAndBreak(amount, this.getHandle(), slot, true);
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Objects.requireNonNull(state, "state may not be null");
        this.getHandle().frictionState = state;
    }

    public float getBodyYaw() {
        return this.getHandle().getVisualRotationYInDegrees();
    }

    public void setBodyYaw(float bodyYaw) {
        this.getHandle().setYBodyRot(bodyYaw);
    }

    public boolean canUseEquipmentSlot(org.bukkit.inventory.EquipmentSlot slot) {
        return this.getHandle().canUseSlot(CraftEquipmentSlot.getNMS(slot));
    }
}

