/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.generator;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftRegionAccessor;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.BoundingBox;

public class CraftLimitedRegion
extends CraftRegionAccessor
implements LimitedRegion {
    private final WeakReference<WorldGenLevel> weakAccess;
    private final int centerChunkX;
    private final int centerChunkZ;
    private final int buffer = 16;
    private final BoundingBox region;
    boolean entitiesLoaded = false;
    private final List<net.minecraft.world.entity.Entity> entities = new ArrayList<net.minecraft.world.entity.Entity>();
    private final List<net.minecraft.world.entity.Entity> outsideEntities = new ArrayList<net.minecraft.world.entity.Entity>();

    public CraftLimitedRegion(WorldGenLevel access, ChunkPos center) {
        this.weakAccess = new WeakReference<WorldGenLevel>(access);
        this.centerChunkX = center.x;
        this.centerChunkZ = center.z;
        CraftWorld world = access.getMinecraftWorld().getWorld();
        int xCenter = this.centerChunkX << 4;
        int zCenter = this.centerChunkZ << 4;
        int xMin = xCenter - this.getBuffer();
        int zMin = zCenter - this.getBuffer();
        int xMax = xCenter + this.getBuffer() + 16;
        int zMax = zCenter + this.getBuffer() + 16;
        this.region = new BoundingBox((double)xMin, (double)world.getMinHeight(), (double)zMin, (double)xMax, (double)world.getMaxHeight(), (double)zMax);
    }

    @Override
    public WorldGenLevel getHandle() {
        WorldGenLevel handle = (WorldGenLevel)this.weakAccess.get();
        Preconditions.checkState((handle != null ? 1 : 0) != 0, (Object)"GeneratorAccessSeed no longer present, are you using it in a different tick?");
        return handle;
    }

    public void loadEntities() {
        if (this.entitiesLoaded) {
            return;
        }
        WorldGenLevel access = this.getHandle();
        for (int x = -(this.buffer >> 4); x <= this.buffer >> 4; ++x) {
            for (int z = -(this.buffer >> 4); z <= this.buffer >> 4; ++z) {
                ProtoChunk chunk = (ProtoChunk)access.getChunk(this.centerChunkX + x, this.centerChunkZ + z);
                for (CompoundTag compound : chunk.getEntities()) {
                    EntityType.loadEntityRecursive(compound, access.getMinecraftWorld(), EntitySpawnReason.LOAD, entity -> {
                        if (this.region.contains(entity.getX(), entity.getY(), entity.getZ())) {
                            entity.generation = true;
                            this.entities.add((net.minecraft.world.entity.Entity)entity);
                        } else {
                            this.outsideEntities.add((net.minecraft.world.entity.Entity)entity);
                        }
                        return entity;
                    });
                }
            }
        }
        this.entitiesLoaded = true;
    }

    public void saveEntities() {
        WorldGenLevel access = this.getHandle();
        if (this.entitiesLoaded) {
            for (int x = -(this.buffer >> 4); x <= this.buffer >> 4; ++x) {
                for (int z = -(this.buffer >> 4); z <= this.buffer >> 4; ++z) {
                    ProtoChunk chunk = (ProtoChunk)access.getChunk(this.centerChunkX + x, this.centerChunkZ + z);
                    chunk.getEntities().clear();
                }
            }
        }
        for (net.minecraft.world.entity.Entity entity : this.entities) {
            if (!entity.isAlive()) continue;
            Preconditions.checkState((boolean)this.region.contains(entity.getX(), entity.getY(), entity.getZ()), (String)"Entity %s is not in the region", (Object)entity);
            access.addFreshEntityWithPassengers(entity);
        }
        for (net.minecraft.world.entity.Entity entity : this.outsideEntities) {
            access.addFreshEntityWithPassengers(entity);
        }
    }

    public void breakLink() {
        this.weakAccess.clear();
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isInRegion(Location location) {
        return this.region.contains(location.getX(), location.getY(), location.getZ());
    }

    public boolean isInRegion(int x, int y, int z) {
        return this.region.contains((double)x, (double)y, (double)z);
    }

    public List<BlockState> getTileEntities() {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        for (int x = -(this.buffer >> 4); x <= this.buffer >> 4; ++x) {
            for (int z = -(this.buffer >> 4); z <= this.buffer >> 4; ++z) {
                ProtoChunk chunk = (ProtoChunk)this.getHandle().getChunk(this.centerChunkX + x, this.centerChunkZ + z);
                for (BlockPos position : chunk.getBlockEntitiesPos()) {
                    blockStates.add(this.getBlockState(position.getX(), position.getY(), position.getZ()));
                }
            }
        }
        return blockStates;
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getBiome(x, y, z);
    }

    @Override
    public Biome getComputedBiome(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getComputedBiome(x, y, z);
    }

    @Override
    public void setBiome(int x, int y, int z, Holder<net.minecraft.world.level.biome.Biome> biomeBase) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        ChunkAccess chunk = this.getHandle().getChunk(x >> 4, z >> 4, ChunkStatus.EMPTY);
        chunk.setBiome(x >> 2, y >> 2, z >> 2, biomeBase);
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getBlockState(x, y, z);
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getBlockData(x, y, z);
    }

    @Override
    public Material getType(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getType(x, y, z);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData blockData) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        super.setBlockData(x, y, z, blockData);
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, this.region.getCenter().getBlockY(), z), (String)"Coordinates %s, %s are not in the region", (int)x, (int)z);
        return super.getHighestBlockYAt(x, z);
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.getHighestBlockYAt(location);
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, this.region.getCenter().getBlockY(), z), (String)"Coordinates %s, %s are not in the region", (int)x, (int)z);
        return super.getHighestBlockYAt(x, z, heightMap);
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.getHighestBlockYAt(location, heightMap);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.generateTree(location, random, treeType);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<? super BlockState> consumer) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.generateTree(location, random, treeType, consumer);
    }

    public Collection<net.minecraft.world.entity.Entity> getNMSEntities() {
        this.loadEntities();
        return new ArrayList<net.minecraft.world.entity.Entity>(this.entities);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.spawn(location, clazz, function, reason);
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.entities.add(entity);
    }

    @Override
    public void addEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.entities.add(entity);
    }

    public void setBlockState(int x, int y, int z, BlockState state) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!state.getBlockData().matches((BlockData)this.getHandle().getBlockState(pos).createCraftBlockData())) {
            throw new IllegalArgumentException("BlockData does not match! Expected " + state.getBlockData().getAsString(false) + ", got " + this.getHandle().getBlockState(pos).createCraftBlockData().getAsString(false));
        }
        this.getHandle().getBlockEntity(pos).loadWithComponents(((CraftBlockEntityState)state).getSnapshotNBT(), this.getHandle().registryAccess());
    }

    public void scheduleBlockUpdate(int x, int y, int z) {
        BlockPos position = new BlockPos(x, y, z);
        this.getHandle().scheduleTick(position, this.getHandle().getBlockState(position).getBlock(), 0);
    }

    public void scheduleFluidUpdate(int x, int y, int z) {
        BlockPos position = new BlockPos(x, y, z);
        this.getHandle().scheduleTick(position, this.getHandle().getFluidState(position).getType(), 0);
    }

    public World getWorld() {
        return this.getHandle().getMinecraftWorld().getWorld();
    }

    public int getCenterChunkX() {
        return this.centerChunkX;
    }

    public int getCenterChunkZ() {
        return this.centerChunkZ;
    }

    @Override
    public FluidData getFluidData(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getFluidData(x, y, z);
    }
}

