/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.destroystokyo.paper.inventory.meta.ArmorStandMeta;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.SerializableMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaArmorStand
extends CraftMetaItem
implements ArmorStandMeta {
    static final CraftMetaItem.ItemMetaKeyType<CustomData> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.ENTITY_DATA, "entity-tag");
    static final CraftMetaItem.ItemMetaKey ENTITY_ID = new CraftMetaItem.ItemMetaKey("id", "entity-id");
    static final CraftMetaItem.ItemMetaKey INVISIBLE = new CraftMetaItem.ItemMetaKey("Invisible", "invisible");
    static final CraftMetaItem.ItemMetaKey NO_BASE_PLATE = new CraftMetaItem.ItemMetaKey("NoBasePlate", "no-base-plate");
    static final CraftMetaItem.ItemMetaKey SHOW_ARMS = new CraftMetaItem.ItemMetaKey("ShowArms", "show-arms");
    static final CraftMetaItem.ItemMetaKey SMALL = new CraftMetaItem.ItemMetaKey("Small", "small");
    static final CraftMetaItem.ItemMetaKey MARKER = new CraftMetaItem.ItemMetaKey("Marker", "marker");
    CompoundTag entityTag;

    CraftMetaArmorStand(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaArmorStand)) {
            return;
        }
        CraftMetaArmorStand armorStand = (CraftMetaArmorStand)meta;
        this.entityTag = armorStand.entityTag;
    }

    CraftMetaArmorStand(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaArmorStand.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.copyTag();
        });
    }

    CraftMetaArmorStand(Map<String, Object> map) {
        super(map);
        String entityTag = SerializableMeta.getString(map, CraftMetaArmorStand.ENTITY_TAG.BUKKIT, true);
        if (entityTag != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(entityTag));
            try {
                this.entityTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.INVISIBLE.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.putBoolean(CraftMetaArmorStand.INVISIBLE.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.NO_BASE_PLATE.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.putBoolean(CraftMetaArmorStand.NO_BASE_PLATE.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.SHOW_ARMS.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.putBoolean(CraftMetaArmorStand.SHOW_ARMS.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.SMALL.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.putBoolean(CraftMetaArmorStand.SMALL.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.MARKER.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.putBoolean(CraftMetaArmorStand.MARKER.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(String.class, map, ENTITY_ID, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.putString(CraftMetaArmorStand.ENTITY_ID.NBT, (String)value);
        });
    }

    @Override
    void deserializeInternal(CompoundTag tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.contains(CraftMetaArmorStand.ENTITY_TAG.NBT)) {
            this.entityTag = tag.getCompound(CraftMetaArmorStand.ENTITY_TAG.NBT);
            if (!this.entityTag.contains(CraftMetaArmorStand.ENTITY_ID.NBT)) {
                this.entityTag.putString(CraftMetaArmorStand.ENTITY_ID.NBT, "minecraft:armor_stand");
            }
        }
    }

    @Override
    void serializeInternal(Map<String, Tag> internalTags) {
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, CustomData.of(this.entityTag));
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.ARMOR_STAND;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isArmorStandEmpty();
    }

    boolean isArmorStandEmpty() {
        return this.entityTag == null || this.entityTag.isEmpty();
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaArmorStand) {
            CraftMetaArmorStand that = (CraftMetaArmorStand)meta;
            return Objects.equals(this.entityTag, that.entityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaArmorStand || this.isArmorStandEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.entityTag != null) {
            hash = 73 * hash + this.entityTag.hashCode();
        }
        return original != hash ? CraftMetaArmorStand.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.entityTag == null) {
            return builder;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            NbtIo.writeCompressed(this.entityTag, buf);
        }
        catch (IOException ex) {
            Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        builder.put((Object)CraftMetaArmorStand.ENTITY_TAG.BUKKIT, (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
        return builder;
    }

    @Override
    public CraftMetaArmorStand clone() {
        CraftMetaArmorStand clone = (CraftMetaArmorStand)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.copy();
        }
        return clone;
    }

    private void populateTagIfNull() {
        if (this.entityTag == null) {
            this.entityTag = new CompoundTag();
            this.entityTag.putString(CraftMetaArmorStand.ENTITY_ID.NBT, "minecraft:armor_stand");
        }
    }

    public boolean isInvisible() {
        return this.entityTag != null && this.entityTag.contains(CraftMetaArmorStand.INVISIBLE.NBT) && this.entityTag.getBoolean(CraftMetaArmorStand.INVISIBLE.NBT);
    }

    public boolean hasNoBasePlate() {
        return this.entityTag != null && this.entityTag.contains(CraftMetaArmorStand.NO_BASE_PLATE.NBT) && this.entityTag.getBoolean(CraftMetaArmorStand.NO_BASE_PLATE.NBT);
    }

    public boolean shouldShowArms() {
        return this.entityTag != null && this.entityTag.contains(CraftMetaArmorStand.SHOW_ARMS.NBT) && this.entityTag.getBoolean(CraftMetaArmorStand.SHOW_ARMS.NBT);
    }

    public boolean isSmall() {
        return this.entityTag != null && this.entityTag.contains(CraftMetaArmorStand.SMALL.NBT) && this.entityTag.getBoolean(CraftMetaArmorStand.SMALL.NBT);
    }

    public boolean isMarker() {
        return this.entityTag != null && this.entityTag.contains(CraftMetaArmorStand.MARKER.NBT) && this.entityTag.getBoolean(CraftMetaArmorStand.MARKER.NBT);
    }

    public void setInvisible(boolean invisible) {
        this.populateTagIfNull();
        this.entityTag.putBoolean(CraftMetaArmorStand.INVISIBLE.NBT, invisible);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.populateTagIfNull();
        this.entityTag.putBoolean(CraftMetaArmorStand.NO_BASE_PLATE.NBT, noBasePlate);
    }

    public void setShowArms(boolean showArms) {
        this.populateTagIfNull();
        this.entityTag.putBoolean(CraftMetaArmorStand.SHOW_ARMS.NBT, showArms);
    }

    public void setSmall(boolean small) {
        this.populateTagIfNull();
        this.entityTag.putBoolean(CraftMetaArmorStand.SMALL.NBT, small);
    }

    public void setMarker(boolean marker) {
        this.populateTagIfNull();
        this.entityTag.putBoolean(CraftMetaArmorStand.MARKER.NBT, marker);
    }
}

