/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.DyeColor;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaTropicalFishBucket
extends CraftMetaItem
implements TropicalFishBucketMeta {
    static final CraftMetaItem.ItemMetaKey VARIANT = new CraftMetaItem.ItemMetaKey("BucketVariantTag", "fish-variant");
    static final CraftMetaItem.ItemMetaKeyType<CustomData> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.ENTITY_DATA, "entity-tag");
    static final CraftMetaItem.ItemMetaKeyType<CustomData> BUCKET_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.BUCKET_ENTITY_DATA, "bucket-entity-tag");
    private Integer variant;
    private CompoundTag entityTag;
    private CompoundTag bucketEntityTag;

    CraftMetaTropicalFishBucket(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaTropicalFishBucket)) {
            return;
        }
        CraftMetaTropicalFishBucket bucket = (CraftMetaTropicalFishBucket)meta;
        this.variant = bucket.variant;
        this.entityTag = bucket.entityTag;
        this.bucketEntityTag = bucket.bucketEntityTag;
    }

    CraftMetaTropicalFishBucket(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaTropicalFishBucket.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.copyTag();
            if (this.entityTag.contains(CraftMetaTropicalFishBucket.VARIANT.NBT, 3)) {
                this.variant = this.entityTag.getInt(CraftMetaTropicalFishBucket.VARIANT.NBT);
            }
        });
        CraftMetaTropicalFishBucket.getOrEmpty(tag, BUCKET_ENTITY_TAG).ifPresent(nbt -> {
            this.bucketEntityTag = nbt.copyTag();
            if (this.bucketEntityTag.contains(CraftMetaTropicalFishBucket.VARIANT.NBT, 3)) {
                this.variant = this.bucketEntityTag.getInt(CraftMetaTropicalFishBucket.VARIANT.NBT);
            }
        });
    }

    CraftMetaTropicalFishBucket(Map<String, Object> map) {
        super(map);
        Integer variant = SerializableMeta.getObject(Integer.class, map, CraftMetaTropicalFishBucket.VARIANT.BUKKIT, true);
        if (variant != null) {
            this.variant = variant;
        }
    }

    @Override
    void deserializeInternal(CompoundTag tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.contains(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT)) {
            this.entityTag = tag.getCompound(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT);
        }
        if (tag.contains(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT)) {
            this.bucketEntityTag = tag.getCompound(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, Tag> internalTags) {
        if (this.entityTag != null && !this.entityTag.isEmpty()) {
            internalTags.put(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT, this.entityTag);
        }
        if (this.bucketEntityTag != null && !this.bucketEntityTag.isEmpty()) {
            internalTags.put(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT, this.bucketEntityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        CompoundTag bucketEntityTag;
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, CustomData.of(this.entityTag));
        }
        CompoundTag compoundTag = bucketEntityTag = this.bucketEntityTag != null ? this.bucketEntityTag.copy() : null;
        if (this.hasVariant()) {
            if (bucketEntityTag == null) {
                bucketEntityTag = new CompoundTag();
            }
            bucketEntityTag.putInt(CraftMetaTropicalFishBucket.VARIANT.NBT, this.variant);
        }
        if (bucketEntityTag != null) {
            tag.put(BUCKET_ENTITY_TAG, CustomData.of(bucketEntityTag));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBucketEmpty();
    }

    boolean isBucketEmpty() {
        return !this.hasVariant() && this.entityTag == null && this.bucketEntityTag == null;
    }

    public DyeColor getPatternColor() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"This bucket doesn't have variant, check hasVariant first!");
        return CraftTropicalFish.getPatternColor(this.variant);
    }

    public void setPatternColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(color, this.getBodyColor(), this.getPattern());
    }

    public DyeColor getBodyColor() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"This bucket doesn't have variant, check hasVariant first!");
        return CraftTropicalFish.getBodyColor(this.variant);
    }

    public void setBodyColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), color, this.getPattern());
    }

    public TropicalFish.Pattern getPattern() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"This bucket doesn't have variant, check hasVariant first!");
        return CraftTropicalFish.getPattern(this.variant);
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), this.getBodyColor(), pattern);
    }

    public boolean hasVariant() {
        return this.variant != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaTropicalFishBucket) {
            CraftMetaTropicalFishBucket that = (CraftMetaTropicalFishBucket)meta;
            return (this.hasVariant() ? that.hasVariant() && this.variant.equals(that.variant) : !that.hasVariant()) && (this.entityTag != null ? that.entityTag != null && this.entityTag.equals(that.entityTag) : that.entityTag == null) && (this.bucketEntityTag != null ? that.bucketEntityTag != null && this.bucketEntityTag.equals(that.bucketEntityTag) : that.bucketEntityTag == null);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaTropicalFishBucket || this.isBucketEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasVariant()) {
            hash = 61 * hash + this.variant;
        }
        if (this.entityTag != null) {
            hash = 61 * hash + this.entityTag.hashCode();
        }
        if (this.bucketEntityTag != null) {
            hash = 61 * hash + this.bucketEntityTag.hashCode();
        }
        return original != hash ? CraftMetaTropicalFishBucket.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaTropicalFishBucket clone() {
        CraftMetaTropicalFishBucket clone = (CraftMetaTropicalFishBucket)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.copy();
        }
        if (this.bucketEntityTag != null) {
            clone.bucketEntityTag = this.bucketEntityTag.copy();
        }
        return clone;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasVariant()) {
            builder.put((Object)CraftMetaTropicalFishBucket.VARIANT.BUKKIT, (Object)this.variant);
        }
        return builder;
    }
}

