/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.util;

import java.util.function.Supplier;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import org.bukkit.craftbukkit.inventory.CraftMenuType;
import org.bukkit.craftbukkit.inventory.CraftMerchant;
import org.bukkit.craftbukkit.inventory.view.builder.CraftAccessLocationInventoryViewBuilder;
import org.bukkit.craftbukkit.inventory.view.builder.CraftBlockEntityInventoryViewBuilder;
import org.bukkit.craftbukkit.inventory.view.builder.CraftDoubleChestInventoryViewBuilder;
import org.bukkit.craftbukkit.inventory.view.builder.CraftEnchantmentInventoryViewBuilder;
import org.bukkit.craftbukkit.inventory.view.builder.CraftMerchantInventoryViewBuilder;
import org.bukkit.craftbukkit.inventory.view.builder.CraftStandardInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.BeaconView;
import org.bukkit.inventory.view.BrewingStandView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.FurnaceView;
import org.bukkit.inventory.view.LecternView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.StonecutterView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CraftMenus {
    public static void openMerchantMenu(ServerPlayer player, MerchantMenu merchant) {
        Merchant minecraftMerchant = ((CraftMerchant)merchant.getBukkitView().getMerchant()).getMerchant();
        int level = 1;
        if (minecraftMerchant instanceof Villager) {
            Villager villager = (Villager)minecraftMerchant;
            level = villager.getVillagerData().getLevel();
        }
        if (minecraftMerchant.getTradingPlayer() != null) {
            minecraftMerchant.getTradingPlayer().closeContainer();
        }
        minecraftMerchant.setTradingPlayer(player);
        player.connection.send(new ClientboundOpenScreenPacket(merchant.containerId, net.minecraft.world.inventory.MenuType.MERCHANT, merchant.getTitle()));
        player.containerMenu = merchant;
        player.initMenu(merchant);
        MerchantOffers merchantrecipelist = minecraftMerchant.getOffers();
        if (!merchantrecipelist.isEmpty()) {
            player.sendMerchantOffers(merchant.containerId, merchantrecipelist, level, minecraftMerchant.getVillagerXp(), minecraftMerchant.showProgressBar(), minecraftMerchant.canRestock());
        }
    }

    public static <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuTypeData<V, B> getMenuTypeData(CraftMenuType<?, ?> menuType) {
        Object handle = menuType.getHandle();
        if (menuType == MenuType.GENERIC_9X6) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftDoubleChestInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$0((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.GENERIC_9X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$1((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.GENERIC_3X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$2((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.CRAFTER_3X3) {
            return CraftMenus.asType(new MenuTypeData<CrafterView, CraftBlockEntityInventoryViewBuilder>(CrafterView.class, () -> CraftMenus.lambda$getMenuTypeData$3((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.ANVIL) {
            return CraftMenus.asType(new MenuTypeData<AnvilView, CraftAccessLocationInventoryViewBuilder>(AnvilView.class, () -> CraftMenus.lambda$getMenuTypeData$4((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.BEACON) {
            return CraftMenus.asType(new MenuTypeData<BeaconView, CraftBlockEntityInventoryViewBuilder>(BeaconView.class, () -> CraftMenus.lambda$getMenuTypeData$5((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.BLAST_FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> CraftMenus.lambda$getMenuTypeData$6((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.BREWING_STAND) {
            return CraftMenus.asType(new MenuTypeData<BrewingStandView, CraftBlockEntityInventoryViewBuilder>(BrewingStandView.class, () -> CraftMenus.lambda$getMenuTypeData$7((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.CRAFTING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$8((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.ENCHANTMENT) {
            return CraftMenus.asType(new MenuTypeData<EnchantmentView, CraftEnchantmentInventoryViewBuilder>(EnchantmentView.class, () -> CraftMenus.lambda$getMenuTypeData$9((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> CraftMenus.lambda$getMenuTypeData$10((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.GRINDSTONE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$11((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.HOPPER) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$12((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.LECTERN) {
            return CraftMenus.asType(new MenuTypeData<LecternView, CraftBlockEntityInventoryViewBuilder>(LecternView.class, () -> CraftMenus.lambda$getMenuTypeData$13((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.LOOM) {
            return CraftMenus.asType(new MenuTypeData<LoomView, CraftAccessLocationInventoryViewBuilder>(LoomView.class, () -> CraftMenus.lambda$getMenuTypeData$14((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.MERCHANT) {
            return CraftMenus.asType(new MenuTypeData<MerchantView, CraftMerchantInventoryViewBuilder>(MerchantView.class, () -> CraftMenus.lambda$getMenuTypeData$15((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.SHULKER_BOX) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$16((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.SMITHING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$17((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.SMOKER) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> CraftMenus.lambda$getMenuTypeData$18((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.CARTOGRAPHY_TABLE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$19((net.minecraft.world.inventory.MenuType)handle)));
        }
        if (menuType == MenuType.STONECUTTER) {
            return CraftMenus.asType(new MenuTypeData<StonecutterView, CraftAccessLocationInventoryViewBuilder>(StonecutterView.class, () -> CraftMenus.lambda$getMenuTypeData$20((net.minecraft.world.inventory.MenuType)handle)));
        }
        return CraftMenus.asType(new MenuTypeData<InventoryView, CraftStandardInventoryViewBuilder>(InventoryView.class, () -> CraftMenus.lambda$getMenuTypeData$21((net.minecraft.world.inventory.MenuType)handle)));
    }

    private static <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuTypeData<V, B> asType(MenuTypeData<?, ?> data) {
        return data;
    }

    private static /* synthetic */ CraftStandardInventoryViewBuilder lambda$getMenuTypeData$21(net.minecraft.world.inventory.MenuType handle) {
        return new CraftStandardInventoryViewBuilder(handle);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$20(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.STONECUTTER);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$19(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.CARTOGRAPHY_TABLE);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$18(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.SMOKER, SmokerBlockEntity::new);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$17(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.SMITHING_TABLE);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$16(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.SHULKER_BOX, ShulkerBoxBlockEntity::new);
    }

    private static /* synthetic */ CraftMerchantInventoryViewBuilder lambda$getMenuTypeData$15(net.minecraft.world.inventory.MenuType handle) {
        return new CraftMerchantInventoryViewBuilder(handle);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$14(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.LOOM);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$13(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.LECTERN, LecternBlockEntity::new);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$12(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.HOPPER, HopperBlockEntity::new);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$11(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.GRINDSTONE);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$10(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.FURNACE, FurnaceBlockEntity::new);
    }

    private static /* synthetic */ CraftEnchantmentInventoryViewBuilder lambda$getMenuTypeData$9(net.minecraft.world.inventory.MenuType handle) {
        return new CraftEnchantmentInventoryViewBuilder(handle);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$8(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.CRAFTING_TABLE);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$7(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.BREWING_STAND, BrewingStandBlockEntity::new);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$6(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.BLAST_FURNACE, BlastFurnaceBlockEntity::new);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$5(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.BEACON, BeaconBlockEntity::new);
    }

    private static /* synthetic */ CraftAccessLocationInventoryViewBuilder lambda$getMenuTypeData$4(net.minecraft.world.inventory.MenuType handle) {
        return new CraftAccessLocationInventoryViewBuilder(handle, Blocks.ANVIL);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$3(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.CRAFTER, CrafterBlockEntity::new);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$2(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.DISPENSER, DispenserBlockEntity::new);
    }

    private static /* synthetic */ CraftBlockEntityInventoryViewBuilder lambda$getMenuTypeData$1(net.minecraft.world.inventory.MenuType handle) {
        return new CraftBlockEntityInventoryViewBuilder(handle, Blocks.CHEST, ChestBlockEntity::new, false);
    }

    private static /* synthetic */ CraftDoubleChestInventoryViewBuilder lambda$getMenuTypeData$0(net.minecraft.world.inventory.MenuType handle) {
        return new CraftDoubleChestInventoryViewBuilder(handle);
    }

    public record MenuTypeData<V extends InventoryView, B extends InventoryViewBuilder<V>>(Class<V> viewClass, Supplier<B> viewBuilder) {
    }
}

