/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.inventory.view.builder.CraftAbstractLocationInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;

public class CraftAccessLocationInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractLocationInventoryViewBuilder<V> {
    private final Block block;

    public CraftAccessLocationInventoryViewBuilder(MenuType<?> handle, Block block) {
        super(handle);
        this.block = block;
    }

    @Override
    protected AbstractContainerMenu buildContainer(ServerPlayer player) {
        BlockState effectiveBlockState;
        Level effectiveLevel;
        BlockPos effectiveBlockPos;
        if (this.position != null) {
            effectiveBlockPos = this.position;
            effectiveLevel = this.world;
            effectiveBlockState = this.world.getBlockState(this.position);
        } else {
            effectiveBlockPos = player.blockPosition();
            effectiveLevel = player.level();
            effectiveBlockState = this.block.defaultBlockState();
        }
        MenuProvider provider = this.block.getMenuProvider(effectiveBlockState, effectiveLevel, effectiveBlockPos);
        this.defaultTitle = provider.getDisplayName();
        return provider.createMenu(player.nextContainerCounter(), player.getInventory(), player);
    }

    @Override
    public LocationInventoryViewBuilder<V> copy() {
        CraftAccessLocationInventoryViewBuilder<V> copy = new CraftAccessLocationInventoryViewBuilder<V>(this.handle, this.block);
        copy.world = this.world;
        copy.position = this.position;
        copy.checkReachable = this.checkReachable;
        copy.title = this.title;
        return copy;
    }

    public static interface CraftAccessContainerObjectBuilder {
        public AbstractContainerMenu build(int var1, Inventory var2, ContainerLevelAccess var3);
    }
}

