/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;

public class CraftMapCanvas
implements MapCanvas {
    private final byte[] buffer = new byte[16384];
    private final CraftMapView mapView;
    private byte[] base;
    private MapCursorCollection cursors = new MapCursorCollection();

    protected CraftMapCanvas(CraftMapView mapView) {
        this.mapView = mapView;
        Arrays.fill(this.buffer, (byte)-1);
    }

    public CraftMapView getMapView() {
        return this.mapView;
    }

    public MapCursorCollection getCursors() {
        return this.cursors;
    }

    public void setCursors(MapCursorCollection cursors) {
        this.cursors = cursors;
    }

    public void setPixelColor(int x, int y, Color color) {
        this.setPixel(x, y, color == null ? (byte)-1 : (byte)MapPalette.matchColor((Color)color));
    }

    public Color getPixelColor(int x, int y) {
        byte pixel = this.getPixel(x, y);
        if (pixel == -1) {
            return null;
        }
        return MapPalette.getColor((byte)pixel);
    }

    public Color getBasePixelColor(int x, int y) {
        return MapPalette.getColor((byte)this.getBasePixel(x, y));
    }

    public void setPixel(int x, int y, byte color) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return;
        }
        if (this.buffer[y * 128 + x] != color) {
            this.buffer[y * 128 + x] = color;
            this.mapView.worldMap.setColorsDirty(x, y);
        }
    }

    public byte getPixel(int x, int y) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return 0;
        }
        return this.buffer[y * 128 + x];
    }

    public byte getBasePixel(int x, int y) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return 0;
        }
        return this.base[y * 128 + x];
    }

    protected void setBase(byte[] base) {
        this.base = base;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public void drawImage(int x, int y, Image image) {
        BufferedImage temp;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int sourceX = Math.max(-x, 0);
        int sourceY = Math.max(-y, 0);
        int destX = Math.max(x, 0);
        int destY = Math.max(y, 0);
        int effectiveWidth = Math.min(imageWidth - sourceX, 128 - destX);
        int effectiveHeight = Math.min(imageHeight - sourceY, 128 - destY);
        if (effectiveWidth <= 0 || effectiveHeight <= 0) {
            return;
        }
        if (imageWidth >= effectiveWidth && image instanceof BufferedImage) {
            BufferedImage bImage = (BufferedImage)image;
            temp = imageWidth > effectiveWidth || imageHeight > effectiveHeight ? bImage.getSubimage(sourceX, sourceY, effectiveWidth, effectiveHeight) : bImage;
        } else {
            temp = new BufferedImage(effectiveWidth, effectiveHeight, 2);
            Graphics2D graphics = temp.createGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
        }
        byte[] bytes = MapPalette.imageToBytes((Image)temp);
        if (x == 0 && effectiveWidth == 128) {
            System.arraycopy(bytes, 0, this.buffer, destY * effectiveWidth, effectiveWidth * effectiveHeight);
        } else {
            for (int yToCopy = 0; yToCopy < effectiveHeight; ++yToCopy) {
                int src = yToCopy * effectiveWidth;
                int dest = (destY + yToCopy) * 128 + destX;
                System.arraycopy(bytes, src, this.buffer, dest, effectiveWidth);
            }
        }
        this.mapView.worldMap.setColorsDirty(destX, destY);
        this.mapView.worldMap.setColorsDirty(destX + effectiveWidth - 1, destY + effectiveHeight - 1);
    }

    public void drawText(int x, int y, MapFont font, String text) {
        int xStart = x;
        byte color = 44;
        Preconditions.checkArgument((boolean)font.isValid(text), (String)"text (%s) contains invalid characters", (Object)text);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                x = xStart;
                y += font.getHeight() + 1;
                continue;
            }
            if (ch == '\u00a7') {
                int j = text.indexOf(59, i);
                Preconditions.checkArgument((j >= 0 ? 1 : 0) != 0, (String)"text (%s) unterminated color string", (Object)text);
                try {
                    color = Byte.parseByte(text.substring(i + 1, j));
                    i = j;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
            for (int r = 0; r < font.getHeight(); ++r) {
                for (int c = 0; c < sprite.getWidth(); ++c) {
                    if (!sprite.get(r, c)) continue;
                    this.setPixel(x + c, y + r, color);
                }
            }
            x += sprite.getWidth() + 1;
        }
    }
}

