/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.RenderType;

public final class CraftCriteria
implements Criteria {
    static final Map<String, CraftCriteria> DEFAULTS;
    static final CraftCriteria DUMMY;
    final ObjectiveCriteria criteria;
    final String bukkitName;

    private CraftCriteria(String bukkitName) {
        this.bukkitName = bukkitName;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(ObjectiveCriteria criteria) {
        this.criteria = criteria;
        this.bukkitName = criteria.getName();
    }

    public String getName() {
        return this.bukkitName;
    }

    public boolean isReadOnly() {
        return this.criteria.isReadOnly();
    }

    public RenderType getDefaultRenderType() {
        return RenderType.values()[this.criteria.getDefaultRenderType().ordinal()];
    }

    public static CraftCriteria getFromNMS(ObjectiveCriteria criteria) {
        return Objects.requireNonNullElseGet(DEFAULTS.get(criteria.getName()), () -> new CraftCriteria(criteria));
    }

    public static CraftCriteria getFromNMS(Objective objective) {
        return Objects.requireNonNullElseGet(DEFAULTS.get(objective.getCriteria().getName()), () -> new CraftCriteria(objective.getCriteria()));
    }

    public static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return ObjectiveCriteria.byName(name).map(CraftCriteria::new).orElseGet(() -> new CraftCriteria(name));
    }

    public boolean equals(Object that) {
        if (!(that instanceof CraftCriteria)) {
            return false;
        }
        return ((CraftCriteria)that).bukkitName.equals(this.bukkitName);
    }

    public int hashCode() {
        return this.bukkitName.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry<String, ObjectiveCriteria> entry : ObjectiveCriteria.CRITERIA_CACHE.entrySet()) {
            String name = entry.getKey();
            ObjectiveCriteria criteria = entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get("dummy");
    }
}

