/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;

public final class CraftLocation {
    private CraftLocation() {
    }

    public static Location toBukkit(Vec3 vec3D) {
        return CraftLocation.toBukkit(vec3D, null);
    }

    public static Location toBukkit(Vec3 vec3D, World world) {
        return CraftLocation.toBukkit(vec3D, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3 vec3D, World world, float yaw, float pitch) {
        return new Location(world, vec3D.x(), vec3D.y(), vec3D.z(), yaw, pitch);
    }

    public static Location toBukkit(BlockPos blockPosition) {
        return CraftLocation.toBukkit(blockPosition, (World)null);
    }

    public static Location toBukkit(BlockPos blockPosition, Level world) {
        return CraftLocation.toBukkit(blockPosition, (World)world.getWorld(), 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPos blockPosition, World world) {
        return CraftLocation.toBukkit(blockPosition, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPos blockPosition, World world, float yaw, float pitch) {
        return new Location(world, (double)blockPosition.getX(), (double)blockPosition.getY(), (double)blockPosition.getZ(), yaw, pitch);
    }

    public static BlockPos toBlockPosition(Location location) {
        return new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static GlobalPos toGlobalPos(Location location) {
        return GlobalPos.of(((CraftWorld)location.getWorld()).getHandle().dimension(), CraftLocation.toBlockPosition(location));
    }

    public static Location fromGlobalPos(GlobalPos globalPos) {
        BlockPos pos = globalPos.pos();
        return new Location((World)MinecraftServer.getServer().getLevel(globalPos.dimension()).getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static Vec3 toVec3D(Location location) {
        return new Vec3(location.getX(), location.getY(), location.getZ());
    }
}

