/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.util.IDataFixerData;
import net.minecraftforge.common.util.ModFixs;

public class CompoundDataFixer
extends ry {
    private final ModFixs vanilla;
    private final Map<String, ModFixs> modFixers = Maps.newHashMap();
    private final Map<rv, List<sa>> walkers = Maps.newHashMap();

    public CompoundDataFixer(ry vanilla) {
        super(0);
        this.vanilla = this.init("minecraft", vanilla.d);
    }

    public fy a(rv type, fy nbt) {
        final Map<String, Integer> versions = this.getVersions(nbt);
        int mcversion = versions.get("minecraft") == null ? -1 : versions.get("minecraft");
        IDataFixerData holder = new IDataFixerData(){

            public fy a(rv type, fy nbt, int version) {
                for (Map.Entry e : CompoundDataFixer.this.modFixers.entrySet()) {
                    ModFixs fixer = (ModFixs)e.getValue();
                    int ver = this.getVersion((String)e.getKey());
                    if (ver >= fixer.version) continue;
                    for (ru fix : fixer.getFixes(type)) {
                        if (fix.a() <= ver) continue;
                        nbt = fix.a(nbt);
                    }
                    for (sa walker : CompoundDataFixer.this.getWalkers(type)) {
                        nbt = walker.a((rx)this, nbt, version);
                    }
                }
                return nbt;
            }

            @Override
            public int getVersion(String mod) {
                Integer ret = (Integer)versions.get(mod);
                return ret == null ? -1 : ret;
            }
        };
        return holder.a(type, nbt, mcversion);
    }

    @Deprecated
    public fy a(rv type, fy nbt, int mcversion) {
        if (type != rw.g) {
            throw new IllegalStateException("Do not call recursive process directly on DataFixer!");
        }
        for (ru fix : this.vanilla.getFixes(type)) {
            if (fix.a() <= mcversion) continue;
            nbt = fix.a(nbt);
        }
        return nbt;
    }

    private List<sa> getWalkers(rv type) {
        return this.walkers.computeIfAbsent(type, k -> Lists.newArrayList());
    }

    @Deprecated
    public void a(rv type, ru fixable) {
        this.vanilla.registerFix(type, fixable);
    }

    @Deprecated
    public void a(rw type, sa walker) {
        this.a((rv)type, walker);
    }

    public void a(rv type, sa walker) {
        this.getWalkers(type).add(walker);
    }

    private void validateModId(String mod) {
        if (!mod.equals(mod.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException("Mod ID is not lower case: " + mod);
        }
        if (mod.length() > 64) {
            throw new IllegalArgumentException("Mod ID is to long: " + mod);
        }
    }

    public ModFixs init(String modid, int version) {
        this.validateModId(modid);
        if (this.modFixers.containsKey(modid)) {
            throw new IllegalStateException("Attempted to initalize DataFixer for " + modid + " twice");
        }
        ModFixs ret = new ModFixs(modid, version);
        this.modFixers.put(modid, ret);
        return ret;
    }

    private Map<String, Integer> getVersions(fy nbt) {
        HashMap ret = Maps.newHashMap();
        ret.put("minecraft", nbt.b("DataVersion", 99) ? nbt.h("DataVersion") : -1);
        if (nbt.b("ForgeDataVersion", 10)) {
            fy sub = nbt.p("ForgeDataVersion");
            Iterator iterator = sub.c().iterator();
            while (iterator.hasNext()) {
                String key;
                ret.put(key, sub.b(key = (String)iterator.next(), 99) ? sub.h(key) : -1);
            }
        }
        return ret;
    }

    public void writeVersionData(fy nbt) {
        fy sub = new fy();
        nbt.a("ForgeDataVersion", (gn)sub);
        for (ModFixs mod : this.modFixers.values()) {
            sub.a(mod.mod, mod.version);
        }
    }
}

