/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class CertificateHelper {
    private static final String HEXES = "0123456789abcdef";

    public static ImmutableList<String> getFingerprints(Certificate[] certificates) {
        int len = 0;
        if (certificates != null) {
            len = certificates.length;
        }
        ImmutableList.Builder certBuilder = ImmutableList.builder();
        for (int i2 = 0; i2 < len; ++i2) {
            certBuilder.add((Object)CertificateHelper.getFingerprint(certificates[i2]));
        }
        return certBuilder.build();
    }

    public static String getFingerprint(Certificate certificate) {
        if (certificate == null) {
            return "NO VALID CERTIFICATE FOUND";
        }
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-1");
            byte[] der = certificate.getEncoded();
            md2.update(der);
            byte[] digest = md2.digest();
            return CertificateHelper.hexify(digest);
        }
        catch (Exception e) {
            return "CERTIFICATE FINGERPRINT EXCEPTION";
        }
    }

    public static String getFingerprint(ByteBuffer buffer) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(buffer);
            byte[] chksum = digest.digest();
            return CertificateHelper.hexify(chksum);
        }
        catch (Exception e) {
            return "CERTIFICATE FINGERPRINT EXCEPTION";
        }
    }

    private static String hexify(byte[] chksum) {
        StringBuilder hex = new StringBuilder(2 * chksum.length);
        for (byte b2 : chksum) {
            hex.append(HEXES.charAt((b2 & 0xF0) >> 4)).append(HEXES.charAt(b2 & 0xF));
        }
        return hex.toString();
    }
}

