/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.redcore.utils;

import dev.redstudio.redcore.ProjectConstants;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Case {
    CAMEL_CASE("^[a-z0-9]++(?:[A-Z]++[a-z0-9]*+)*+$"){

        @Override
        public String apply(String input) {
            AtomicBoolean isFirstWord = new AtomicBoolean(true);
            return Case.prepare(input).map(part -> {
                if (isFirstWord.getAndSet(false)) {
                    return part.toLowerCase();
                }
                return part.isEmpty() ? part : part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }).collect(Collectors.joining());
        }
    }
    ,
    PASCAL_CASE("^[A-Z]([a-z0-9]*)([A-Z][a-z0-9]*)*$"){

        @Override
        public String apply(String input) {
            return Case.prepare(input).map(part -> part.isEmpty() ? "" : part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase()).collect(Collectors.joining());
        }
    }
    ,
    KEBAB_CASE("^[a-z0-9]++(?:-[a-z0-9]++)*+$"){

        @Override
        public String apply(String input) {
            return Case.prepare(input).map(String::toLowerCase).collect(Collectors.joining("-"));
        }
    }
    ,
    LOWER_SNAKE_CASE("^[a-z0-9]++(?:_[a-z0-9]++)*+$"){

        @Override
        public String apply(String input) {
            return Case.prepare(input).map(String::toLowerCase).collect(Collectors.joining("_"));
        }
    }
    ,
    UPPER_SNAKE_CASE("^[A-Z0-9]++(?:_[A-Z0-9]++)*+$"){

        @Override
        public String apply(String input) {
            return Case.prepare(input).map(String::toUpperCase).collect(Collectors.joining("_"));
        }
    };

    private static final Pattern PUNCTUATION_PATTERN;
    private static final Pattern SPLIT_PATTERN;
    private final Pattern pattern;

    private Case(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public abstract String apply(String var1);

    public boolean check(String input) {
        return this.pattern.matcher(input).matches();
    }

    public String enforce(String input) {
        if (this.check(input)) {
            return input;
        }
        String result = this.apply(input);
        ProjectConstants.LOGGER.warn("{} is not in the correct format, converted to {}", (Object)input, (Object)result);
        return result;
    }

    private static Stream<String> prepare(String input) {
        String unpunctuatedInput = PUNCTUATION_PATTERN.matcher(input).replaceAll(" ");
        return Arrays.stream(SPLIT_PATTERN.split(unpunctuatedInput.trim()));
    }

    static {
        PUNCTUATION_PATTERN = Pattern.compile("\\p{Punct}");
        SPLIT_PATTERN = Pattern.compile("\\s+|(?<=[a-z0-9])(?=[A-Z0-9])");
    }
}

