/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.mixin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import org.spongepowered.asm.launch.platform.GlobalMixinContextQuery;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import zone.rong.mixinbooter.MixinBooterPlugin;

@Mixin(value={CrashReport.class})
public class CrashReportMixin {
    @Inject(method={"getCauseStackTraceOrString"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void afterStackTracePopulation(CallbackInfoReturnable<String> cir, StringWriter stringwriter, PrintWriter printwriter, Throwable throwable) {
        try {
            Field classInfo$mixins = ClassInfo.class.getDeclaredField("mixins");
            classInfo$mixins.setAccessible(true);
            LinkedHashMap<String, ClassInfo> classes = new LinkedHashMap<String, ClassInfo>();
            while (throwable != null) {
                StackTraceElement[] stacktrace;
                ClassInfo classInfo;
                if (throwable instanceof NoClassDefFoundError && (classInfo = ClassInfo.fromCache(throwable.getMessage())) != null) {
                    classes.put(throwable.getMessage(), classInfo);
                }
                block3: for (StackTraceElement stackTraceElement : stacktrace = throwable.getStackTrace()) {
                    String className = stackTraceElement.getClassName().replace('.', '/');
                    if (!classes.containsKey(className)) continue;
                    for (ClassInfo classInfo2 = ClassInfo.fromCache(className); classInfo2 != null; classInfo2 = classInfo2.getSuperClass()) {
                        classes.put(className, classInfo2);
                        className = classInfo2.getSuperName();
                        if (className == null || className.isEmpty() || "java/lang/Object".equals(className)) continue block3;
                    }
                }
                throwable = throwable.getCause();
            }
            if (classes.isEmpty()) {
                cir.setReturnValue(cir.getReturnValue() + "\nNo Mixin Metadata is found in the Stacktrace.\n");
            } else {
                StringBuilder mixinMetadataBuilder = new StringBuilder("\n(MixinBooter) Mixins in Stacktrace:");
                boolean addedMetadata = false;
                for (Map.Entry entry : classes.entrySet()) {
                    addedMetadata |= this.mixinbooter$findAndAddMixinMetadata(mixinMetadataBuilder, (String)entry.getKey(), (ClassInfo)entry.getValue());
                }
                if (addedMetadata) {
                    cir.setReturnValue(cir.getReturnValue() + mixinMetadataBuilder);
                } else {
                    cir.setReturnValue(cir.getReturnValue() + "\nNo Mixin Metadata is found in the Stacktrace.\n");
                }
            }
        }
        catch (Throwable t) {
            MixinBooterPlugin.LOGGER.fatal("Unable to gather mixin metadata from the stacktrace", t);
            cir.setReturnValue(cir.getReturnValue() + "\nFailed to find Mixin Metadata in Stacktrace due to exception: " + t);
        }
    }

    @Unique
    private boolean mixinbooter$findAndAddMixinMetadata(StringBuilder mixinMetadataBuilder, String className, ClassInfo classInfo) throws IllegalAccessException {
        Set<IMixinInfo> mixinInfos = classInfo.getApplicableMixins();
        if (!mixinInfos.isEmpty()) {
            mixinMetadataBuilder.append("\n\t");
            mixinMetadataBuilder.append(className);
            mixinMetadataBuilder.append(':');
            for (IMixinInfo mixinInfo : mixinInfos) {
                mixinMetadataBuilder.append("\n\t\t");
                mixinMetadataBuilder.append(mixinInfo.getClassName());
                mixinMetadataBuilder.append(" (");
                mixinMetadataBuilder.append(mixinInfo.getConfig());
                mixinMetadataBuilder.append(") [");
                mixinMetadataBuilder.append(GlobalMixinContextQuery.location(mixinInfo));
                mixinMetadataBuilder.append("]");
            }
            return true;
        }
        return false;
    }
}

