/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.stream.Collectors;
import morph.avaritia.compat.crafttweaker.AddRecipeAction;
import morph.avaritia.compat.crafttweaker.CTIngredientWrapper;
import morph.avaritia.compat.crafttweaker.RemoveRecipeAction;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.extreme.ExtremeShapedRecipe;
import morph.avaritia.recipe.extreme.ExtremeShapelessRecipe;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.avaritia.ExtremeCrafting")
public class ExtremeCrafting {
    @ZenMethod
    public static void addShapeless(String name, IItemStack output, IIngredient[] input) {
        ExtremeShapelessRecipe recipe = new ExtremeShapelessRecipe(ExtremeCrafting.getIngredients(input), CraftTweakerMC.getItemStack((IItemStack)output));
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name must not contain ':'");
        }
        recipe.setRegistryName(new ResourceLocation("craft_tweaker/extreme/shapeless/" + name));
        CraftTweakerAPI.apply((IAction)ExtremeCrafting.createAction(recipe));
    }

    @ZenMethod
    public static void addShaped(String name, IItemStack output, IIngredient[][] ingredients) {
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.height = ingredients.length;
        for (IIngredient[] row : ingredients) {
            primer.width = Math.max(primer.width, row.length);
        }
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        int x = 0;
        IIngredient[][] iIngredientArray = ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] row;
            for (IIngredient ing : row = iIngredientArray[i]) {
                primer.input.set(x++, ing == null ? Ingredient.field_193370_a : new CTIngredientWrapper(ing));
            }
        }
        ExtremeShapedRecipe recipe = new ExtremeShapedRecipe(CraftTweakerMC.getItemStack((IItemStack)output), primer);
        recipe.setRegistryName(new ResourceLocation("avaritia", "craft_tweaker_shaped_" + name));
        CraftTweakerAPI.apply((IAction)ExtremeCrafting.createAction(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack stack) {
        ItemStack check = CraftTweakerMC.getItemStack((IItemStack)stack);
        RemoveRecipeAction<IExtremeRecipe> action = new RemoveRecipeAction<IExtremeRecipe>("Extreme", AvaritiaRecipeManager.EXTREME_RECIPES, recipes -> recipes.stream().filter(recipe -> recipe.getRecipeOutput().func_77969_a(check)).map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), stack.getDisplayName());
        CraftTweakerAPI.apply(action);
    }

    @ZenMethod
    public static void removeShaped(IItemStack stack) {
        ItemStack check = CraftTweakerMC.getItemStack((IItemStack)stack);
        RemoveRecipeAction<IExtremeRecipe> action = new RemoveRecipeAction<IExtremeRecipe>("Extreme Shaped", AvaritiaRecipeManager.EXTREME_RECIPES, recipes -> recipes.stream().filter(IExtremeRecipe::isShapedRecipe).filter(recipe -> recipe.getRecipeOutput().func_77969_a(check)).map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), stack.getDisplayName());
        CraftTweakerAPI.apply(action);
    }

    @ZenMethod
    public static void removeShapeless(IItemStack stack) {
        ItemStack check = CraftTweakerMC.getItemStack((IItemStack)stack);
        RemoveRecipeAction<IExtremeRecipe> action = new RemoveRecipeAction<IExtremeRecipe>("Extreme Shapeless", AvaritiaRecipeManager.EXTREME_RECIPES, recipes -> recipes.stream().filter(r -> !r.isShapedRecipe()).filter(r -> r.getRecipeOutput().func_77969_a(check)).map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), stack.getDisplayName());
        CraftTweakerAPI.apply(action);
    }

    @ZenMethod
    public static void removeAll() {
        RemoveRecipeAction<IExtremeRecipe> action = new RemoveRecipeAction<IExtremeRecipe>("All Extreme", AvaritiaRecipeManager.EXTREME_RECIPES, recipes -> recipes.stream().map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), "");
        CraftTweakerAPI.apply(action);
    }

    @ZenMethod
    public static void removeAllShaped() {
        RemoveRecipeAction<IExtremeRecipe> action = new RemoveRecipeAction<IExtremeRecipe>("All Extreme Shaped", AvaritiaRecipeManager.EXTREME_RECIPES, recipes -> recipes.stream().filter(IExtremeRecipe::isShapedRecipe).map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), "");
        CraftTweakerAPI.apply(action);
    }

    @ZenMethod
    public static void removeAllShapeless() {
        RemoveRecipeAction<IExtremeRecipe> action = new RemoveRecipeAction<IExtremeRecipe>("All Extreme Shapeless", AvaritiaRecipeManager.EXTREME_RECIPES, recipes -> recipes.stream().filter(r -> !r.isShapedRecipe()).map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), "");
        CraftTweakerAPI.apply(action);
    }

    private static IAction createAction(IExtremeRecipe recipe) {
        AddRecipeAction<IExtremeRecipe> action = new AddRecipeAction<IExtremeRecipe>(recipe, AvaritiaRecipeManager.EXTREME_RECIPES);
        action.setDesc("Extreme");
        action.setOutputAccessor(r -> r.getRecipeOutput().func_82833_r());
        return action;
    }

    private static NonNullList<Ingredient> getIngredients(IIngredient[] input) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (IIngredient ing : input) {
            ingredients.add(ing == null ? Ingredient.field_193370_a : new CTIngredientWrapper(ing));
        }
        return ingredients;
    }
}

